/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.flink.hadoop.shaded.org.codehaus.jackson.JsonFactory;
import org.apache.flink.hadoop.shaded.org.codehaus.jackson.JsonGenerationException;
import org.apache.flink.hadoop.shaded.org.codehaus.jackson.JsonGenerator;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.mapred.DeprecatedQueueConfigurationParser;
import org.apache.hadoop.mapred.JobQueueInfo;
import org.apache.hadoop.mapred.Queue;
import org.apache.hadoop.mapred.QueueACL;
import org.apache.hadoop.mapred.QueueAclsInfo;
import org.apache.hadoop.mapred.QueueConfigurationParser;
import org.apache.hadoop.mapred.QueueRefresher;
import org.apache.hadoop.mapreduce.QueueState;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
public class QueueManager {
    private static final Log LOG = LogFactory.getLog(QueueManager.class);
    private Map<String, Queue> leafQueues = new HashMap<String, Queue>();
    private Map<String, Queue> allQueues = new HashMap<String, Queue>();
    public static final String QUEUE_CONF_FILE_NAME = "mapred-queues.xml";
    static final String QUEUE_CONF_DEFAULT_FILE_NAME = "mapred-queues-default.xml";
    static final String QUEUE_CONF_PROPERTY_NAME_PREFIX = "mapred.queue.";
    private Queue root = null;
    private boolean areAclsEnabled = false;
    static final String MSG_REFRESH_FAILURE_WITH_CHANGE_OF_HIERARCHY = "Unable to refresh queues because queue-hierarchy changed. Retaining existing configuration. ";
    static final String MSG_REFRESH_FAILURE_WITH_SCHEDULER_FAILURE = "Scheduler couldn't refresh it's queues with the new configuration properties. Retaining existing configuration throughout the system.";

    static QueueConfigurationParser getQueueConfigurationParser(Configuration conf, boolean reloadConf, boolean areAclsEnabled) {
        if (conf != null && conf.get("mapred.queue.names") != null) {
            if (reloadConf) {
                conf.reloadConfiguration();
            }
            return new DeprecatedQueueConfigurationParser(conf);
        }
        URL xmlInUrl = Thread.currentThread().getContextClassLoader().getResource(QUEUE_CONF_FILE_NAME);
        if (xmlInUrl == null) {
            xmlInUrl = Thread.currentThread().getContextClassLoader().getResource(QUEUE_CONF_DEFAULT_FILE_NAME);
            assert (xmlInUrl != null);
        }
        InputStream stream = null;
        try {
            stream = xmlInUrl.openStream();
            QueueConfigurationParser queueConfigurationParser = new QueueConfigurationParser(new BufferedInputStream(stream), areAclsEnabled);
            return queueConfigurationParser;
        }
        catch (IOException ioe) {
            throw new RuntimeException("Couldn't open queue configuration at " + xmlInUrl, ioe);
        }
        finally {
            IOUtils.closeStream(stream);
        }
    }

    QueueManager() {
        this(false);
    }

    QueueManager(boolean areAclsEnabled) {
        this.areAclsEnabled = areAclsEnabled;
        this.initialize(QueueManager.getQueueConfigurationParser(null, false, areAclsEnabled));
    }

    public QueueManager(Configuration clusterConf) {
        this.areAclsEnabled = clusterConf.getBoolean("mapreduce.cluster.acls.enabled", false);
        this.initialize(QueueManager.getQueueConfigurationParser(clusterConf, false, this.areAclsEnabled));
    }

    QueueManager(String confFile, boolean areAclsEnabled) {
        this.areAclsEnabled = areAclsEnabled;
        QueueConfigurationParser cp = new QueueConfigurationParser(confFile, areAclsEnabled);
        this.initialize(cp);
    }

    private void initialize(QueueConfigurationParser cp) {
        this.root = cp.getRoot();
        this.leafQueues.clear();
        this.allQueues.clear();
        this.leafQueues = this.getRoot().getLeafQueues();
        this.allQueues.putAll(this.getRoot().getInnerQueues());
        this.allQueues.putAll(this.leafQueues);
        LOG.info("AllQueues : " + this.allQueues + "; LeafQueues : " + this.leafQueues);
    }

    public synchronized Set<String> getLeafQueueNames() {
        return this.leafQueues.keySet();
    }

    public synchronized boolean hasAccess(String queueName, QueueACL qACL, UserGroupInformation ugi) {
        AccessControlList acl;
        Queue q = this.leafQueues.get(queueName);
        if (q == null) {
            LOG.info("Queue " + queueName + " is not present");
            return false;
        }
        if (q.getChildren() != null && !q.getChildren().isEmpty()) {
            LOG.info("Cannot submit job to parent queue " + q.getName());
            return false;
        }
        if (!this.areAclsEnabled()) {
            return true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Checking access for the acl " + QueueManager.toFullPropertyName(queueName, qACL.getAclName()) + " for user " + ugi.getShortUserName());
        }
        if ((acl = q.getAcls().get(QueueManager.toFullPropertyName(queueName, qACL.getAclName()))) == null) {
            return false;
        }
        return acl.isUserAllowed(ugi);
    }

    synchronized boolean isRunning(String queueName) {
        Queue q = this.leafQueues.get(queueName);
        if (q != null) {
            return q.getState().equals((Object)QueueState.RUNNING);
        }
        return false;
    }

    public synchronized void setSchedulerInfo(String queueName, Object queueInfo) {
        if (this.allQueues.get(queueName) != null) {
            this.allQueues.get(queueName).setSchedulingInfo(queueInfo);
        }
    }

    public synchronized Object getSchedulerInfo(String queueName) {
        if (this.allQueues.get(queueName) != null) {
            return this.allQueues.get(queueName).getSchedulingInfo();
        }
        return null;
    }

    synchronized void refreshQueues(Configuration conf, QueueRefresher schedulerRefresher) throws IOException {
        QueueConfigurationParser cp = QueueManager.getQueueConfigurationParser(conf, true, this.areAclsEnabled);
        if (!this.root.isHierarchySameAs(cp.getRoot())) {
            LOG.warn(MSG_REFRESH_FAILURE_WITH_CHANGE_OF_HIERARCHY);
            throw new IOException(MSG_REFRESH_FAILURE_WITH_CHANGE_OF_HIERARCHY);
        }
        if (schedulerRefresher != null) {
            try {
                schedulerRefresher.refreshQueues(cp.getRoot().getJobQueueInfo().getChildren());
            }
            catch (Throwable e) {
                StringBuilder msg = new StringBuilder("Scheduler's refresh-queues failed with the exception : " + StringUtils.stringifyException(e));
                msg.append("\n");
                msg.append(MSG_REFRESH_FAILURE_WITH_SCHEDULER_FAILURE);
                LOG.error(msg.toString());
                throw new IOException(msg.toString());
            }
        }
        cp.getRoot().copySchedulingInfo(this.root);
        this.initialize(cp);
        LOG.info("Queue configuration is refreshed successfully.");
    }

    public static final String toFullPropertyName(String queue, String property) {
        return QUEUE_CONF_PROPERTY_NAME_PREFIX + queue + "." + property;
    }

    synchronized JobQueueInfo[] getJobQueueInfos() {
        ArrayList<JobQueueInfo> queueInfoList = new ArrayList<JobQueueInfo>();
        for (String queue : this.allQueues.keySet()) {
            JobQueueInfo queueInfo = this.getJobQueueInfo(queue);
            if (queueInfo == null) continue;
            queueInfoList.add(queueInfo);
        }
        return queueInfoList.toArray(new JobQueueInfo[queueInfoList.size()]);
    }

    synchronized JobQueueInfo getJobQueueInfo(String queue) {
        if (this.allQueues.containsKey(queue)) {
            return this.allQueues.get(queue).getJobQueueInfo();
        }
        return null;
    }

    synchronized Map<String, JobQueueInfo> getJobQueueInfoMapping() {
        HashMap<String, JobQueueInfo> m = new HashMap<String, JobQueueInfo>();
        for (Map.Entry<String, Queue> entry : this.allQueues.entrySet()) {
            m.put(entry.getKey(), entry.getValue().getJobQueueInfo());
        }
        return m;
    }

    synchronized QueueAclsInfo[] getQueueAcls(UserGroupInformation ugi) throws IOException {
        ArrayList<QueueAclsInfo> queueAclsInfolist = new ArrayList<QueueAclsInfo>();
        QueueACL[] qAcls = QueueACL.values();
        for (String queueName : this.leafQueues.keySet()) {
            QueueAclsInfo queueAclsInfo = null;
            ArrayList<String> operationsAllowed = null;
            for (QueueACL qAcl : qAcls) {
                if (!this.hasAccess(queueName, qAcl, ugi)) continue;
                if (operationsAllowed == null) {
                    operationsAllowed = new ArrayList<String>();
                }
                operationsAllowed.add(qAcl.getAclName());
            }
            if (operationsAllowed == null) continue;
            queueAclsInfo = new QueueAclsInfo(queueName, operationsAllowed.toArray(new String[operationsAllowed.size()]));
            queueAclsInfolist.add(queueAclsInfo);
        }
        return queueAclsInfolist.toArray(new QueueAclsInfo[queueAclsInfolist.size()]);
    }

    boolean areAclsEnabled() {
        return this.areAclsEnabled;
    }

    Queue getRoot() {
        return this.root;
    }

    static void dumpConfiguration(Writer out, Configuration conf) throws IOException {
        QueueManager.dumpConfiguration(out, null, conf);
    }

    static void dumpConfiguration(Writer out, String configFile, Configuration conf) throws IOException {
        if (conf != null && conf.get("mapred.queue.names") != null) {
            return;
        }
        JsonFactory dumpFactory = new JsonFactory();
        JsonGenerator dumpGenerator = dumpFactory.createJsonGenerator(out);
        boolean aclsEnabled = false;
        if (conf != null) {
            aclsEnabled = conf.getBoolean("mapreduce.cluster.acls.enabled", false);
        }
        QueueConfigurationParser parser = configFile != null && !"".equals(configFile) ? new QueueConfigurationParser(configFile, aclsEnabled) : QueueManager.getQueueConfigurationParser(null, false, aclsEnabled);
        dumpGenerator.writeStartObject();
        dumpGenerator.writeFieldName("queues");
        dumpGenerator.writeStartArray();
        QueueManager.dumpConfiguration(dumpGenerator, parser.getRoot().getChildren());
        dumpGenerator.writeEndArray();
        dumpGenerator.writeEndObject();
        dumpGenerator.flush();
    }

    private static void dumpConfiguration(JsonGenerator dumpGenerator, Set<Queue> rootQueues) throws JsonGenerationException, IOException {
        for (Queue queue : rootQueues) {
            dumpGenerator.writeStartObject();
            dumpGenerator.writeStringField("name", queue.getName());
            dumpGenerator.writeStringField("state", queue.getState().toString());
            AccessControlList submitJobList = null;
            AccessControlList administerJobsList = null;
            if (queue.getAcls() != null) {
                submitJobList = queue.getAcls().get(QueueManager.toFullPropertyName(queue.getName(), QueueACL.SUBMIT_JOB.getAclName()));
                administerJobsList = queue.getAcls().get(QueueManager.toFullPropertyName(queue.getName(), QueueACL.ADMINISTER_JOBS.getAclName()));
            }
            String aclsSubmitJobValue = " ";
            if (submitJobList != null) {
                aclsSubmitJobValue = submitJobList.getAclString();
            }
            dumpGenerator.writeStringField("acl_submit_job", aclsSubmitJobValue);
            String aclsAdministerValue = " ";
            if (administerJobsList != null) {
                aclsAdministerValue = administerJobsList.getAclString();
            }
            dumpGenerator.writeStringField("acl_administer_jobs", aclsAdministerValue);
            dumpGenerator.writeFieldName("properties");
            dumpGenerator.writeStartArray();
            if (queue.getProperties() != null) {
                for (Map.Entry<Object, Object> property : queue.getProperties().entrySet()) {
                    dumpGenerator.writeStartObject();
                    dumpGenerator.writeStringField("key", (String)property.getKey());
                    dumpGenerator.writeStringField("value", (String)property.getValue());
                    dumpGenerator.writeEndObject();
                }
            }
            dumpGenerator.writeEndArray();
            Set<Queue> childQueues = queue.getChildren();
            dumpGenerator.writeFieldName("children");
            dumpGenerator.writeStartArray();
            if (childQueues != null && childQueues.size() > 0) {
                QueueManager.dumpConfiguration(dumpGenerator, childQueues);
            }
            dumpGenerator.writeEndArray();
            dumpGenerator.writeEndObject();
        }
    }
}

