/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.event;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.flink.hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.util.ShutdownHookManager;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class AsyncDispatcher
extends AbstractService
implements Dispatcher {
    private static final Log LOG = LogFactory.getLog(AsyncDispatcher.class);
    private final BlockingQueue<Event> eventQueue;
    private volatile int lastEventQueueSizeLogged = 0;
    private volatile boolean stopped = false;
    private volatile boolean drainEventsOnStop = false;
    private volatile boolean drained = true;
    private Object waitForDrained = new Object();
    private volatile boolean blockNewEvents = false;
    private final EventHandler handlerInstance = new GenericEventHandler();
    private Thread eventHandlingThread;
    protected final Map<Class<? extends Enum>, EventHandler> eventDispatchers;
    private boolean exitOnDispatchException;

    public AsyncDispatcher() {
        this(new LinkedBlockingQueue<Event>());
    }

    public AsyncDispatcher(BlockingQueue<Event> eventQueue) {
        super("Dispatcher");
        this.eventQueue = eventQueue;
        this.eventDispatchers = new HashMap<Class<? extends Enum>, EventHandler>();
    }

    Runnable createThread() {
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (!AsyncDispatcher.this.stopped && !Thread.currentThread().isInterrupted()) {
                    Event event;
                    AsyncDispatcher.this.drained = AsyncDispatcher.this.eventQueue.isEmpty();
                    if (AsyncDispatcher.this.blockNewEvents) {
                        Object object = AsyncDispatcher.this.waitForDrained;
                        synchronized (object) {
                            if (AsyncDispatcher.this.drained) {
                                AsyncDispatcher.this.waitForDrained.notify();
                            }
                        }
                    }
                    try {
                        event = (Event)AsyncDispatcher.this.eventQueue.take();
                    }
                    catch (InterruptedException ie) {
                        if (!AsyncDispatcher.this.stopped) {
                            LOG.warn("AsyncDispatcher thread interrupted", ie);
                        }
                        return;
                    }
                    if (event == null) continue;
                    AsyncDispatcher.this.dispatch(event);
                }
            }
        };
    }

    @Override
    protected void serviceInit(Configuration conf) throws Exception {
        this.exitOnDispatchException = conf.getBoolean("yarn.dispatcher.exit-on-error", false);
        super.serviceInit(conf);
    }

    @Override
    protected void serviceStart() throws Exception {
        super.serviceStart();
        this.eventHandlingThread = new Thread(this.createThread());
        this.eventHandlingThread.setName("AsyncDispatcher event handler");
        this.eventHandlingThread.start();
    }

    public void setDrainEventsOnStop() {
        this.drainEventsOnStop = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void serviceStop() throws Exception {
        if (this.drainEventsOnStop) {
            this.blockNewEvents = true;
            LOG.info("AsyncDispatcher is draining to stop, igonring any new events.");
            long endTime = System.currentTimeMillis() + this.getConfig().getLong("yarn.dispatcher.drain-events.timeout", 300000L);
            Object object = this.waitForDrained;
            synchronized (object) {
                while (!this.drained && this.eventHandlingThread != null && this.eventHandlingThread.isAlive() && System.currentTimeMillis() < endTime) {
                    this.waitForDrained.wait(1000L);
                    LOG.info("Waiting for AsyncDispatcher to drain. Thread state is :" + (Object)((Object)this.eventHandlingThread.getState()));
                }
            }
        }
        this.stopped = true;
        if (this.eventHandlingThread != null) {
            this.eventHandlingThread.interrupt();
            try {
                this.eventHandlingThread.join();
            }
            catch (InterruptedException ie) {
                LOG.warn("Interrupted Exception while stopping", ie);
            }
        }
        super.serviceStop();
    }

    protected void dispatch(Event event) {
        block4: {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Dispatching the event " + event.getClass().getName() + "." + event.toString());
            }
            Class type = ((Enum)event.getType()).getDeclaringClass();
            try {
                EventHandler handler = this.eventDispatchers.get(type);
                if (handler == null) {
                    throw new Exception("No handler for registered for " + type);
                }
                handler.handle(event);
            }
            catch (Throwable t) {
                LOG.fatal("Error in dispatcher thread", t);
                if (!this.exitOnDispatchException || ShutdownHookManager.get().isShutdownInProgress() || this.stopped) break block4;
                Thread shutDownThread = new Thread(this.createShutDownThread());
                shutDownThread.setName("AsyncDispatcher ShutDown handler");
                shutDownThread.start();
            }
        }
    }

    @Override
    public void register(Class<? extends Enum> eventType, EventHandler handler) {
        EventHandler registeredHandler = this.eventDispatchers.get(eventType);
        LOG.info("Registering " + eventType + " for " + handler.getClass());
        if (registeredHandler == null) {
            this.eventDispatchers.put(eventType, handler);
        } else if (!(registeredHandler instanceof MultiListenerHandler)) {
            MultiListenerHandler multiHandler = new MultiListenerHandler();
            multiHandler.addHandler(registeredHandler);
            multiHandler.addHandler(handler);
            this.eventDispatchers.put(eventType, multiHandler);
        } else {
            MultiListenerHandler multiHandler = (MultiListenerHandler)registeredHandler;
            multiHandler.addHandler(handler);
        }
    }

    @Override
    public EventHandler getEventHandler() {
        return this.handlerInstance;
    }

    Runnable createShutDownThread() {
        return new Runnable(){

            @Override
            public void run() {
                LOG.info("Exiting, bbye..");
                System.exit(-1);
            }
        };
    }

    @VisibleForTesting
    protected boolean isEventThreadWaiting() {
        return this.eventHandlingThread.getState() == Thread.State.WAITING;
    }

    @VisibleForTesting
    protected boolean isDrained() {
        return this.drained;
    }

    static class MultiListenerHandler
    implements EventHandler<Event> {
        List<EventHandler<Event>> listofHandlers = new ArrayList<EventHandler<Event>>();

        @Override
        public void handle(Event event) {
            for (EventHandler<Event> handler : this.listofHandlers) {
                handler.handle(event);
            }
        }

        void addHandler(EventHandler<Event> handler) {
            this.listofHandlers.add(handler);
        }
    }

    class GenericEventHandler
    implements EventHandler<Event> {
        GenericEventHandler() {
        }

        @Override
        public void handle(Event event) {
            int remCapacity;
            if (AsyncDispatcher.this.blockNewEvents) {
                return;
            }
            AsyncDispatcher.this.drained = false;
            int qSize = AsyncDispatcher.this.eventQueue.size();
            if (qSize != 0 && qSize % 1000 == 0 && AsyncDispatcher.this.lastEventQueueSizeLogged != qSize) {
                AsyncDispatcher.this.lastEventQueueSizeLogged = qSize;
                LOG.info("Size of event-queue is " + qSize);
            }
            if ((remCapacity = AsyncDispatcher.this.eventQueue.remainingCapacity()) < 1000) {
                LOG.warn("Very low remaining capacity in the event-queue: " + remCapacity);
            }
            try {
                AsyncDispatcher.this.eventQueue.put(event);
            }
            catch (InterruptedException e) {
                if (!AsyncDispatcher.this.stopped) {
                    LOG.warn("AsyncDispatcher thread interrupted", e);
                }
                AsyncDispatcher.this.drained = AsyncDispatcher.this.eventQueue.isEmpty();
                throw new YarnRuntimeException(e);
            }
        }
    }
}

