/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.shaded.netty4.io.netty.handler.codec.http.router;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpRequest;
import org.apache.flink.shaded.netty4.io.netty.util.ReferenceCounted;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodRouted<T>
implements ReferenceCounted {
    private final T target;
    private final boolean notFound;
    private final HttpRequest request;
    private final String path;
    private final Map<String, String> pathParams;
    private final Map<String, List<String>> queryParams;
    private final ReferenceCounted requestAsReferenceCounted;

    public MethodRouted(T t, boolean bl, HttpRequest httpRequest, String string, Map<String, String> map, Map<String, List<String>> map2) {
        this.target = t;
        this.notFound = bl;
        this.request = httpRequest;
        this.path = string;
        this.pathParams = map;
        this.queryParams = map2;
        this.requestAsReferenceCounted = httpRequest instanceof ReferenceCounted ? (ReferenceCounted)((Object)httpRequest) : null;
    }

    public T target() {
        return this.target;
    }

    public boolean notFound() {
        return this.notFound;
    }

    public HttpRequest request() {
        return this.request;
    }

    public String path() {
        return this.path;
    }

    public Map<String, String> pathParams() {
        return this.pathParams;
    }

    public Map<String, List<String>> queryParams() {
        return this.queryParams;
    }

    public String queryParam(String string) {
        List<String> list = this.queryParams.get(string);
        return list == null ? null : list.get(0);
    }

    public String param(String string) {
        String string2 = this.pathParams.get(string);
        return string2 == null ? this.queryParam(string) : string2;
    }

    public List<String> params(String string) {
        String string2;
        List<String> list = this.queryParams.get(string);
        if (list == null) {
            list = new ArrayList<String>();
        }
        if ((string2 = this.pathParams.get(string)) != null) {
            list.add(string2);
        }
        return list;
    }

    @Override
    public int refCnt() {
        return this.requestAsReferenceCounted == null ? 0 : this.requestAsReferenceCounted.refCnt();
    }

    @Override
    public boolean release() {
        return this.requestAsReferenceCounted == null ? true : this.requestAsReferenceCounted.release();
    }

    @Override
    public boolean release(int n) {
        return this.requestAsReferenceCounted == null ? true : this.requestAsReferenceCounted.release(n);
    }

    @Override
    public ReferenceCounted retain() {
        if (this.requestAsReferenceCounted != null) {
            this.requestAsReferenceCounted.retain();
        }
        return this;
    }

    @Override
    public ReferenceCounted retain(int n) {
        if (this.requestAsReferenceCounted != null) {
            this.requestAsReferenceCounted.retain(n);
        }
        return this;
    }
}

