/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.v3.core.jackson;

import io.swagger.v3.core.jackson.PackageVersion;
import io.swagger.v3.core.util.AnnotationsUtils;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.Version;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.AnnotationIntrospector;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.introspect.Annotated;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.jsontype.NamedType;

public class SwaggerAnnotationIntrospector
extends AnnotationIntrospector {
    private static final long serialVersionUID = 1L;

    public Version version() {
        return PackageVersion.VERSION;
    }

    public Boolean hasRequiredMarker(AnnotatedMember m) {
        XmlElement elem = (XmlElement)m.getAnnotation(XmlElement.class);
        if (elem != null && elem.required()) {
            return true;
        }
        JsonProperty jsonProperty = (JsonProperty)m.getAnnotation(JsonProperty.class);
        if (jsonProperty != null && jsonProperty.required()) {
            return true;
        }
        Schema ann = (Schema)m.getAnnotation(Schema.class);
        if (ann != null && ann.required()) {
            return ann.required();
        }
        ArraySchema arraySchema = (ArraySchema)m.getAnnotation(ArraySchema.class);
        if (arraySchema != null) {
            if (arraySchema.arraySchema().required()) {
                return arraySchema.arraySchema().required();
            }
            if (arraySchema.schema().required()) {
                return arraySchema.schema().required();
            }
        }
        return null;
    }

    public String findPropertyDescription(Annotated a) {
        Schema model = (Schema)a.getAnnotation(Schema.class);
        if (model != null && !"".equals(model.description())) {
            return model.description();
        }
        return null;
    }

    public List<NamedType> findSubtypes(Annotated a) {
        ArraySchema arraySchema;
        Schema schema = (Schema)a.getAnnotation(Schema.class);
        if (schema == null && (arraySchema = (ArraySchema)a.getAnnotation(ArraySchema.class)) != null) {
            schema = arraySchema.schema();
        }
        if (AnnotationsUtils.hasSchemaAnnotation(schema)) {
            Class<?>[] classes = schema.subTypes();
            ArrayList<NamedType> names = new ArrayList<NamedType>(classes.length);
            for (Class<?> subType : classes) {
                names.add(new NamedType(subType));
            }
            if (!names.isEmpty()) {
                return names;
            }
        }
        return Collections.emptyList();
    }

    public String findTypeName(AnnotatedClass ac) {
        Schema mp = AnnotationsUtils.getSchemaAnnotation((Annotated)ac);
        if (mp != null && !mp.name().isEmpty()) {
            return mp.name();
        }
        return null;
    }
}

