/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.shaded.zookeeper3.org.apache.zookeeper;

import java.util.Date;
import java.util.Random;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.flink.shaded.zookeeper3.org.apache.zookeeper.Shell;
import org.apache.flink.shaded.zookeeper3.org.apache.zookeeper.client.ZKClientConfig;
import org.apache.flink.shaded.zookeeper3.org.apache.zookeeper.common.Time;
import org.apache.flink.shaded.zookeeper3.org.apache.zookeeper.common.ZKConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Login {
    private static final String KINIT_COMMAND_DEFAULT = "/usr/bin/kinit";
    private static final Logger LOG = LoggerFactory.getLogger(Login.class);
    public CallbackHandler callbackHandler;
    private static final float TICKET_RENEW_WINDOW = 0.8f;
    private static final float TICKET_RENEW_JITTER = 0.05f;
    private static final long MIN_TIME_BEFORE_RELOGIN = 60000L;
    private Subject subject = null;
    private Thread t = null;
    private boolean isKrbTicket = false;
    private boolean isUsingTicketCache = false;
    private static Random rng = new Random();
    private LoginContext login = null;
    private String loginContextName = null;
    private String principal = null;
    private long lastLogin = Time.currentElapsedTime() - 60000L;
    private final ZKConfig zkConfig;

    public Login(String loginContextName, CallbackHandler callbackHandler, final ZKConfig zkConfig) throws LoginException {
        AppConfigurationEntry[] entries;
        this.zkConfig = zkConfig;
        this.callbackHandler = callbackHandler;
        this.login = this.login(loginContextName);
        this.loginContextName = loginContextName;
        this.subject = this.login.getSubject();
        this.isKrbTicket = !this.subject.getPrivateCredentials(KerberosTicket.class).isEmpty();
        AppConfigurationEntry[] appConfigurationEntryArray = entries = Configuration.getConfiguration().getAppConfigurationEntry(loginContextName);
        int n = appConfigurationEntryArray.length;
        int n2 = 0;
        if (n2 < n) {
            String val;
            AppConfigurationEntry entry = appConfigurationEntryArray[n2];
            if (entry.getOptions().get("useTicketCache") != null && (val = (String)entry.getOptions().get("useTicketCache")).equals("true")) {
                this.isUsingTicketCache = true;
            }
            if (entry.getOptions().get("principal") != null) {
                this.principal = (String)entry.getOptions().get("principal");
            }
        }
        if (!this.isKrbTicket) {
            return;
        }
        this.t = new Thread(new Runnable(){

            @Override
            public void run() {
                LOG.info("TGT refresh thread started.");
                block12: while (true) {
                    block28: {
                        Date nextRefreshDate;
                        long nextRefresh;
                        KerberosTicket tgt = Login.this.getTGT();
                        long now = Time.currentWallTime();
                        if (tgt == null) {
                            nextRefresh = now + 60000L;
                            nextRefreshDate = new Date(nextRefresh);
                            LOG.warn("No TGT found: will try again at {}", (Object)nextRefreshDate);
                        } else {
                            Object[] logPayload;
                            nextRefresh = Login.this.getRefreshTime(tgt);
                            long expiry = tgt.getEndTime().getTime();
                            Date expiryDate = new Date(expiry);
                            if (Login.this.isUsingTicketCache && tgt.getEndTime().equals(tgt.getRenewTill())) {
                                logPayload = new Object[]{expiryDate, Login.this.principal, Login.this.principal};
                                LOG.error("The TGT cannot be renewed beyond the next expiry date: {}.This process will not be able to authenticate new SASL connections after that time (for example, it will not be authenticate a new connection with a Zookeeper Quorum member).  Ask your system administrator to either increase the 'renew until' time by doing : 'modprinc -maxrenewlife {}' within kadmin, or instead, to generate a keytab for {}. Because the TGT's expiry cannot be further extended by refreshing, exiting refresh thread now.", logPayload);
                                return;
                            }
                            if (nextRefresh > expiry || now + 60000L > expiry) {
                                nextRefresh = now;
                            } else {
                                if (nextRefresh < now + 60000L) {
                                    Date until = new Date(nextRefresh);
                                    Date newuntil = new Date(now + 60000L);
                                    Object[] logPayload2 = new Object[]{until, newuntil, 60L};
                                    LOG.warn("TGT refresh thread time adjusted from : {} to : {} since the former is sooner than the minimum refresh interval ({} seconds) from now.", logPayload2);
                                }
                                nextRefresh = Math.max(nextRefresh, now + 60000L);
                            }
                            nextRefreshDate = new Date(nextRefresh);
                            if (nextRefresh > expiry) {
                                logPayload = new Object[]{nextRefreshDate, expiryDate};
                                LOG.error("next refresh: {} is later than expiry {}. This may indicate a clock skew problem. Check that this host and the KDC's hosts' clocks are in sync. Exiting refresh thread.", logPayload);
                                return;
                            }
                        }
                        if (now == nextRefresh) {
                            LOG.info("refreshing now because expiry is before next scheduled refresh time.");
                        } else {
                            if (now < nextRefresh) {
                                Date until = new Date(nextRefresh);
                                LOG.info("TGT refresh sleeping until: {}", (Object)until.toString());
                                try {
                                    Thread.sleep(nextRefresh - now);
                                    break block28;
                                }
                                catch (InterruptedException ie) {
                                    LOG.warn("TGT renewal thread has been interrupted and will exit.");
                                    break;
                                }
                            }
                            LOG.error("nextRefresh:{} is in the past: exiting refresh thread. Check clock sync between this host and KDC - (KDC's clock is likely ahead of this host). Manual intervention will be required for this client to successfully authenticate. Exiting refresh thread.", (Object)nextRefreshDate);
                            break;
                        }
                    }
                    if (Login.this.isUsingTicketCache) {
                        String cmd = zkConfig.getProperty("zookeeper.kinit", Login.KINIT_COMMAND_DEFAULT);
                        String kinitArgs = "-R";
                        for (int retry = 1; retry >= 0; --retry) {
                            try {
                                LOG.debug("running ticket cache refresh command: {} {}", (Object)cmd, (Object)kinitArgs);
                                Shell.execCommand(cmd, kinitArgs);
                                break;
                            }
                            catch (Exception e) {
                                if (retry > 0) {
                                    try {
                                        Thread.sleep(10000L);
                                        continue;
                                    }
                                    catch (InterruptedException ie) {
                                        LOG.error("Interrupted while renewing TGT, exiting Login thread");
                                        return;
                                    }
                                }
                                Object[] logPayload = new Object[]{cmd, kinitArgs, e.toString(), e};
                                LOG.warn("Could not renew TGT due to problem running shell command: '{} {}'; exception was:{}. Exiting refresh thread.", logPayload);
                                return;
                            }
                        }
                    }
                    try {
                        int retry = 1;
                        while (true) {
                            if (retry < 0) continue block12;
                            try {
                                Login.this.reLogin();
                                continue block12;
                            }
                            catch (LoginException le) {
                                if (retry > 0) {
                                    --retry;
                                    try {
                                        Thread.sleep(10000L);
                                        continue;
                                    }
                                    catch (InterruptedException e) {
                                        LOG.error("Interrupted during login retry after LoginException:", (Throwable)le);
                                        throw le;
                                    }
                                }
                                LOG.error("Could not refresh TGT for principal: {}.", (Object)Login.this.principal, (Object)le);
                                continue;
                            }
                            break;
                        }
                    }
                    catch (LoginException le) {
                        LOG.error("Failed to refresh TGT: refresh thread exiting now.", (Throwable)le);
                        break;
                    }
                }
            }
        });
        this.t.setDaemon(true);
    }

    public void startThreadIfNeeded() {
        if (this.t != null) {
            this.t.start();
        }
    }

    public void shutdown() {
        if (this.t != null && this.t.isAlive()) {
            this.t.interrupt();
            try {
                this.t.join();
            }
            catch (InterruptedException e) {
                LOG.warn("error while waiting for Login thread to shutdown: ", (Throwable)e);
            }
        }
    }

    public Subject getSubject() {
        return this.subject;
    }

    public String getLoginContextName() {
        return this.loginContextName;
    }

    private synchronized LoginContext login(String loginContextName) throws LoginException {
        if (loginContextName == null) {
            throw new LoginException("loginContext name (JAAS file section header) was null. Please check your java.security.login.auth.config (=" + System.getProperty("java.security.login.auth.config") + ") and your " + this.getLoginContextMessage());
        }
        LoginContext loginContext = new LoginContext(loginContextName, this.callbackHandler);
        loginContext.login();
        LOG.info("{} successfully logged in.", (Object)loginContextName);
        return loginContext;
    }

    private String getLoginContextMessage() {
        if (this.zkConfig instanceof ZKClientConfig) {
            return "zookeeper.sasl.clientconfig(=" + this.zkConfig.getProperty("zookeeper.sasl.clientconfig", "Client") + ")";
        }
        return "zookeeper.sasl.serverconfig(=" + System.getProperty("zookeeper.sasl.serverconfig", "Server") + ")";
    }

    private long getRefreshTime(KerberosTicket tgt) {
        long start = tgt.getStartTime().getTime();
        long expires = tgt.getEndTime().getTime();
        LOG.info("TGT valid starting at:        {}", (Object)tgt.getStartTime().toString());
        LOG.info("TGT expires:                  {}", (Object)tgt.getEndTime().toString());
        long proposedRefresh = start + (long)((double)(expires - start) * ((double)0.8f + (double)0.05f * rng.nextDouble()));
        if (proposedRefresh > expires) {
            return Time.currentWallTime();
        }
        return proposedRefresh;
    }

    private synchronized KerberosTicket getTGT() {
        Set<KerberosTicket> tickets = this.subject.getPrivateCredentials(KerberosTicket.class);
        for (KerberosTicket ticket : tickets) {
            KerberosPrincipal server = ticket.getServer();
            if (!server.getName().equals("krbtgt/" + server.getRealm() + "@" + server.getRealm())) continue;
            LOG.debug("Client principal is \"" + ticket.getClient().getName() + "\".");
            LOG.debug("Server principal is \"" + ticket.getServer().getName() + "\".");
            return ticket;
        }
        return null;
    }

    private boolean hasSufficientTimeElapsed() {
        long now = Time.currentElapsedTime();
        if (now - this.getLastLogin() < 60000L) {
            LOG.warn("Not attempting to re-login since the last re-login was attempted less than {} seconds before.", (Object)60L);
            return false;
        }
        this.setLastLogin(now);
        return true;
    }

    private LoginContext getLogin() {
        return this.login;
    }

    private void setLogin(LoginContext login) {
        this.login = login;
    }

    private void setLastLogin(long time) {
        this.lastLogin = time;
    }

    private long getLastLogin() {
        return this.lastLogin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void reLogin() throws LoginException {
        if (!this.isKrbTicket) {
            return;
        }
        LoginContext login = this.getLogin();
        if (login == null) {
            throw new LoginException("login must be done first");
        }
        if (!this.hasSufficientTimeElapsed()) {
            return;
        }
        LOG.info("Initiating logout for {}", (Object)this.principal);
        Class<Login> clazz = Login.class;
        synchronized (Login.class) {
            login.logout();
            login = new LoginContext(this.loginContextName, this.getSubject());
            LOG.info("Initiating re-login for {}", (Object)this.principal);
            login.login();
            this.setLogin(login);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }
}

