/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.elasticsearch.sink;

import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.connector.elasticsearch.sink.BulkProcessorBuilderFactory;
import org.apache.flink.connector.elasticsearch.sink.BulkProcessorConfig;
import org.apache.flink.connector.elasticsearch.sink.BulkRequestConsumerFactory;
import org.apache.flink.connector.elasticsearch.sink.ElasticsearchEmitter;
import org.apache.flink.connector.elasticsearch.sink.ElasticsearchSinkBuilderBase;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.ActionListener;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.bulk.BackoffPolicy;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.bulk.BulkProcessor;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.bulk.BulkRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.bulk.BulkResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.RequestOptions;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.RestHighLevelClient;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.unit.ByteSizeUnit;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.unit.ByteSizeValue;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.unit.TimeValue;

@PublicEvolving
public class Elasticsearch7SinkBuilder<IN>
extends ElasticsearchSinkBuilderBase<IN, Elasticsearch7SinkBuilder<IN>> {
    public <T extends IN> Elasticsearch7SinkBuilder<T> setEmitter(ElasticsearchEmitter<? super T> emitter) {
        super.setEmitter(emitter);
        return (Elasticsearch7SinkBuilder)this.self();
    }

    @Override
    protected BulkProcessorBuilderFactory getBulkProcessorBuilderFactory() {
        return new BulkProcessorBuilderFactory(){

            public BulkProcessor.Builder apply(final RestHighLevelClient client, BulkProcessorConfig bulkProcessorConfig, BulkProcessor.Listener listener) {
                BackoffPolicy backoffPolicy;
                BulkProcessor.Builder builder = BulkProcessor.builder(new BulkRequestConsumerFactory(){

                    @Override
                    public void accept(BulkRequest bulkRequest, ActionListener<BulkResponse> bulkResponseActionListener) {
                        client.bulkAsync(bulkRequest, RequestOptions.DEFAULT, bulkResponseActionListener);
                    }
                }, listener);
                if (bulkProcessorConfig.getBulkFlushMaxActions() != -1) {
                    builder.setBulkActions(bulkProcessorConfig.getBulkFlushMaxActions());
                }
                if (bulkProcessorConfig.getBulkFlushMaxMb() != -1) {
                    builder.setBulkSize(new ByteSizeValue(bulkProcessorConfig.getBulkFlushMaxMb(), ByteSizeUnit.MB));
                }
                if (bulkProcessorConfig.getBulkFlushInterval() != -1L) {
                    builder.setFlushInterval(new TimeValue(bulkProcessorConfig.getBulkFlushInterval()));
                }
                TimeValue backoffDelay = new TimeValue(bulkProcessorConfig.getBulkFlushBackOffDelay());
                int maxRetryCount = bulkProcessorConfig.getBulkFlushBackoffRetries();
                switch (bulkProcessorConfig.getFlushBackoffType()) {
                    case CONSTANT: {
                        backoffPolicy = BackoffPolicy.constantBackoff(backoffDelay, maxRetryCount);
                        break;
                    }
                    case EXPONENTIAL: {
                        backoffPolicy = BackoffPolicy.exponentialBackoff(backoffDelay, maxRetryCount);
                        break;
                    }
                    case NONE: {
                        backoffPolicy = BackoffPolicy.noBackoff();
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Received unknown backoff policy type " + (Object)((Object)bulkProcessorConfig.getFlushBackoffType()));
                    }
                }
                builder.setBackoffPolicy(backoffPolicy);
                return builder;
            }
        };
    }
}

