/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.elasticsearch.table;

import java.time.ZoneId;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.connector.elasticsearch.sink.ElasticsearchSinkBuilderBase;
import org.apache.flink.connector.elasticsearch.sink.FlushBackoffType;
import org.apache.flink.connector.elasticsearch.table.ElasticsearchConfiguration;
import org.apache.flink.connector.elasticsearch.table.ElasticsearchSinkBuilderSupplier;
import org.apache.flink.connector.elasticsearch.table.IndexGenerator;
import org.apache.flink.connector.elasticsearch.table.IndexGeneratorFactory;
import org.apache.flink.connector.elasticsearch.table.KeyExtractor;
import org.apache.flink.connector.elasticsearch.table.LogicalTypeWithIndex;
import org.apache.flink.connector.elasticsearch.table.RowElasticsearchEmitter;
import org.apache.flink.elasticsearch7.shaded.org.apache.http.HttpHost;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentType;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.format.EncodingFormat;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.sink.SinkV2Provider;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.DataType;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.StringUtils;

@Internal
class ElasticsearchDynamicSink
implements DynamicTableSink {
    final EncodingFormat<SerializationSchema<RowData>> format;
    final DataType physicalRowDataType;
    final List<LogicalTypeWithIndex> primaryKeyLogicalTypesWithIndex;
    final ElasticsearchConfiguration config;
    final ZoneId localTimeZoneId;
    final String summaryString;
    final ElasticsearchSinkBuilderSupplier<RowData> builderSupplier;
    @Nullable
    final String documentType;
    final boolean isDynamicIndexWithSystemTime;

    ElasticsearchDynamicSink(EncodingFormat<SerializationSchema<RowData>> format, ElasticsearchConfiguration config, List<LogicalTypeWithIndex> primaryKeyLogicalTypesWithIndex, DataType physicalRowDataType, String summaryString, ElasticsearchSinkBuilderSupplier<RowData> builderSupplier, @Nullable String documentType, ZoneId localTimeZoneId) {
        this.format = (EncodingFormat)Preconditions.checkNotNull(format);
        this.physicalRowDataType = (DataType)Preconditions.checkNotNull((Object)physicalRowDataType);
        this.primaryKeyLogicalTypesWithIndex = (List)Preconditions.checkNotNull(primaryKeyLogicalTypesWithIndex);
        this.config = (ElasticsearchConfiguration)Preconditions.checkNotNull((Object)config);
        this.summaryString = (String)Preconditions.checkNotNull((Object)summaryString);
        this.builderSupplier = (ElasticsearchSinkBuilderSupplier)Preconditions.checkNotNull(builderSupplier);
        this.documentType = documentType;
        this.localTimeZoneId = localTimeZoneId;
        this.isDynamicIndexWithSystemTime = this.isDynamicIndexWithSystemTime();
    }

    public boolean isDynamicIndexWithSystemTime() {
        IndexGeneratorFactory.IndexHelper indexHelper = new IndexGeneratorFactory.IndexHelper();
        return indexHelper.checkIsDynamicIndexWithSystemTimeFormat(this.config.getIndex());
    }

    Function<RowData, String> createKeyExtractor() {
        return KeyExtractor.createKeyExtractor(this.primaryKeyLogicalTypesWithIndex, this.config.getKeyDelimiter());
    }

    IndexGenerator createIndexGenerator() {
        return IndexGeneratorFactory.createIndexGenerator(this.config.getIndex(), DataType.getFieldNames((DataType)this.physicalRowDataType), DataType.getFieldDataTypes((DataType)this.physicalRowDataType), this.localTimeZoneId);
    }

    public ChangelogMode getChangelogMode(ChangelogMode requestedMode) {
        ChangelogMode.Builder builder = ChangelogMode.newBuilder();
        for (RowKind kind : requestedMode.getContainedKinds()) {
            if (kind == RowKind.UPDATE_BEFORE) continue;
            builder.addContainedKind(kind);
        }
        if (this.isDynamicIndexWithSystemTime && !requestedMode.containsOnly(RowKind.INSERT)) {
            throw new ValidationException("Dynamic indexing based on system time only works on append only stream.");
        }
        return builder.build();
    }

    public DynamicTableSink.SinkRuntimeProvider getSinkRuntimeProvider(DynamicTableSink.Context context) {
        SerializationSchema format = (SerializationSchema)this.format.createRuntimeEncoder(context, this.physicalRowDataType);
        RowElasticsearchEmitter rowElasticsearchEmitter = new RowElasticsearchEmitter(this.createIndexGenerator(), (SerializationSchema<RowData>)format, XContentType.JSON, this.documentType, this.createKeyExtractor());
        ElasticsearchSinkBuilderBase builder = (ElasticsearchSinkBuilderBase)this.builderSupplier.get();
        builder.setEmitter(rowElasticsearchEmitter);
        builder.setHosts(this.config.getHosts().toArray(new HttpHost[0]));
        builder.setDeliveryGuarantee(this.config.getDeliveryGuarantee());
        builder.setBulkFlushMaxActions(this.config.getBulkFlushMaxActions());
        builder.setBulkFlushMaxSizeMb(this.config.getBulkFlushMaxByteSize().getMebiBytes());
        builder.setBulkFlushInterval(this.config.getBulkFlushInterval());
        if (this.config.getBulkFlushBackoffType().isPresent()) {
            FlushBackoffType backoffType = this.config.getBulkFlushBackoffType().get();
            int backoffMaxRetries = this.config.getBulkFlushBackoffRetries().get();
            long backoffDelayMs = this.config.getBulkFlushBackoffDelay().get();
            builder.setBulkFlushBackoffStrategy(backoffType, backoffMaxRetries, backoffDelayMs);
        }
        if (this.config.getUsername().isPresent() && !StringUtils.isNullOrWhitespaceOnly((String)this.config.getUsername().get())) {
            builder.setConnectionUsername(this.config.getUsername().get());
        }
        if (this.config.getPassword().isPresent() && !StringUtils.isNullOrWhitespaceOnly((String)this.config.getPassword().get())) {
            builder.setConnectionPassword(this.config.getPassword().get());
        }
        if (this.config.getPathPrefix().isPresent() && !StringUtils.isNullOrWhitespaceOnly((String)this.config.getPathPrefix().get())) {
            builder.setConnectionPathPrefix(this.config.getPathPrefix().get());
        }
        if (this.config.getConnectionRequestTimeout().isPresent()) {
            builder.setConnectionRequestTimeout((int)this.config.getConnectionRequestTimeout().get().getSeconds());
        }
        if (this.config.getConnectionTimeout().isPresent()) {
            builder.setConnectionTimeout((int)this.config.getConnectionTimeout().get().getSeconds());
        }
        if (this.config.getSocketTimeout().isPresent()) {
            builder.setSocketTimeout((int)this.config.getSocketTimeout().get().getSeconds());
        }
        return SinkV2Provider.of(builder.build(), (Integer)this.config.getParallelism().orElse(null));
    }

    public DynamicTableSink copy() {
        return new ElasticsearchDynamicSink(this.format, this.config, this.primaryKeyLogicalTypesWithIndex, this.physicalRowDataType, this.summaryString, this.builderSupplier, this.documentType, this.localTimeZoneId);
    }

    public String asSummaryString() {
        return this.summaryString;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ElasticsearchDynamicSink that = (ElasticsearchDynamicSink)o;
        return Objects.equals(this.format, that.format) && Objects.equals(this.physicalRowDataType, that.physicalRowDataType) && Objects.equals(this.primaryKeyLogicalTypesWithIndex, that.primaryKeyLogicalTypesWithIndex) && Objects.equals(this.config, that.config) && Objects.equals(this.summaryString, that.summaryString) && Objects.equals(this.builderSupplier, that.builderSupplier) && Objects.equals(this.documentType, that.documentType);
    }

    public int hashCode() {
        return Objects.hash(this.format, this.physicalRowDataType, this.primaryKeyLogicalTypesWithIndex, this.config, this.summaryString, this.builderSupplier, this.documentType);
    }
}

