/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.com.carrotsearch.hppc;

import java.util.Arrays;
import org.apache.flink.elasticsearch7.shaded.com.carrotsearch.hppc.ArraySizingStrategy;
import org.apache.flink.elasticsearch7.shaded.com.carrotsearch.hppc.ObjectArrayList;
import org.apache.flink.elasticsearch7.shaded.com.carrotsearch.hppc.ObjectContainer;
import org.apache.flink.elasticsearch7.shaded.com.carrotsearch.hppc.cursors.ObjectCursor;

public class ObjectStack<KType>
extends ObjectArrayList<KType> {
    public ObjectStack() {
    }

    public ObjectStack(int expectedElements) {
        super(expectedElements);
    }

    public ObjectStack(int expectedElements, ArraySizingStrategy resizer) {
        super(expectedElements, resizer);
    }

    public ObjectStack(ObjectContainer<KType> container) {
        super(container);
    }

    public void push(KType e1) {
        this.ensureBufferSpace(1);
        this.buffer[this.elementsCount++] = e1;
    }

    public void push(KType e1, KType e2) {
        this.ensureBufferSpace(2);
        this.buffer[this.elementsCount++] = e1;
        this.buffer[this.elementsCount++] = e2;
    }

    public void push(KType e1, KType e2, KType e3) {
        this.ensureBufferSpace(3);
        this.buffer[this.elementsCount++] = e1;
        this.buffer[this.elementsCount++] = e2;
        this.buffer[this.elementsCount++] = e3;
    }

    public void push(KType e1, KType e2, KType e3, KType e4) {
        this.ensureBufferSpace(4);
        this.buffer[this.elementsCount++] = e1;
        this.buffer[this.elementsCount++] = e2;
        this.buffer[this.elementsCount++] = e3;
        this.buffer[this.elementsCount++] = e4;
    }

    public void push(KType[] elements, int start, int len) {
        assert (start >= 0 && len >= 0);
        this.ensureBufferSpace(len);
        System.arraycopy(elements, start, this.buffer, this.elementsCount, len);
        this.elementsCount += len;
    }

    @SafeVarargs
    public final void push(KType ... elements) {
        this.push(elements, 0, elements.length);
    }

    public int pushAll(ObjectContainer<? extends KType> container) {
        return this.addAll(container);
    }

    public int pushAll(Iterable<? extends ObjectCursor<? extends KType>> iterable) {
        return this.addAll(iterable);
    }

    public void discard(int count) {
        assert (this.elementsCount >= count);
        this.elementsCount -= count;
        Arrays.fill(this.buffer, this.elementsCount, this.elementsCount + count, null);
    }

    public void discard() {
        assert (this.elementsCount > 0);
        --this.elementsCount;
        this.buffer[this.elementsCount] = null;
    }

    public KType pop() {
        assert (this.elementsCount > 0);
        Object v = this.buffer[--this.elementsCount];
        this.buffer[this.elementsCount] = null;
        return (KType)v;
    }

    public KType peek() {
        assert (this.elementsCount > 0);
        return (KType)this.buffer[this.elementsCount - 1];
    }

    @SafeVarargs
    public static <KType> ObjectStack<KType> from(KType ... elements) {
        ObjectStack<KType> stack = new ObjectStack<KType>(elements.length);
        stack.push(elements);
        return stack;
    }

    @Override
    public ObjectStack<KType> clone() {
        return (ObjectStack)super.clone();
    }
}

