/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.lucene.analysis.br;

import java.io.IOException;
import java.util.Set;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.analysis.TokenFilter;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.analysis.TokenStream;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.analysis.br.BrazilianStemmer;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.analysis.tokenattributes.KeywordAttribute;

public final class BrazilianStemFilter
extends TokenFilter {
    private BrazilianStemmer stemmer = new BrazilianStemmer();
    private Set<?> exclusions = null;
    private final CharTermAttribute termAtt = this.addAttribute(CharTermAttribute.class);
    private final KeywordAttribute keywordAttr = this.addAttribute(KeywordAttribute.class);

    public BrazilianStemFilter(TokenStream in) {
        super(in);
    }

    @Override
    public boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            String s;
            String term = this.termAtt.toString();
            if (!(this.keywordAttr.isKeyword() || this.exclusions != null && this.exclusions.contains(term) || (s = this.stemmer.stem(term)) == null || s.equals(term))) {
                this.termAtt.setEmpty().append(s);
            }
            return true;
        }
        return false;
    }
}

