/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.lucene.analysis.id;

import java.io.IOException;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.analysis.Analyzer;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.analysis.CharArraySet;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.analysis.StopFilter;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.analysis.StopwordAnalyzerBase;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.analysis.TokenFilter;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.analysis.TokenStream;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.analysis.id.IndonesianStemFilter;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.analysis.miscellaneous.SetKeywordMarkerFilter;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.analysis.standard.StandardTokenizer;

public final class IndonesianAnalyzer
extends StopwordAnalyzerBase {
    public static final String DEFAULT_STOPWORD_FILE = "stopwords.txt";
    private final CharArraySet stemExclusionSet;

    public static CharArraySet getDefaultStopSet() {
        return DefaultSetHolder.DEFAULT_STOP_SET;
    }

    public IndonesianAnalyzer() {
        this(DefaultSetHolder.DEFAULT_STOP_SET);
    }

    public IndonesianAnalyzer(CharArraySet stopwords) {
        this(stopwords, CharArraySet.EMPTY_SET);
    }

    public IndonesianAnalyzer(CharArraySet stopwords, CharArraySet stemExclusionSet) {
        super(stopwords);
        this.stemExclusionSet = CharArraySet.unmodifiableSet(CharArraySet.copy(stemExclusionSet));
    }

    @Override
    protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
        StandardTokenizer source = new StandardTokenizer();
        TokenFilter result = new LowerCaseFilter(source);
        result = new StopFilter(result, this.stopwords);
        if (!this.stemExclusionSet.isEmpty()) {
            result = new SetKeywordMarkerFilter(result, this.stemExclusionSet);
        }
        return new Analyzer.TokenStreamComponents(source, (TokenStream)new IndonesianStemFilter(result));
    }

    @Override
    protected TokenStream normalize(String fieldName, TokenStream in) {
        return new LowerCaseFilter(in);
    }

    private static class DefaultSetHolder {
        static final CharArraySet DEFAULT_STOP_SET;

        private DefaultSetHolder() {
        }

        static {
            try {
                DEFAULT_STOP_SET = IndonesianAnalyzer.loadStopwordSet(false, IndonesianAnalyzer.class, IndonesianAnalyzer.DEFAULT_STOPWORD_FILE, "#");
            }
            catch (IOException ex) {
                throw new RuntimeException("Unable to load default stopword set");
            }
        }
    }
}

