/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.lucene.analysis.miscellaneous;

import java.util.Map;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.analysis.TokenStream;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.analysis.miscellaneous.ConcatenateGraphFilter;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.analysis.util.TokenFilterFactory;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.Version;

public class ConcatenateGraphFilterFactory
extends TokenFilterFactory {
    public static final String NAME = "concatenateGraph";
    private Character tokenSeparator;
    private boolean preservePositionIncrements;
    private int maxGraphExpansions;

    public ConcatenateGraphFilterFactory(Map<String, String> args) {
        super(args);
        boolean preserveSep;
        Version luceneMatchVersion = this.getLuceneMatchVersion();
        this.tokenSeparator = luceneMatchVersion.onOrAfter(Version.LUCENE_8_4_0) ? this.getCharacter(args, "tokenSeparator", ConcatenateGraphFilter.DEFAULT_TOKEN_SEPARATOR) : ((preserveSep = this.getBoolean(args, "preserveSep", true)) ? ConcatenateGraphFilter.DEFAULT_TOKEN_SEPARATOR : null);
        this.preservePositionIncrements = this.getBoolean(args, "preservePositionIncrements", true);
        this.maxGraphExpansions = this.getInt(args, "maxGraphExpansions", 10000);
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args);
        }
    }

    @Override
    public TokenStream create(TokenStream input) {
        return new ConcatenateGraphFilter(input, this.tokenSeparator, this.preservePositionIncrements, this.maxGraphExpansions);
    }

    protected Character getCharacter(Map<String, String> args, String name, Character defaultVal) {
        String s = args.remove(name);
        if (s == null) {
            return defaultVal;
        }
        if (s.length() == 0) {
            return null;
        }
        if (s.length() != 1) {
            throw new IllegalArgumentException(name + " should be a char. \"" + s + "\" is invalid");
        }
        return Character.valueOf(s.charAt(0));
    }
}

