/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.lucene.analysis.util;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceConfigurationError;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.analysis.util.AbstractAnalysisFactory;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.SPIClassIterator;

public final class AnalysisSPILoader<S extends AbstractAnalysisFactory> {
    private volatile Map<String, Class<? extends S>> services = Collections.emptyMap();
    private volatile Set<String> originalNames = Collections.emptySet();
    private final Class<S> clazz;
    private final String[] suffixes;
    private static final Pattern SERVICE_NAME_PATTERN = Pattern.compile("^[a-zA-Z][a-zA-Z0-9_]+$");

    public AnalysisSPILoader(Class<S> clazz) {
        this(clazz, new String[]{clazz.getSimpleName()});
    }

    public AnalysisSPILoader(Class<S> clazz, String[] suffixes) {
        this(clazz, suffixes, null);
    }

    public AnalysisSPILoader(Class<S> clazz, String[] suffixes, ClassLoader classloader) {
        this.clazz = clazz;
        this.suffixes = suffixes;
        ClassLoader clazzClassloader = clazz.getClassLoader();
        if (classloader == null) {
            classloader = clazzClassloader;
        }
        if (clazzClassloader != null && !SPIClassIterator.isParentClassLoader(clazzClassloader, classloader)) {
            this.reload(clazzClassloader);
        }
        this.reload(classloader);
    }

    public synchronized void reload(ClassLoader classloader) {
        Objects.requireNonNull(classloader, "classloader");
        LinkedHashMap<String, Class<S>> services = new LinkedHashMap<String, Class<S>>(this.services);
        LinkedHashSet<String> originalNames = new LinkedHashSet<String>(this.originalNames);
        SPIClassIterator<S> loader = SPIClassIterator.get(this.clazz, classloader);
        while (loader.hasNext()) {
            String legacyName;
            Object service = loader.next();
            String name = null;
            String originalName = null;
            try {
                originalName = AbstractAnalysisFactory.lookupSPIName((Class<? extends AbstractAnalysisFactory>)service);
                name = originalName.toLowerCase(Locale.ROOT);
                if (!this.isValidName(originalName)) {
                    throw new ServiceConfigurationError("The name " + originalName + " for " + ((Class)service).getName() + " is invalid: Allowed characters are (English) alphabet, digits, and underscore. It should be started with an alphabet.");
                }
            }
            catch (IllegalAccessException | IllegalStateException | NoSuchFieldException exception) {
                // empty catch block
            }
            if (name != null && !services.containsKey(name)) {
                services.put(name, (Class<S>)service);
                originalNames.add(originalName);
            }
            if ((legacyName = AbstractAnalysisFactory.generateLegacySPIName((Class<? extends AbstractAnalysisFactory>)service, this.suffixes)) == null) {
                throw new ServiceConfigurationError("The class name " + ((Class)service).getName() + " has wrong suffix, allowed are: " + Arrays.toString(this.suffixes));
            }
            if (services.containsKey(legacyName)) continue;
            services.put(legacyName, (Class<S>)service);
            originalNames.add(legacyName);
        }
        if (services.keySet().size() != originalNames.size()) {
            throw new ServiceConfigurationError("Service lookup key set is inconsistent with original name set!");
        }
        this.services = Collections.unmodifiableMap(services);
        this.originalNames = Collections.unmodifiableSet(originalNames);
    }

    private boolean isValidName(String name) {
        return SERVICE_NAME_PATTERN.matcher(name).matches();
    }

    public S newInstance(String name, Map<String, String> args) {
        Class<S> service = this.lookupClass(name);
        return AnalysisSPILoader.newFactoryClassInstance(service, args);
    }

    public Class<? extends S> lookupClass(String name) {
        Class<? extends S> service = this.services.get(name.toLowerCase(Locale.ROOT));
        if (service != null) {
            return service;
        }
        throw new IllegalArgumentException("A SPI class of type " + this.clazz.getName() + " with name '" + name + "' does not exist. You need to add the corresponding JAR file supporting this SPI to your classpath. The current classpath supports the following names: " + this.availableServices());
    }

    public Set<String> availableServices() {
        return this.originalNames;
    }

    public static <T extends AbstractAnalysisFactory> T newFactoryClassInstance(Class<T> clazz, Map<String, String> args) {
        try {
            return (T)((AbstractAnalysisFactory)clazz.getConstructor(Map.class).newInstance(args));
        }
        catch (InvocationTargetException ite) {
            Throwable cause = ite.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new RuntimeException("Unexpected checked exception while calling constructor of " + clazz.getName(), cause);
        }
        catch (ReflectiveOperationException e) {
            throw new UnsupportedOperationException("Factory " + clazz.getName() + " cannot be instantiated. This is likely due to missing Map<String,String> constructor.", e);
        }
    }
}

