/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.lucene.document;

import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.document.BinaryRangeDocValuesField;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.document.LongRange;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.document.LongRangeSlowRangeQuery;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.document.RangeFieldQuery;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.Query;

public class LongRangeDocValuesField
extends BinaryRangeDocValuesField {
    final String field;
    final long[] min;
    final long[] max;

    public LongRangeDocValuesField(String field, long[] min, long[] max) {
        super(field, LongRange.encode(min, max), min.length, 8);
        LongRangeDocValuesField.checkArgs(min, max);
        this.field = field;
        this.min = min;
        this.max = max;
    }

    public long getMin(int dimension) {
        if (dimension > 4 || dimension > this.min.length) {
            throw new IllegalArgumentException("Dimension out of valid range");
        }
        return this.min[dimension];
    }

    public long getMax(int dimension) {
        if (dimension > 4 || dimension > this.min.length) {
            throw new IllegalArgumentException("Dimension out of valid range");
        }
        return this.max[dimension];
    }

    private static Query newSlowRangeQuery(String field, long[] min, long[] max, RangeFieldQuery.QueryType queryType) {
        LongRangeDocValuesField.checkArgs(min, max);
        return new LongRangeSlowRangeQuery(field, min, max, queryType);
    }

    public static Query newSlowIntersectsQuery(String field, long[] min, long[] max) {
        return LongRangeDocValuesField.newSlowRangeQuery(field, min, max, RangeFieldQuery.QueryType.INTERSECTS);
    }

    private static void checkArgs(long[] min, long[] max) {
        if (min == null || max == null || min.length == 0 || max.length == 0) {
            throw new IllegalArgumentException("min/max range values cannot be null or empty");
        }
        if (min.length != max.length) {
            throw new IllegalArgumentException("min/max ranges must agree");
        }
        for (int i = 0; i < min.length; ++i) {
            if (min[i] <= max[i]) continue;
            throw new IllegalArgumentException("min should be less than max");
        }
    }
}

