/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index;

import java.util.IdentityHashMap;
import java.util.Map;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.ThreadInterruptedException;

final class DocumentsWriterStallControl {
    private volatile boolean stalled;
    private int numWaiting;
    private boolean wasStalled;
    private final Map<Thread, Boolean> waiting = new IdentityHashMap<Thread, Boolean>();

    DocumentsWriterStallControl() {
    }

    synchronized void updateStalled(boolean stalled) {
        if (this.stalled != stalled) {
            this.stalled = stalled;
            if (stalled) {
                this.wasStalled = true;
            }
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitIfStalled() {
        if (this.stalled) {
            DocumentsWriterStallControl documentsWriterStallControl = this;
            synchronized (documentsWriterStallControl) {
                if (this.stalled) {
                    try {
                        this.incWaiters();
                        this.wait(1000L);
                        this.decrWaiters();
                    }
                    catch (InterruptedException e) {
                        throw new ThreadInterruptedException(e);
                    }
                }
            }
        }
    }

    boolean anyStalledThreads() {
        return this.stalled;
    }

    private void incWaiters() {
        ++this.numWaiting;
        assert (this.waiting.put(Thread.currentThread(), Boolean.TRUE) == null);
        assert (this.numWaiting > 0);
    }

    private void decrWaiters() {
        --this.numWaiting;
        assert (this.waiting.remove(Thread.currentThread()) != null);
        assert (this.numWaiting >= 0);
    }

    synchronized boolean hasBlocked() {
        return this.numWaiting > 0;
    }

    boolean isHealthy() {
        return !this.stalled;
    }

    synchronized boolean isThreadQueued(Thread t) {
        return this.waiting.containsKey(t);
    }

    synchronized boolean wasStalled() {
        return this.wasStalled;
    }
}

