/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.join;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.document.DoublePoint;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.document.FloatPoint;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.document.IntPoint;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.document.LongPoint;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.FieldInfo;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.LeafReader;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.LeafReaderContext;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.PointValues;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.PrefixCodedTerms;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.Term;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.DocIdSetIterator;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.Explanation;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.IndexSearcher;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.PointInSetQuery;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.Query;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.QueryVisitor;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.ScoreMode;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.Scorer;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.Weight;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.Accountable;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.BitSetIterator;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.BytesRefBuilder;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.FixedBitSet;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.RamUsageEstimator;

abstract class PointInSetIncludingScoreQuery
extends Query
implements Accountable {
    protected static final long BASE_RAM_BYTES = RamUsageEstimator.shallowSizeOfInstance(PointInSetIncludingScoreQuery.class);
    static BiFunction<byte[], Class<? extends Number>, String> toString = (value, numericType) -> {
        if (Integer.class.equals(numericType)) {
            return Integer.toString(IntPoint.decodeDimension(value, 0));
        }
        if (Long.class.equals(numericType)) {
            return Long.toString(LongPoint.decodeDimension(value, 0));
        }
        if (Float.class.equals(numericType)) {
            return Float.toString(FloatPoint.decodeDimension(value, 0));
        }
        if (Double.class.equals(numericType)) {
            return Double.toString(DoublePoint.decodeDimension(value, 0));
        }
        return "unsupported";
    };
    final org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.join.ScoreMode scoreMode;
    final Query originalQuery;
    final boolean multipleValuesPerDocument;
    final PrefixCodedTerms sortedPackedPoints;
    final int sortedPackedPointsHashCode;
    final String field;
    final int bytesPerDim;
    final List<Float> aggregatedJoinScores;
    private final long ramBytesUsed;

    PointInSetIncludingScoreQuery(org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.join.ScoreMode scoreMode, Query originalQuery, boolean multipleValuesPerDocument, String field, int bytesPerDim, Stream packedPoints) {
        BytesRef current;
        this.scoreMode = scoreMode;
        this.originalQuery = originalQuery;
        this.multipleValuesPerDocument = multipleValuesPerDocument;
        this.field = field;
        if (bytesPerDim < 1 || bytesPerDim > 16) {
            throw new IllegalArgumentException("bytesPerDim must be > 0 and <= 16; got " + bytesPerDim);
        }
        this.bytesPerDim = bytesPerDim;
        this.aggregatedJoinScores = new ArrayList<Float>();
        PrefixCodedTerms.Builder builder = new PrefixCodedTerms.Builder();
        BytesRefBuilder previous = null;
        while ((current = packedPoints.next()) != null) {
            if (current.length != bytesPerDim) {
                throw new IllegalArgumentException("packed point length should be " + bytesPerDim + " but got " + current.length + "; field=\"" + field + "\"bytesPerDim=" + bytesPerDim);
            }
            if (previous == null) {
                previous = new BytesRefBuilder();
            } else {
                int cmp = previous.get().compareTo(current);
                if (cmp == 0) {
                    throw new IllegalArgumentException("unexpected duplicated value: " + current);
                }
                if (cmp >= 0) {
                    throw new IllegalArgumentException("values are out of order: saw " + previous + " before " + current);
                }
            }
            builder.add(field, current);
            this.aggregatedJoinScores.add(Float.valueOf(packedPoints.score));
            previous.copyBytes(current);
        }
        this.sortedPackedPoints = builder.finish();
        this.sortedPackedPointsHashCode = this.sortedPackedPoints.hashCode();
        this.ramBytesUsed = BASE_RAM_BYTES + RamUsageEstimator.sizeOfObject(this.field) + RamUsageEstimator.sizeOfObject(this.originalQuery, 1024L) + RamUsageEstimator.sizeOfObject(this.sortedPackedPoints);
    }

    @Override
    public void visit(QueryVisitor visitor) {
        if (visitor.acceptField(this.field)) {
            visitor.visitLeaf(this);
        }
    }

    @Override
    public final Weight createWeight(IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
        return new Weight(this){

            @Override
            public void extractTerms(Set<Term> terms) {
            }

            @Override
            public Explanation explain(LeafReaderContext context, int doc) throws IOException {
                int target;
                Scorer scorer = this.scorer(context);
                if (scorer != null && doc == (target = scorer.iterator().advance(doc))) {
                    return Explanation.match((Number)Float.valueOf(scorer.score()), "A match", new Explanation[0]);
                }
                return Explanation.noMatch("Not a match", new Explanation[0]);
            }

            @Override
            public Scorer scorer(LeafReaderContext context) throws IOException {
                LeafReader reader = context.reader();
                FieldInfo fieldInfo = reader.getFieldInfos().fieldInfo(PointInSetIncludingScoreQuery.this.field);
                if (fieldInfo == null) {
                    return null;
                }
                if (fieldInfo.getPointDimensionCount() != 1) {
                    throw new IllegalArgumentException("field=\"" + PointInSetIncludingScoreQuery.this.field + "\" was indexed with numDims=" + fieldInfo.getPointDimensionCount() + " but this query has numDims=1");
                }
                if (fieldInfo.getPointNumBytes() != PointInSetIncludingScoreQuery.this.bytesPerDim) {
                    throw new IllegalArgumentException("field=\"" + PointInSetIncludingScoreQuery.this.field + "\" was indexed with bytesPerDim=" + fieldInfo.getPointNumBytes() + " but this query has bytesPerDim=" + PointInSetIncludingScoreQuery.this.bytesPerDim);
                }
                PointValues values = reader.getPointValues(PointInSetIncludingScoreQuery.this.field);
                if (values == null) {
                    return null;
                }
                final FixedBitSet result = new FixedBitSet(reader.maxDoc());
                final float[] scores = new float[reader.maxDoc()];
                values.intersect(new MergePointVisitor(PointInSetIncludingScoreQuery.this.sortedPackedPoints, result, scores));
                return new Scorer(this){
                    DocIdSetIterator disi;
                    {
                        super(x0);
                        this.disi = new BitSetIterator(result, 10L);
                    }

                    @Override
                    public float score() throws IOException {
                        return scores[this.docID()];
                    }

                    @Override
                    public float getMaxScore(int upTo) throws IOException {
                        return Float.POSITIVE_INFINITY;
                    }

                    @Override
                    public int docID() {
                        return this.disi.docID();
                    }

                    @Override
                    public DocIdSetIterator iterator() {
                        return this.disi;
                    }
                };
            }

            @Override
            public boolean isCacheable(LeafReaderContext ctx) {
                return true;
            }
        };
    }

    @Override
    public final int hashCode() {
        int hash = this.classHash();
        hash = 31 * hash + this.scoreMode.hashCode();
        hash = 31 * hash + this.field.hashCode();
        hash = 31 * hash + this.originalQuery.hashCode();
        hash = 31 * hash + this.sortedPackedPointsHashCode;
        hash = 31 * hash + this.bytesPerDim;
        return hash;
    }

    @Override
    public final boolean equals(Object other) {
        return this.sameClassAs(other) && this.equalsTo((PointInSetIncludingScoreQuery)this.getClass().cast(other));
    }

    private boolean equalsTo(PointInSetIncludingScoreQuery other) {
        return other.scoreMode.equals((Object)this.scoreMode) && other.field.equals(this.field) && other.originalQuery.equals(this.originalQuery) && other.bytesPerDim == this.bytesPerDim && other.sortedPackedPointsHashCode == this.sortedPackedPointsHashCode && other.sortedPackedPoints.equals(this.sortedPackedPoints);
    }

    @Override
    public final String toString(String field) {
        StringBuilder sb = new StringBuilder();
        if (!this.field.equals(field)) {
            sb.append(this.field);
            sb.append(':');
        }
        sb.append("{");
        PrefixCodedTerms.TermIterator iterator = this.sortedPackedPoints.iterator();
        byte[] pointBytes = new byte[this.bytesPerDim];
        boolean first = true;
        BytesRef point = iterator.next();
        while (point != null) {
            if (!first) {
                sb.append(" ");
            }
            first = false;
            System.arraycopy(point.bytes, point.offset, pointBytes, 0, pointBytes.length);
            sb.append(this.toString(pointBytes));
            point = iterator.next();
        }
        sb.append("}");
        return sb.toString();
    }

    protected abstract String toString(byte[] var1);

    @Override
    public long ramBytesUsed() {
        return this.ramBytesUsed;
    }

    private class MergePointVisitor
    implements PointValues.IntersectVisitor {
        private final FixedBitSet result;
        private final float[] scores;
        private PrefixCodedTerms.TermIterator iterator;
        private Iterator<Float> scoreIterator;
        private BytesRef nextQueryPoint;
        float nextScore;
        private final BytesRef scratch = new BytesRef();

        private MergePointVisitor(PrefixCodedTerms sortedPackedPoints, FixedBitSet result, float[] scores) throws IOException {
            this.result = result;
            this.scores = scores;
            this.scratch.length = PointInSetIncludingScoreQuery.this.bytesPerDim;
            this.iterator = sortedPackedPoints.iterator();
            this.scoreIterator = PointInSetIncludingScoreQuery.this.aggregatedJoinScores.iterator();
            this.nextQueryPoint = this.iterator.next();
            if (this.scoreIterator.hasNext()) {
                this.nextScore = this.scoreIterator.next().floatValue();
            }
        }

        @Override
        public void visit(int docID) {
            throw new IllegalStateException("shouldn't get here, since CELL_INSIDE_QUERY isn't emitted");
        }

        @Override
        public void visit(int docID, byte[] packedValue) {
            this.scratch.bytes = packedValue;
            while (this.nextQueryPoint != null) {
                int cmp = this.nextQueryPoint.compareTo(this.scratch);
                if (cmp == 0) {
                    if (PointInSetIncludingScoreQuery.this.multipleValuesPerDocument) {
                        if (this.result.get(docID)) break;
                        this.result.set(docID);
                        this.scores[docID] = this.nextScore;
                        break;
                    }
                    this.result.set(docID);
                    this.scores[docID] = this.nextScore;
                    break;
                }
                if (cmp >= 0) break;
                this.nextQueryPoint = this.iterator.next();
                if (!this.scoreIterator.hasNext()) continue;
                this.nextScore = this.scoreIterator.next().floatValue();
            }
        }

        @Override
        public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
            while (this.nextQueryPoint != null) {
                this.scratch.bytes = minPackedValue;
                int cmpMin = this.nextQueryPoint.compareTo(this.scratch);
                if (cmpMin < 0) {
                    this.nextQueryPoint = this.iterator.next();
                    if (!this.scoreIterator.hasNext()) continue;
                    this.nextScore = this.scoreIterator.next().floatValue();
                    continue;
                }
                this.scratch.bytes = maxPackedValue;
                int cmpMax = this.nextQueryPoint.compareTo(this.scratch);
                if (cmpMax > 0) {
                    return PointValues.Relation.CELL_OUTSIDE_QUERY;
                }
                return PointValues.Relation.CELL_CROSSES_QUERY;
            }
            return PointValues.Relation.CELL_OUTSIDE_QUERY;
        }
    }

    static abstract class Stream
    extends PointInSetQuery.Stream {
        float score;

        Stream() {
        }
    }
}

