/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.lucene.spatial.prefix.tree;

import java.text.ParseException;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.spatial.prefix.tree.Cell;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.spatial.prefix.tree.CellIterator;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.spatial.prefix.tree.SpatialPrefixTree;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.StringHelper;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.context.SpatialContextFactory;
import org.locationtech.spatial4j.shape.Point;
import org.locationtech.spatial4j.shape.Rectangle;
import org.locationtech.spatial4j.shape.Shape;
import org.locationtech.spatial4j.shape.SpatialRelation;
import org.locationtech.spatial4j.shape.impl.RectangleImpl;

public abstract class NumberRangePrefixTree
extends SpatialPrefixTree {
    private static final SpatialContext DUMMY_CTX;
    protected final int[] maxSubCellsByLevel;
    protected final int[] termLenByLevel;
    protected final int[] levelByTermLen;
    protected final int maxTermLen;

    public abstract UnitNRShape toUnitShape(Object var1);

    public NRShape toRangeShape(UnitNRShape startUnit, UnitNRShape endUnit) {
        int cmp = NumberRangePrefixTree.comparePrefix(startUnit = startUnit.getShapeAtLevel(this.truncateStartVals(startUnit, 0)), endUnit = endUnit.getShapeAtLevel(this.truncateEndVals(endUnit, 0)));
        if (cmp > 0) {
            throw new IllegalArgumentException("Wrong order: " + startUnit + " TO " + endUnit);
        }
        if (cmp == 0) {
            if (startUnit.getLevel() == endUnit.getLevel()) {
                return startUnit;
            }
            if (endUnit.getLevel() > startUnit.getLevel()) {
                if (this.truncateStartVals(endUnit, startUnit.getLevel()) == startUnit.getLevel()) {
                    return endUnit;
                }
            } else if (this.truncateEndVals(startUnit, endUnit.getLevel()) == endUnit.getLevel()) {
                return startUnit;
            }
        }
        return new SpanUnitsNRShape(startUnit, endUnit);
    }

    private int truncateStartVals(UnitNRShape lv, int endLevel) {
        for (int level = lv.getLevel(); level > endLevel; --level) {
            if (lv.getValAtLevel(level) == 0) continue;
            return level;
        }
        return endLevel;
    }

    private int truncateEndVals(UnitNRShape lv, int endLevel) {
        for (int level = lv.getLevel(); level > endLevel; --level) {
            int max = this.getNumSubCells(lv.getShapeAtLevel(level - 1)) - 1;
            if (lv.getValAtLevel(level) == max) continue;
            return level;
        }
        return endLevel;
    }

    public abstract Object toObject(UnitNRShape var1);

    protected abstract String toString(UnitNRShape var1);

    protected static String toStringUnitRaw(UnitNRShape lv) {
        StringBuilder buf = new StringBuilder(100);
        buf.append('[');
        for (int level = 1; level <= lv.getLevel(); ++level) {
            buf.append(lv.getValAtLevel(level)).append(',');
        }
        buf.setLength(buf.length() - 1);
        buf.append(']');
        return buf.toString();
    }

    public NRShape parseShape(String str) throws ParseException {
        if (str == null || str.isEmpty()) {
            throw new IllegalArgumentException("str is null or blank");
        }
        if (str.charAt(0) == '[') {
            if (str.charAt(str.length() - 1) != ']') {
                throw new ParseException("If starts with [ must end with ]; got " + str, str.length() - 1);
            }
            int middle = str.indexOf(" TO ");
            if (middle < 0) {
                throw new ParseException("If starts with [ must contain ' TO '; got " + str, -1);
            }
            String leftStr = str.substring(1, middle);
            String rightStr = str.substring(middle + " TO ".length(), str.length() - 1);
            return this.toRangeShape(this.parseUnitShape(leftStr), this.parseUnitShape(rightStr));
        }
        if (str.charAt(0) == '{') {
            throw new ParseException("Exclusive ranges not supported; got " + str, 0);
        }
        return this.parseUnitShape(str);
    }

    protected abstract UnitNRShape parseUnitShape(String var1) throws ParseException;

    protected static int comparePrefix(UnitNRShape a, UnitNRShape b) {
        int minLevel = Math.min(a.getLevel(), b.getLevel());
        for (int level = 1; level <= minLevel; ++level) {
            int diff = a.getValAtLevel(level) - b.getValAtLevel(level);
            if (diff == 0) continue;
            return diff;
        }
        return 0;
    }

    protected NumberRangePrefixTree(int[] maxSubCellsByLevel) {
        super(DUMMY_CTX, maxSubCellsByLevel.length);
        int level;
        this.maxSubCellsByLevel = maxSubCellsByLevel;
        this.termLenByLevel = new int[this.maxLevels + 1];
        this.termLenByLevel[0] = 0;
        int MAX_STATES = 32768;
        for (level = 1; level <= this.maxLevels; ++level) {
            int states = maxSubCellsByLevel[level - 1];
            if (states >= 32768 || states <= 1) {
                throw new IllegalArgumentException("Max states is 32768, given " + states + " at level " + level);
            }
            boolean twoBytes = states >= 256;
            this.termLenByLevel[level] = this.termLenByLevel[level - 1] + (twoBytes ? 2 : 1);
        }
        this.maxTermLen = this.termLenByLevel[this.maxLevels] + 1;
        this.levelByTermLen = new int[this.maxTermLen];
        this.levelByTermLen[0] = 0;
        for (level = 1; level < this.termLenByLevel.length; ++level) {
            int termLen = this.termLenByLevel[level];
            int prevTermLen = this.termLenByLevel[level - 1];
            if (termLen - prevTermLen == 2) {
                this.levelByTermLen[termLen - 1] = -1;
                this.levelByTermLen[termLen] = level;
                continue;
            }
            assert (termLen - prevTermLen == 1);
            this.levelByTermLen[termLen] = level;
        }
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public int getLevelForDistance(double dist) {
        return this.maxLevels;
    }

    @Override
    public double getDistanceForLevel(int level) {
        throw new UnsupportedOperationException("Not applicable.");
    }

    protected UnitNRShape toShape(int[] valStack, int len) {
        NRCell[] cellStack = this.newCellStack(len);
        for (int i = 0; i < len; ++i) {
            cellStack[i + 1].resetCellWithCellNum(valStack[i]);
        }
        return cellStack[len];
    }

    @Override
    public Cell getWorldCell() {
        return this.newCellStack(this.maxLevels)[0];
    }

    protected NRCell[] newCellStack(int levels) {
        NRCell[] cellsByLevel = new NRCell[levels + 1];
        BytesRef term = new BytesRef(this.maxTermLen);
        for (int level = 0; level <= levels; ++level) {
            cellsByLevel[level] = new NRCell(cellsByLevel, term, level);
        }
        return cellsByLevel;
    }

    @Override
    public Cell readCell(BytesRef term, Cell scratch) {
        if (scratch == null) {
            scratch = this.getWorldCell();
        }
        NRCell[] cellsByLevel = ((NRCell)scratch).cellsByLevel;
        boolean isLeaf = term.bytes[term.offset + term.length - 1] == 0;
        int lenNoLeaf = isLeaf ? term.length - 1 : term.length;
        NRCell result = cellsByLevel[this.levelByTermLen[lenNoLeaf]];
        if (cellsByLevel[0].termBuf == null) {
            cellsByLevel[0].termBuf = result.term.bytes;
        }
        result.term.bytes = term.bytes;
        result.term.offset = term.offset;
        result.term.length = lenNoLeaf;
        result.reset();
        if (isLeaf) {
            result.setLeaf();
        }
        result.cellNumber = -1;
        return result;
    }

    public int getNumSubCells(UnitNRShape lv) {
        return this.maxSubCellsByLevel[lv.getLevel()];
    }

    static {
        SpatialContextFactory factory = new SpatialContextFactory();
        factory.geo = false;
        factory.worldBounds = new RectangleImpl(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0, 0.0, null);
        DUMMY_CTX = factory.newSpatialContext();
    }

    protected class NRCell
    extends CellIterator
    implements Cell,
    UnitNRShape {
        final NRCell[] cellsByLevel;
        final BytesRef term;
        byte[] termBuf;
        final int cellLevel;
        int cellNumber;
        SpatialRelation cellShapeRel;
        boolean cellIsLeaf;
        Shape iterFilter;
        boolean iterFirstIsIntersects;
        boolean iterLastIsIntersects;
        int iterFirstCellNumber;
        int iterLastCellNumber;

        NRCell(NRCell[] cellsByLevel, BytesRef term, int cellLevel) {
            this.cellsByLevel = cellsByLevel;
            this.term = term;
            this.cellLevel = cellLevel;
            this.cellNumber = cellLevel == 0 ? 0 : -1;
            this.cellIsLeaf = false;
            assert (cellsByLevel[cellLevel] == null);
        }

        void ensureOwnTermBytes() {
            NRCell cell0 = this.cellsByLevel[0];
            if (cell0.termBuf == null) {
                return;
            }
            System.arraycopy(this.term.bytes, this.term.offset, cell0.termBuf, 0, this.term.length);
            this.term.bytes = cell0.termBuf;
            this.term.offset = 0;
            cell0.termBuf = null;
        }

        private void reset() {
            this.cellIsLeaf = false;
            this.cellShapeRel = null;
        }

        private void resetCellWithCellNum(int cellNumber) {
            this.reset();
            if (cellNumber >= 0) {
                boolean twoBytes;
                this.ensureOwnTermBytes();
                int termLen = NumberRangePrefixTree.this.termLenByLevel[this.getLevel()];
                boolean bl = twoBytes = termLen - NumberRangePrefixTree.this.termLenByLevel[this.getLevel() - 1] > 1;
                if (twoBytes) {
                    this.term.bytes[termLen - 2] = (byte)(cellNumber >> 7);
                    this.term.bytes[termLen - 1] = (byte)((cellNumber & 0x7F) + 1);
                } else {
                    this.term.bytes[termLen - 1] = (byte)(cellNumber + 1);
                }
                assert (this.term.bytes[termLen - 1] != 0);
                this.term.length = termLen;
            }
            this.cellNumber = cellNumber;
        }

        private void ensureDecoded() {
            if (this.cellNumber >= 0) {
                return;
            }
            for (int level = 1; level <= this.getLevel(); ++level) {
                boolean twoBytes;
                NRCell cell = this.cellsByLevel[level];
                int termLen = NumberRangePrefixTree.this.termLenByLevel[level];
                boolean bl = twoBytes = termLen - NumberRangePrefixTree.this.termLenByLevel[level - 1] > 1;
                if (twoBytes) {
                    int byteH = this.term.bytes[this.term.offset + termLen - 2] & 0xFF;
                    int byteL = this.term.bytes[this.term.offset + termLen - 1] & 0xFF;
                    assert (byteL - 1 < 128);
                    cell.cellNumber = (byteH << 7) + (byteL - 1);
                    assert (cell.cellNumber < 32768);
                } else {
                    cell.cellNumber = (this.term.bytes[this.term.offset + termLen - 1] & 0xFF) - 1;
                    assert (cell.cellNumber < 255);
                }
                cell.assertDecoded();
            }
        }

        private void assertDecoded() {
            assert (this.cellNumber >= 0) : "Illegal state; ensureDecoded() wasn't called";
        }

        @Override
        public int getLevel() {
            return this.cellLevel;
        }

        @Override
        public SpatialRelation getShapeRel() {
            return this.cellShapeRel;
        }

        @Override
        public void setShapeRel(SpatialRelation rel) {
            this.cellShapeRel = rel;
        }

        @Override
        public boolean isLeaf() {
            return this.cellIsLeaf;
        }

        @Override
        public void setLeaf() {
            this.cellIsLeaf = true;
        }

        @Override
        public UnitNRShape getShape() {
            this.ensureDecoded();
            return this;
        }

        @Override
        public BytesRef getTokenBytesNoLeaf(BytesRef result) {
            if (result == null) {
                result = new BytesRef();
            }
            result.bytes = this.term.bytes;
            result.offset = this.term.offset;
            result.length = NumberRangePrefixTree.this.termLenByLevel[this.cellLevel];
            assert (result.length <= this.term.length);
            return result;
        }

        @Override
        public BytesRef getTokenBytesWithLeaf(BytesRef result) {
            this.ensureOwnTermBytes();
            result = this.getTokenBytesNoLeaf(result);
            if (this.isLeaf()) {
                result.bytes[result.length++] = 0;
            }
            return result;
        }

        @Override
        public boolean isPrefixOf(Cell c) {
            NRCell otherCell = (NRCell)c;
            assert (this.term != otherCell.term);
            int myLastLen = this.term.length;
            this.term.length = NumberRangePrefixTree.this.termLenByLevel[this.getLevel()];
            int otherLastLen = otherCell.term.length;
            otherCell.term.length = NumberRangePrefixTree.this.termLenByLevel[otherCell.getLevel()];
            boolean answer = StringHelper.startsWith(otherCell.term, this.term);
            this.term.length = myLastLen;
            otherCell.term.length = otherLastLen;
            return answer;
        }

        @Override
        public int compareToNoLeaf(Cell fromCell) {
            NRCell nrCell = (NRCell)fromCell;
            assert (this.term != nrCell.term);
            int myLastLen = this.term.length;
            int otherLastLen = nrCell.term.length;
            this.term.length = NumberRangePrefixTree.this.termLenByLevel[this.getLevel()];
            nrCell.term.length = NumberRangePrefixTree.this.termLenByLevel[nrCell.getLevel()];
            int answer = this.term.compareTo(nrCell.term);
            this.term.length = myLastLen;
            nrCell.term.length = otherLastLen;
            return answer;
        }

        @Override
        public CellIterator getNextLevelCells(Shape shapeFilter) {
            this.ensureDecoded();
            NRCell subCell = this.cellsByLevel[this.cellLevel + 1];
            subCell.initIter(shapeFilter);
            return subCell;
        }

        private void initIter(Shape filter) {
            int lastLevelInCommon;
            UnitNRShape maxLV;
            UnitNRShape minLV;
            this.cellNumber = -1;
            if (filter instanceof UnitNRShape && ((UnitNRShape)filter).getLevel() == 0) {
                filter = null;
            }
            this.iterFilter = filter;
            NRCell parent = this.getShapeAtLevel(this.getLevel() - 1);
            if (filter == null) {
                this.iterFirstCellNumber = 0;
                this.iterFirstIsIntersects = false;
                this.iterLastCellNumber = NumberRangePrefixTree.this.getNumSubCells(parent) - 1;
                this.iterLastIsIntersects = false;
                return;
            }
            if (filter instanceof SpanUnitsNRShape) {
                SpanUnitsNRShape spanShape = (SpanUnitsNRShape)this.iterFilter;
                minLV = spanShape.getMinUnit();
                maxLV = spanShape.getMaxUnit();
                lastLevelInCommon = spanShape.getLevelsInCommon();
            } else {
                maxLV = minLV = (UnitNRShape)this.iterFilter;
                lastLevelInCommon = minLV.getLevel();
            }
            if (this.iterFilter == parent.iterFilter && (this.getLevel() <= lastLevelInCommon || parent.iterFirstCellNumber != parent.iterLastCellNumber)) {
                if (parent.iterFirstIsIntersects && parent.cellNumber == parent.iterFirstCellNumber && minLV.getLevel() >= this.getLevel()) {
                    this.iterFirstCellNumber = minLV.getValAtLevel(this.getLevel());
                    this.iterFirstIsIntersects = minLV.getLevel() > this.getLevel();
                } else {
                    this.iterFirstCellNumber = 0;
                    this.iterFirstIsIntersects = false;
                }
                if (parent.iterLastIsIntersects && parent.cellNumber == parent.iterLastCellNumber && maxLV.getLevel() >= this.getLevel()) {
                    this.iterLastCellNumber = maxLV.getValAtLevel(this.getLevel());
                    this.iterLastIsIntersects = maxLV.getLevel() > this.getLevel();
                } else {
                    this.iterLastCellNumber = NumberRangePrefixTree.this.getNumSubCells(parent) - 1;
                    this.iterLastIsIntersects = false;
                }
                if (this.iterFirstCellNumber == this.iterLastCellNumber) {
                    if (this.iterLastIsIntersects) {
                        this.iterFirstIsIntersects = true;
                    } else if (this.iterFirstIsIntersects) {
                        this.iterLastIsIntersects = true;
                    }
                }
                return;
            }
            int startCmp = NumberRangePrefixTree.comparePrefix(minLV, parent);
            if (startCmp > 0) {
                this.iterFirstCellNumber = 0;
                this.iterFirstIsIntersects = false;
                this.iterLastCellNumber = -1;
                this.iterLastIsIntersects = false;
                return;
            }
            int endCmp = NumberRangePrefixTree.comparePrefix(maxLV, parent);
            if (endCmp < 0) {
                this.iterFirstCellNumber = 0;
                this.iterFirstIsIntersects = false;
                this.iterLastCellNumber = -1;
                this.iterLastIsIntersects = false;
                return;
            }
            if (startCmp < 0 || minLV.getLevel() < this.getLevel()) {
                this.iterFirstCellNumber = 0;
                this.iterFirstIsIntersects = false;
            } else {
                this.iterFirstCellNumber = minLV.getValAtLevel(this.getLevel());
                boolean bl = this.iterFirstIsIntersects = minLV.getLevel() > this.getLevel();
            }
            if (endCmp > 0 || maxLV.getLevel() < this.getLevel()) {
                this.iterLastCellNumber = NumberRangePrefixTree.this.getNumSubCells(parent) - 1;
                this.iterLastIsIntersects = false;
            } else {
                this.iterLastCellNumber = maxLV.getValAtLevel(this.getLevel());
                boolean bl = this.iterLastIsIntersects = maxLV.getLevel() > this.getLevel();
            }
            if (this.iterFirstCellNumber == this.iterLastCellNumber) {
                if (this.iterLastIsIntersects) {
                    this.iterFirstIsIntersects = true;
                } else if (this.iterFirstIsIntersects) {
                    this.iterLastIsIntersects = true;
                }
            }
        }

        @Override
        public boolean hasNext() {
            boolean hasChildren;
            this.thisCell = null;
            if (this.nextCell != null) {
                return true;
            }
            if (this.cellNumber >= this.iterLastCellNumber) {
                return false;
            }
            this.resetCellWithCellNum(this.cellNumber < this.iterFirstCellNumber ? this.iterFirstCellNumber : this.cellNumber + 1);
            boolean bl = hasChildren = this.cellNumber == this.iterFirstCellNumber && this.iterFirstIsIntersects || this.cellNumber == this.iterLastCellNumber && this.iterLastIsIntersects;
            if (!hasChildren) {
                this.setLeaf();
                this.setShapeRel(SpatialRelation.WITHIN);
            } else if (this.iterFirstCellNumber == this.iterLastCellNumber) {
                this.setShapeRel(SpatialRelation.CONTAINS);
            } else {
                this.setShapeRel(SpatialRelation.INTERSECTS);
            }
            this.nextCell = this;
            return true;
        }

        @Override
        public int getValAtLevel(int level) {
            int result = this.cellsByLevel[level].cellNumber;
            assert (result >= 0);
            return result;
        }

        @Override
        public NRCell getShapeAtLevel(int level) {
            assert (level <= this.cellLevel);
            return this.cellsByLevel[level];
        }

        @Override
        public UnitNRShape roundToLevel(int targetLevel) {
            if (this.getLevel() <= targetLevel) {
                return this;
            }
            return this.getShapeAtLevel(targetLevel);
        }

        public SpatialRelation relate(Shape shape) {
            this.assertDecoded();
            if (shape == this.iterFilter && this.cellShapeRel != null) {
                return this.cellShapeRel;
            }
            if (shape instanceof UnitNRShape) {
                return this.relate((UnitNRShape)shape);
            }
            if (shape instanceof SpanUnitsNRShape) {
                return this.relate((SpanUnitsNRShape)shape);
            }
            return shape.relate((Shape)this).transpose();
        }

        public SpatialRelation relate(UnitNRShape lv) {
            this.assertDecoded();
            int cmp = NumberRangePrefixTree.comparePrefix(this, lv);
            if (cmp != 0) {
                return SpatialRelation.DISJOINT;
            }
            if (this.getLevel() > lv.getLevel()) {
                return SpatialRelation.WITHIN;
            }
            return SpatialRelation.CONTAINS;
        }

        public SpatialRelation relate(SpanUnitsNRShape spanShape) {
            int nrMinLevel;
            this.assertDecoded();
            int startCmp = NumberRangePrefixTree.comparePrefix(spanShape.getMinUnit(), this);
            if (startCmp > 0) {
                return SpatialRelation.DISJOINT;
            }
            int endCmp = NumberRangePrefixTree.comparePrefix(spanShape.getMaxUnit(), this);
            if (endCmp < 0) {
                return SpatialRelation.DISJOINT;
            }
            int nrMaxLevel = spanShape.getMaxUnit().getLevel();
            if ((startCmp < 0 || startCmp == 0 && nrMinLevel <= this.getLevel()) && (endCmp > 0 || endCmp == 0 && nrMaxLevel <= this.getLevel())) {
                return SpatialRelation.WITHIN;
            }
            if (startCmp != 0 || endCmp != 0) {
                return SpatialRelation.INTERSECTS;
            }
            for (nrMinLevel = spanShape.getMinUnit().getLevel(); nrMinLevel < this.getLevel(); ++nrMinLevel) {
                if (this.getValAtLevel(nrMinLevel + 1) == 0) continue;
                return SpatialRelation.INTERSECTS;
            }
            while (nrMaxLevel < this.getLevel()) {
                if (this.getValAtLevel(nrMaxLevel + 1) != NumberRangePrefixTree.this.getNumSubCells(this.getShapeAtLevel(nrMaxLevel)) - 1) {
                    return SpatialRelation.INTERSECTS;
                }
                ++nrMaxLevel;
            }
            return SpatialRelation.CONTAINS;
        }

        @Override
        public UnitNRShape clone() {
            NRCell cell = (NRCell)NumberRangePrefixTree.this.readCell(this.getTokenBytesNoLeaf(null), null);
            cell.ensureOwnTermBytes();
            return cell.getShape();
        }

        @Override
        public int compareTo(UnitNRShape o) {
            this.assertDecoded();
            int cmp = NumberRangePrefixTree.comparePrefix(this, o);
            if (cmp != 0) {
                return cmp;
            }
            return this.getLevel() - o.getLevel();
        }

        public Rectangle getBoundingBox() {
            throw new UnsupportedOperationException();
        }

        public boolean hasArea() {
            return true;
        }

        public double getArea(SpatialContext ctx) {
            throw new UnsupportedOperationException();
        }

        public Point getCenter() {
            throw new UnsupportedOperationException();
        }

        public Shape getBuffered(double distance, SpatialContext ctx) {
            throw new UnsupportedOperationException();
        }

        public boolean isEmpty() {
            return false;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof NRCell)) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            NRCell nrCell = (NRCell)obj;
            assert (this.term != nrCell.term);
            if (this.getLevel() != nrCell.getLevel()) {
                return false;
            }
            int myLastLen = this.term.length;
            int otherLastLen = nrCell.term.length;
            boolean answer = this.getTokenBytesNoLeaf(this.term).equals(nrCell.getTokenBytesNoLeaf(nrCell.term));
            this.term.length = myLastLen;
            nrCell.term.length = otherLastLen;
            return answer;
        }

        public SpatialContext getContext() {
            return DUMMY_CTX;
        }

        public int hashCode() {
            int myLastLen = this.term.length;
            int result = this.getTokenBytesNoLeaf(this.term).hashCode();
            this.term.length = myLastLen;
            return result;
        }

        @Override
        public String toString() {
            return NumberRangePrefixTree.this.toString(this.getShape());
        }

        public String toStringDebug() {
            String pretty = this.toString();
            if (this.getLevel() == 0) {
                return pretty;
            }
            return NumberRangePrefixTree.toStringUnitRaw(this) + (this.isLeaf() ? "\u2022" : "") + " " + pretty;
        }
    }

    public class SpanUnitsNRShape
    implements NRShape {
        private final UnitNRShape minLV;
        private final UnitNRShape maxLV;
        private final int lastLevelInCommon;

        private SpanUnitsNRShape(UnitNRShape minLV, UnitNRShape maxLV) {
            int level;
            this.minLV = minLV;
            this.maxLV = maxLV;
            for (level = 1; level <= minLV.getLevel() && level <= maxLV.getLevel() && minLV.getValAtLevel(level) == maxLV.getValAtLevel(level); ++level) {
            }
            this.lastLevelInCommon = level - 1;
        }

        public SpatialContext getContext() {
            return DUMMY_CTX;
        }

        public UnitNRShape getMinUnit() {
            return this.minLV;
        }

        public UnitNRShape getMaxUnit() {
            return this.maxLV;
        }

        private int getLevelsInCommon() {
            return this.lastLevelInCommon;
        }

        @Override
        public NRShape roundToLevel(int targetLevel) {
            return NumberRangePrefixTree.this.toRangeShape(this.minLV.roundToLevel(targetLevel), this.maxLV.roundToLevel(targetLevel));
        }

        public SpatialRelation relate(Shape shape) {
            if (shape instanceof SpanUnitsNRShape) {
                return this.relate((SpanUnitsNRShape)shape);
            }
            return shape.relate((Shape)this).transpose();
        }

        public SpatialRelation relate(SpanUnitsNRShape ext) {
            int extMin_intMax = NumberRangePrefixTree.comparePrefix(ext.getMinUnit(), this.getMaxUnit());
            if (extMin_intMax > 0) {
                return SpatialRelation.DISJOINT;
            }
            int extMax_intMin = NumberRangePrefixTree.comparePrefix(ext.getMaxUnit(), this.getMinUnit());
            if (extMax_intMin < 0) {
                return SpatialRelation.DISJOINT;
            }
            int extMin_intMin = NumberRangePrefixTree.comparePrefix(ext.getMinUnit(), this.getMinUnit());
            int extMax_intMax = NumberRangePrefixTree.comparePrefix(ext.getMaxUnit(), this.getMaxUnit());
            if ((extMin_intMin > 0 || extMin_intMin == 0 && ext.getMinUnit().getLevel() >= this.getMinUnit().getLevel()) && (extMax_intMax < 0 || extMax_intMax == 0 && ext.getMaxUnit().getLevel() >= this.getMaxUnit().getLevel())) {
                return SpatialRelation.CONTAINS;
            }
            if ((extMin_intMin < 0 || extMin_intMin == 0 && ext.getMinUnit().getLevel() <= this.getMinUnit().getLevel()) && (extMax_intMax > 0 || extMax_intMax == 0 && ext.getMaxUnit().getLevel() <= this.getMaxUnit().getLevel())) {
                return SpatialRelation.WITHIN;
            }
            return SpatialRelation.INTERSECTS;
        }

        public Rectangle getBoundingBox() {
            throw new UnsupportedOperationException();
        }

        public boolean hasArea() {
            return true;
        }

        public double getArea(SpatialContext spatialContext) {
            throw new UnsupportedOperationException();
        }

        public Point getCenter() {
            throw new UnsupportedOperationException();
        }

        public Shape getBuffered(double v, SpatialContext spatialContext) {
            throw new UnsupportedOperationException();
        }

        public boolean isEmpty() {
            return false;
        }

        public SpanUnitsNRShape clone() {
            return new SpanUnitsNRShape(this.minLV.clone(), this.maxLV.clone());
        }

        @Override
        public String toString() {
            return "[" + NumberRangePrefixTree.this.toString(this.minLV) + " TO " + NumberRangePrefixTree.this.toString(this.maxLV) + "]";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SpanUnitsNRShape spanShape = (SpanUnitsNRShape)o;
            if (!this.maxLV.equals(spanShape.maxLV)) {
                return false;
            }
            return this.minLV.equals(spanShape.minLV);
        }

        public int hashCode() {
            int result = this.minLV.hashCode();
            result = 31 * result + this.maxLV.hashCode();
            return result;
        }
    }

    public static interface UnitNRShape
    extends NRShape,
    Comparable<UnitNRShape> {
        public int getLevel();

        public int getValAtLevel(int var1);

        public UnitNRShape getShapeAtLevel(int var1);

        @Override
        public UnitNRShape roundToLevel(int var1);

        public UnitNRShape clone();
    }

    public static interface NRShape
    extends Shape,
    Cloneable {
        public String toString();

        public NRShape roundToLevel(int var1);
    }
}

