/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util;

import java.io.IOException;
import java.io.PrintStream;
import java.time.Instant;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.InfoStream;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.SuppressForbidden;

public class PrintStreamInfoStream
extends InfoStream {
    private static final AtomicInteger MESSAGE_ID = new AtomicInteger();
    protected final int messageID;
    protected final PrintStream stream;

    public PrintStreamInfoStream(PrintStream stream) {
        this(stream, MESSAGE_ID.getAndIncrement());
    }

    public PrintStreamInfoStream(PrintStream stream, int messageID) {
        this.stream = stream;
        this.messageID = messageID;
    }

    @Override
    public void message(String component, String message) {
        this.stream.println(component + " " + this.messageID + " [" + this.getTimestamp() + "; " + Thread.currentThread().getName() + "]: " + message);
    }

    @Override
    public boolean isEnabled(String component) {
        return true;
    }

    @Override
    public void close() throws IOException {
        if (!this.isSystemStream()) {
            this.stream.close();
        }
    }

    @SuppressForbidden(reason="System.out/err detection")
    public boolean isSystemStream() {
        return this.stream == System.out || this.stream == System.err;
    }

    protected String getTimestamp() {
        return Instant.now().toString();
    }
}

