/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.get;

import java.io.IOException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.Version;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.ActionRequestValidationException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.RealtimeRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.ValidateActions;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.support.single.shard.SingleShardRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Nullable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Strings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.VersionType;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.fetch.subphase.FetchSourceContext;

public class GetRequest
extends SingleShardRequest<GetRequest>
implements RealtimeRequest {
    private String type;
    private String id;
    private String routing;
    private String preference;
    private String[] storedFields;
    private FetchSourceContext fetchSourceContext;
    private boolean refresh = false;
    boolean realtime = true;
    private VersionType versionType = VersionType.INTERNAL;
    private long version = -3L;

    public GetRequest() {
        this.type = "_doc";
    }

    GetRequest(StreamInput in) throws IOException {
        super(in);
        this.type = in.readString();
        this.id = in.readString();
        this.routing = in.readOptionalString();
        if (in.getVersion().before(Version.V_7_0_0)) {
            in.readOptionalString();
        }
        this.preference = in.readOptionalString();
        this.refresh = in.readBoolean();
        this.storedFields = in.readOptionalStringArray();
        this.realtime = in.readBoolean();
        this.versionType = VersionType.fromValue(in.readByte());
        this.version = in.readLong();
        this.fetchSourceContext = in.readOptionalWriteable(FetchSourceContext::new);
    }

    public GetRequest(String index) {
        super(index);
        this.type = "_doc";
    }

    @Deprecated
    public GetRequest(String index, String type, String id) {
        super(index);
        this.type = type;
        this.id = id;
    }

    public GetRequest(String index, String id) {
        super(index);
        this.id = id;
        this.type = "_doc";
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = super.validateNonNullIndex();
        if (Strings.isEmpty(this.type)) {
            validationException = ValidateActions.addValidationError("type is missing", validationException);
        }
        if (Strings.isEmpty(this.id)) {
            validationException = ValidateActions.addValidationError("id is missing", validationException);
        }
        if (!this.versionType.validateVersionForReads(this.version)) {
            validationException = ValidateActions.addValidationError("illegal version value [" + this.version + "] for version type [" + this.versionType.name() + "]", validationException);
        }
        return validationException;
    }

    @Deprecated
    public GetRequest type(@Nullable String type) {
        if (type == null) {
            type = "_doc";
        }
        this.type = type;
        return this;
    }

    public GetRequest id(String id) {
        this.id = id;
        return this;
    }

    public GetRequest routing(String routing) {
        this.routing = routing;
        return this;
    }

    public GetRequest preference(String preference) {
        this.preference = preference;
        return this;
    }

    @Deprecated
    public String type() {
        return this.type;
    }

    public String id() {
        return this.id;
    }

    public String routing() {
        return this.routing;
    }

    public String preference() {
        return this.preference;
    }

    public GetRequest fetchSourceContext(FetchSourceContext context) {
        this.fetchSourceContext = context;
        return this;
    }

    public FetchSourceContext fetchSourceContext() {
        return this.fetchSourceContext;
    }

    public GetRequest storedFields(String ... fields) {
        this.storedFields = fields;
        return this;
    }

    public String[] storedFields() {
        return this.storedFields;
    }

    public GetRequest refresh(boolean refresh) {
        this.refresh = refresh;
        return this;
    }

    public boolean refresh() {
        return this.refresh;
    }

    public boolean realtime() {
        return this.realtime;
    }

    public GetRequest realtime(boolean realtime) {
        this.realtime = realtime;
        return this;
    }

    public long version() {
        return this.version;
    }

    public GetRequest version(long version) {
        this.version = version;
        return this;
    }

    public GetRequest versionType(VersionType versionType) {
        this.versionType = versionType;
        return this;
    }

    public VersionType versionType() {
        return this.versionType;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.type);
        out.writeString(this.id);
        out.writeOptionalString(this.routing);
        if (out.getVersion().before(Version.V_7_0_0)) {
            out.writeOptionalString(null);
        }
        out.writeOptionalString(this.preference);
        out.writeBoolean(this.refresh);
        out.writeOptionalStringArray(this.storedFields);
        out.writeBoolean(this.realtime);
        out.writeByte(this.versionType.getValue());
        out.writeLong(this.version);
        out.writeOptionalWriteable(this.fetchSourceContext);
    }

    public String toString() {
        return "get [" + this.index + "][" + this.type + "][" + this.id + "]: routing [" + this.routing + "]";
    }
}

