/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.cluster;

import java.util.List;
import java.util.Objects;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.cluster.RemoteConnectionInfo;

public class SniffModeInfo
implements RemoteConnectionInfo.ModeInfo {
    public static final String NAME = "sniff";
    static final String SEEDS = "seeds";
    static final String NUM_NODES_CONNECTED = "num_nodes_connected";
    static final String MAX_CONNECTIONS_PER_CLUSTER = "max_connections_per_cluster";
    final List<String> seedNodes;
    final int maxConnectionsPerCluster;
    final int numNodesConnected;

    SniffModeInfo(List<String> seedNodes, int maxConnectionsPerCluster, int numNodesConnected) {
        this.seedNodes = seedNodes;
        this.maxConnectionsPerCluster = maxConnectionsPerCluster;
        this.numNodesConnected = numNodesConnected;
    }

    @Override
    public boolean isConnected() {
        return this.numNodesConnected > 0;
    }

    @Override
    public String modeName() {
        return NAME;
    }

    public List<String> getSeedNodes() {
        return this.seedNodes;
    }

    public int getMaxConnectionsPerCluster() {
        return this.maxConnectionsPerCluster;
    }

    public int getNumNodesConnected() {
        return this.numNodesConnected;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SniffModeInfo sniff = (SniffModeInfo)o;
        return this.maxConnectionsPerCluster == sniff.maxConnectionsPerCluster && this.numNodesConnected == sniff.numNodesConnected && Objects.equals(this.seedNodes, sniff.seedNodes);
    }

    public int hashCode() {
        return Objects.hash(this.seedNodes, this.maxConnectionsPerCluster, this.numNodesConnected);
    }
}

