/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.enrich;

import java.io.IOException;
import java.util.List;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.ParseField;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.ParsingException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.bytes.BytesReference;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentParser;

public final class NamedPolicy {
    static final ParseField NAME_FIELD = new ParseField("name", new String[0]);
    static final ParseField QUERY_FIELD = new ParseField("query", new String[0]);
    static final ParseField INDICES_FIELD = new ParseField("indices", new String[0]);
    static final ParseField MATCH_FIELD_FIELD = new ParseField("match_field", new String[0]);
    static final ParseField ENRICH_FIELDS_FIELD = new ParseField("enrich_fields", new String[0]);
    private static final ConstructingObjectParser<NamedPolicy, String> PARSER = new ConstructingObjectParser<NamedPolicy, String>("policy", true, (args, policyType) -> new NamedPolicy((String)policyType, (String)args[0], (BytesReference)args[1], (List)args[2], (String)args[3], (List)args[4]));
    private final String type;
    private final String name;
    private final BytesReference query;
    private final List<String> indices;
    private final String matchField;
    private final List<String> enrichFields;

    private static void declareParserOptions(ConstructingObjectParser<?, ?> parser) {
        parser.declareString(ConstructingObjectParser.constructorArg(), NAME_FIELD);
        parser.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> {
            XContentBuilder builder = XContentBuilder.builder(p.contentType().xContent());
            builder.copyCurrentStructure(p);
            return BytesReference.bytes(builder);
        }, QUERY_FIELD);
        parser.declareStringArray(ConstructingObjectParser.constructorArg(), INDICES_FIELD);
        parser.declareString(ConstructingObjectParser.constructorArg(), MATCH_FIELD_FIELD);
        parser.declareStringArray(ConstructingObjectParser.constructorArg(), ENRICH_FIELDS_FIELD);
    }

    public static NamedPolicy fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.currentToken();
        if (token != XContentParser.Token.START_OBJECT) {
            token = parser.nextToken();
        }
        if (token != XContentParser.Token.START_OBJECT) {
            throw new ParsingException(parser.getTokenLocation(), "unexpected token", new Object[0]);
        }
        token = parser.nextToken();
        if (token != XContentParser.Token.FIELD_NAME) {
            throw new ParsingException(parser.getTokenLocation(), "unexpected token", new Object[0]);
        }
        String policyType = parser.currentName();
        NamedPolicy policy = PARSER.parse(parser, policyType);
        token = parser.nextToken();
        if (token != XContentParser.Token.END_OBJECT) {
            throw new ParsingException(parser.getTokenLocation(), "unexpected token", new Object[0]);
        }
        return policy;
    }

    NamedPolicy(String type, String name, BytesReference query, List<String> indices, String matchField, List<String> enrichFields) {
        this.type = type;
        this.name = name;
        this.query = query;
        this.indices = indices;
        this.matchField = matchField;
        this.enrichFields = enrichFields;
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public BytesReference getQuery() {
        return this.query;
    }

    public List<String> getIndices() {
        return this.indices;
    }

    public String getMatchField() {
        return this.matchField;
    }

    public List<String> getEnrichFields() {
        return this.enrichFields;
    }

    static {
        NamedPolicy.declareParserOptions(PARSER);
    }
}

