/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.ml.dataframe.evaluation.outlierdetection;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.ml.dataframe.evaluation.Evaluation;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.ml.dataframe.evaluation.EvaluationMetric;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.ml.dataframe.evaluation.MlEvaluationNamedXContentProvider;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Nullable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.ParseField;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentParser;

public class OutlierDetection
implements Evaluation {
    public static final String NAME = "outlier_detection";
    private static final ParseField ACTUAL_FIELD = new ParseField("actual_field", new String[0]);
    private static final ParseField PREDICTED_PROBABILITY_FIELD = new ParseField("predicted_probability_field", new String[0]);
    private static final ParseField METRICS = new ParseField("metrics", new String[0]);
    public static final ConstructingObjectParser<OutlierDetection, Void> PARSER = new ConstructingObjectParser("outlier_detection", true, args -> new OutlierDetection((String)args[0], (String)args[1], (List)args[2]));
    private final String actualField;
    private final String predictedProbabilityField;
    private final List<EvaluationMetric> metrics;

    public static OutlierDetection fromXContent(XContentParser parser) {
        return PARSER.apply(parser, null);
    }

    public OutlierDetection(String actualField, String predictedField) {
        this(actualField, predictedField, (List<EvaluationMetric>)null);
    }

    public OutlierDetection(String actualField, String predictedProbabilityField, EvaluationMetric ... metric) {
        this(actualField, predictedProbabilityField, Arrays.asList(metric));
    }

    public OutlierDetection(String actualField, String predictedProbabilityField, @Nullable List<EvaluationMetric> metrics) {
        this.actualField = Objects.requireNonNull(actualField);
        this.predictedProbabilityField = Objects.requireNonNull(predictedProbabilityField);
        if (metrics != null) {
            metrics.sort(Comparator.comparing(EvaluationMetric::getName));
        }
        this.metrics = metrics;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(ACTUAL_FIELD.getPreferredName(), this.actualField);
        builder.field(PREDICTED_PROBABILITY_FIELD.getPreferredName(), this.predictedProbabilityField);
        if (this.metrics != null) {
            builder.startObject(METRICS.getPreferredName());
            for (EvaluationMetric metric : this.metrics) {
                builder.field(metric.getName(), metric);
            }
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OutlierDetection that = (OutlierDetection)o;
        return Objects.equals(this.actualField, that.actualField) && Objects.equals(this.predictedProbabilityField, that.predictedProbabilityField) && Objects.equals(this.metrics, that.metrics);
    }

    public int hashCode() {
        return Objects.hash(this.actualField, this.predictedProbabilityField, this.metrics);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), ACTUAL_FIELD);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), PREDICTED_PROBABILITY_FIELD);
        PARSER.declareNamedObjects(ConstructingObjectParser.optionalConstructorArg(), (p, c, n) -> p.namedObject(EvaluationMetric.class, MlEvaluationNamedXContentProvider.registeredMetricName(NAME, n), null), METRICS);
    }
}

