/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.ml.job.process;

import java.io.IOException;
import java.util.Date;
import java.util.Objects;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.Version;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.common.TimeUtil;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.ml.job.config.Job;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.ml.job.process.ModelSizeStats;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.ml.job.process.Quantiles;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.ParseField;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ObjectParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContentObject;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;

public class ModelSnapshot
implements ToXContentObject {
    public static final ParseField TIMESTAMP = new ParseField("timestamp", new String[0]);
    public static final ParseField DESCRIPTION = new ParseField("description", new String[0]);
    public static final ParseField SNAPSHOT_DOC_COUNT = new ParseField("snapshot_doc_count", new String[0]);
    public static final ParseField LATEST_RECORD_TIME = new ParseField("latest_record_time_stamp", new String[0]);
    public static final ParseField LATEST_RESULT_TIME = new ParseField("latest_result_time_stamp", new String[0]);
    public static final ParseField QUANTILES = new ParseField("quantiles", new String[0]);
    public static final ParseField RETAIN = new ParseField("retain", new String[0]);
    public static final ParseField MIN_VERSION = new ParseField("min_version", new String[0]);
    public static final ParseField SNAPSHOT_ID = new ParseField("snapshot_id", new String[0]);
    public static final ObjectParser<Builder, Void> PARSER = new ObjectParser("model_snapshot", true, Builder::new);
    private final String jobId;
    private final Version minVersion;
    private final Date timestamp;
    private final String description;
    private final String snapshotId;
    private final int snapshotDocCount;
    private final ModelSizeStats modelSizeStats;
    private final Date latestRecordTimeStamp;
    private final Date latestResultTimeStamp;
    private final Quantiles quantiles;
    private final boolean retain;

    private ModelSnapshot(String jobId, Version minVersion, Date timestamp, String description, String snapshotId, int snapshotDocCount, ModelSizeStats modelSizeStats, Date latestRecordTimeStamp, Date latestResultTimeStamp, Quantiles quantiles, boolean retain) {
        this.jobId = jobId;
        this.minVersion = minVersion;
        this.timestamp = timestamp;
        this.description = description;
        this.snapshotId = snapshotId;
        this.snapshotDocCount = snapshotDocCount;
        this.modelSizeStats = modelSizeStats;
        this.latestRecordTimeStamp = latestRecordTimeStamp;
        this.latestResultTimeStamp = latestResultTimeStamp;
        this.quantiles = quantiles;
        this.retain = retain;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(Job.ID.getPreferredName(), this.jobId);
        builder.field(MIN_VERSION.getPreferredName(), this.minVersion);
        if (this.timestamp != null) {
            builder.timeField(TIMESTAMP.getPreferredName(), TIMESTAMP.getPreferredName() + "_string", this.timestamp.getTime());
        }
        if (this.description != null) {
            builder.field(DESCRIPTION.getPreferredName(), this.description);
        }
        if (this.snapshotId != null) {
            builder.field(SNAPSHOT_ID.getPreferredName(), this.snapshotId);
        }
        builder.field(SNAPSHOT_DOC_COUNT.getPreferredName(), this.snapshotDocCount);
        if (this.modelSizeStats != null) {
            builder.field(ModelSizeStats.RESULT_TYPE_FIELD.getPreferredName(), this.modelSizeStats);
        }
        if (this.latestRecordTimeStamp != null) {
            builder.timeField(LATEST_RECORD_TIME.getPreferredName(), LATEST_RECORD_TIME.getPreferredName() + "_string", this.latestRecordTimeStamp.getTime());
        }
        if (this.latestResultTimeStamp != null) {
            builder.timeField(LATEST_RESULT_TIME.getPreferredName(), LATEST_RESULT_TIME.getPreferredName() + "_string", this.latestResultTimeStamp.getTime());
        }
        if (this.quantiles != null) {
            builder.field(QUANTILES.getPreferredName(), this.quantiles);
        }
        builder.field(RETAIN.getPreferredName(), this.retain);
        builder.endObject();
        return builder;
    }

    public String getJobId() {
        return this.jobId;
    }

    public Version getMinVersion() {
        return this.minVersion;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public String getDescription() {
        return this.description;
    }

    public String getSnapshotId() {
        return this.snapshotId;
    }

    public int getSnapshotDocCount() {
        return this.snapshotDocCount;
    }

    public ModelSizeStats getModelSizeStats() {
        return this.modelSizeStats;
    }

    public Quantiles getQuantiles() {
        return this.quantiles;
    }

    public boolean getRetain() {
        return this.retain;
    }

    public Date getLatestRecordTimeStamp() {
        return this.latestRecordTimeStamp;
    }

    public Date getLatestResultTimeStamp() {
        return this.latestResultTimeStamp;
    }

    public int hashCode() {
        return Objects.hash(this.jobId, this.minVersion, this.timestamp, this.description, this.snapshotId, this.quantiles, this.snapshotDocCount, this.modelSizeStats, this.latestRecordTimeStamp, this.latestResultTimeStamp, this.retain);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ModelSnapshot that = (ModelSnapshot)other;
        return Objects.equals(this.jobId, that.jobId) && Objects.equals(this.minVersion, that.minVersion) && Objects.equals(this.timestamp, that.timestamp) && Objects.equals(this.description, that.description) && Objects.equals(this.snapshotId, that.snapshotId) && this.snapshotDocCount == that.snapshotDocCount && Objects.equals(this.modelSizeStats, that.modelSizeStats) && Objects.equals(this.quantiles, that.quantiles) && Objects.equals(this.latestRecordTimeStamp, that.latestRecordTimeStamp) && Objects.equals(this.latestResultTimeStamp, that.latestResultTimeStamp) && this.retain == that.retain;
    }

    static {
        PARSER.declareString(Builder::setJobId, Job.ID);
        PARSER.declareString(Builder::setMinVersion, MIN_VERSION);
        PARSER.declareField(Builder::setTimestamp, p -> TimeUtil.parseTimeField(p, TIMESTAMP.getPreferredName()), TIMESTAMP, ObjectParser.ValueType.VALUE);
        PARSER.declareString(Builder::setDescription, DESCRIPTION);
        PARSER.declareString(Builder::setSnapshotId, SNAPSHOT_ID);
        PARSER.declareInt(Builder::setSnapshotDocCount, SNAPSHOT_DOC_COUNT);
        PARSER.declareObject(Builder::setModelSizeStats, ModelSizeStats.PARSER, ModelSizeStats.RESULT_TYPE_FIELD);
        PARSER.declareField(Builder::setLatestRecordTimeStamp, p -> TimeUtil.parseTimeField(p, LATEST_RECORD_TIME.getPreferredName()), LATEST_RECORD_TIME, ObjectParser.ValueType.VALUE);
        PARSER.declareField(Builder::setLatestResultTimeStamp, p -> TimeUtil.parseTimeField(p, LATEST_RESULT_TIME.getPreferredName()), LATEST_RESULT_TIME, ObjectParser.ValueType.VALUE);
        PARSER.declareObject(Builder::setQuantiles, Quantiles.PARSER, QUANTILES);
        PARSER.declareBoolean(Builder::setRetain, RETAIN);
    }

    public static class Builder {
        private String jobId;
        private Version minVersion = Version.V_6_3_0;
        private Date timestamp;
        private String description;
        private String snapshotId;
        private int snapshotDocCount;
        private ModelSizeStats modelSizeStats;
        private Date latestRecordTimeStamp;
        private Date latestResultTimeStamp;
        private Quantiles quantiles;
        private boolean retain;

        public Builder() {
        }

        public Builder(String jobId) {
            this.jobId = jobId;
        }

        public Builder(ModelSnapshot modelSnapshot) {
            this.jobId = modelSnapshot.jobId;
            this.timestamp = modelSnapshot.timestamp;
            this.description = modelSnapshot.description;
            this.snapshotId = modelSnapshot.snapshotId;
            this.snapshotDocCount = modelSnapshot.snapshotDocCount;
            this.modelSizeStats = modelSnapshot.modelSizeStats;
            this.latestRecordTimeStamp = modelSnapshot.latestRecordTimeStamp;
            this.latestResultTimeStamp = modelSnapshot.latestResultTimeStamp;
            this.quantiles = modelSnapshot.quantiles;
            this.retain = modelSnapshot.retain;
            this.minVersion = modelSnapshot.minVersion;
        }

        public Builder setJobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        Builder setMinVersion(Version minVersion) {
            this.minVersion = minVersion;
            return this;
        }

        Builder setMinVersion(String minVersion) {
            this.minVersion = Version.fromString(minVersion);
            return this;
        }

        public Builder setTimestamp(Date timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public Builder setSnapshotDocCount(int snapshotDocCount) {
            this.snapshotDocCount = snapshotDocCount;
            return this;
        }

        public Builder setModelSizeStats(ModelSizeStats.Builder modelSizeStats) {
            this.modelSizeStats = modelSizeStats.build();
            return this;
        }

        public Builder setModelSizeStats(ModelSizeStats modelSizeStats) {
            this.modelSizeStats = modelSizeStats;
            return this;
        }

        public Builder setLatestRecordTimeStamp(Date latestRecordTimeStamp) {
            this.latestRecordTimeStamp = latestRecordTimeStamp;
            return this;
        }

        public Builder setLatestResultTimeStamp(Date latestResultTimeStamp) {
            this.latestResultTimeStamp = latestResultTimeStamp;
            return this;
        }

        public Builder setQuantiles(Quantiles quantiles) {
            this.quantiles = quantiles;
            return this;
        }

        public Builder setRetain(boolean value) {
            this.retain = value;
            return this;
        }

        public ModelSnapshot build() {
            return new ModelSnapshot(this.jobId, this.minVersion, this.timestamp, this.description, this.snapshotId, this.snapshotDocCount, this.modelSizeStats, this.latestRecordTimeStamp, this.latestResultTimeStamp, this.quantiles, this.retain);
        }
    }
}

