/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.ParseField;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ObjectParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContentFragment;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.gateway.MetadataStateFormat;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.Index;

public class Manifest
implements ToXContentFragment {
    private static final long MISSING_GLOBAL_GENERATION = -1L;
    private static final long MISSING_CURRENT_TERM = 0L;
    private static final long UNKNOWN_CURRENT_TERM = 0L;
    private static final long MISSING_CLUSTER_STATE_VERSION = 0L;
    private static final long UNKNOWN_CLUSTER_STATE_VERSION = 0L;
    private final long globalGeneration;
    private final Map<Index, Long> indexGenerations;
    private final long currentTerm;
    private final long clusterStateVersion;
    private static final String MANIFEST_FILE_PREFIX = "manifest-";
    private static final ToXContent.Params MANIFEST_FORMAT_PARAMS = new ToXContent.MapParams(Collections.singletonMap("binary", "true"));
    public static final MetadataStateFormat<Manifest> FORMAT = new MetadataStateFormat<Manifest>("manifest-"){

        @Override
        public void toXContent(XContentBuilder builder, Manifest state) throws IOException {
            state.toXContent(builder, MANIFEST_FORMAT_PARAMS);
        }

        @Override
        public Manifest fromXContent(XContentParser parser) throws IOException {
            return Manifest.fromXContent(parser);
        }
    };
    private static final ParseField CURRENT_TERM_PARSE_FIELD = new ParseField("current_term", new String[0]);
    private static final ParseField CLUSTER_STATE_VERSION_PARSE_FIELD = new ParseField("cluster_state_version", new String[0]);
    private static final ParseField GENERATION_PARSE_FIELD = new ParseField("generation", new String[0]);
    private static final ParseField INDEX_GENERATIONS_PARSE_FIELD = new ParseField("index_generations", new String[0]);
    private static final ConstructingObjectParser<Manifest, Void> PARSER = new ConstructingObjectParser("manifest", manifestFields -> new Manifest(Manifest.currentTerm(manifestFields), Manifest.clusterStateVersion(manifestFields), Manifest.generation(manifestFields), Manifest.indices(manifestFields)));

    public Manifest(long currentTerm, long clusterStateVersion, long globalGeneration, Map<Index, Long> indexGenerations) {
        this.currentTerm = currentTerm;
        this.clusterStateVersion = clusterStateVersion;
        this.globalGeneration = globalGeneration;
        this.indexGenerations = indexGenerations;
    }

    public static Manifest unknownCurrentTermAndVersion(long globalGeneration, Map<Index, Long> indexGenerations) {
        return new Manifest(0L, 0L, globalGeneration, indexGenerations);
    }

    public long getGlobalGeneration() {
        return this.globalGeneration;
    }

    public Map<Index, Long> getIndexGenerations() {
        return this.indexGenerations;
    }

    public long getCurrentTerm() {
        return this.currentTerm;
    }

    public long getClusterStateVersion() {
        return this.clusterStateVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Manifest manifest = (Manifest)o;
        return this.currentTerm == manifest.currentTerm && this.clusterStateVersion == manifest.clusterStateVersion && this.globalGeneration == manifest.globalGeneration && Objects.equals(this.indexGenerations, manifest.indexGenerations);
    }

    public int hashCode() {
        return Objects.hash(this.currentTerm, this.clusterStateVersion, this.globalGeneration, this.indexGenerations);
    }

    public String toString() {
        return "Manifest{currentTerm=" + this.currentTerm + ", clusterStateVersion=" + this.clusterStateVersion + ", globalGeneration=" + this.globalGeneration + ", indexGenerations=" + this.indexGenerations + '}';
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(CURRENT_TERM_PARSE_FIELD.getPreferredName(), this.currentTerm);
        builder.field(CLUSTER_STATE_VERSION_PARSE_FIELD.getPreferredName(), this.clusterStateVersion);
        builder.field(GENERATION_PARSE_FIELD.getPreferredName(), this.globalGeneration);
        builder.array(INDEX_GENERATIONS_PARSE_FIELD.getPreferredName(), this.indexEntryList().toArray());
        return builder;
    }

    private static long requireNonNullElseDefault(Long value, long defaultValue) {
        return value != null ? value : defaultValue;
    }

    private List<IndexEntry> indexEntryList() {
        return this.indexGenerations.entrySet().stream().map(entry -> new IndexEntry((Index)entry.getKey(), (Long)entry.getValue())).collect(Collectors.toList());
    }

    private static long currentTerm(Object[] manifestFields) {
        return Manifest.requireNonNullElseDefault((Long)manifestFields[0], 0L);
    }

    private static long clusterStateVersion(Object[] manifestFields) {
        return Manifest.requireNonNullElseDefault((Long)manifestFields[1], 0L);
    }

    private static long generation(Object[] manifestFields) {
        return Manifest.requireNonNullElseDefault((Long)manifestFields[2], -1L);
    }

    private static Map<Index, Long> indices(Object[] manifestFields) {
        List listOfIndices = (List)manifestFields[3];
        return listOfIndices.stream().collect(Collectors.toMap(IndexEntry::getIndex, IndexEntry::getGeneration));
    }

    public static Manifest fromXContent(XContentParser parser) throws IOException {
        return PARSER.parse(parser, null);
    }

    public boolean isEmpty() {
        return this.currentTerm == 0L && this.clusterStateVersion == 0L && this.globalGeneration == -1L && this.indexGenerations.isEmpty();
    }

    public static Manifest empty() {
        return new Manifest(0L, 0L, -1L, Collections.emptyMap());
    }

    public boolean isGlobalGenerationMissing() {
        return this.globalGeneration == -1L;
    }

    static {
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), CURRENT_TERM_PARSE_FIELD);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), CLUSTER_STATE_VERSION_PARSE_FIELD);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), GENERATION_PARSE_FIELD);
        PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), IndexEntry.INDEX_ENTRY_PARSER, INDEX_GENERATIONS_PARSE_FIELD);
    }

    private static final class IndexEntry
    implements ToXContentFragment {
        private static final ParseField INDEX_GENERATION_PARSE_FIELD = new ParseField("generation", new String[0]);
        private static final ParseField INDEX_PARSE_FIELD = new ParseField("index", new String[0]);
        static final ConstructingObjectParser<IndexEntry, Void> INDEX_ENTRY_PARSER = new ConstructingObjectParser("indexEntry", indexAndGeneration -> new IndexEntry((Index)indexAndGeneration[0], (Long)indexAndGeneration[1]));
        private final long generation;
        private final Index index;

        IndexEntry(Index index, long generation) {
            this.index = index;
            this.generation = generation;
        }

        public long getGeneration() {
            return this.generation;
        }

        public Index getIndex() {
            return this.index;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(INDEX_PARSE_FIELD.getPreferredName(), this.index);
            builder.field(GENERATION_PARSE_FIELD.getPreferredName(), this.generation);
            builder.endObject();
            return builder;
        }

        static {
            INDEX_ENTRY_PARSER.declareField(ConstructingObjectParser.constructorArg(), Index::fromXContent, INDEX_PARSE_FIELD, ObjectParser.ValueType.OBJECT);
            INDEX_ENTRY_PARSER.declareLong(ConstructingObjectParser.constructorArg(), INDEX_GENERATION_PARSE_FIELD);
        }
    }
}

