/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.ExceptionsHelper;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.Version;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.ActionListener;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsClusterStateUpdateRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.indices.upgrade.post.UpgradeSettingsClusterStateUpdateRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.support.ContextPreservingActionListener;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.ClusterState;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.ack.AckedRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.ack.ClusterStateUpdateResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.block.ClusterBlock;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.block.ClusterBlocks;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.metadata.IndexMetadata;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.metadata.Metadata;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.metadata.MetadataCreateIndexService;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.routing.RoutingTable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.service.ClusterService;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Priority;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.ValidationException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.collect.Tuple;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.inject.Inject;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.regex.Regex;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.settings.IndexScopedSettings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.settings.Setting;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.settings.Settings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.Index;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.IndexSettings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.indices.IndicesService;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.indices.ShardLimitValidator;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.threadpool.ThreadPool;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MetadataUpdateSettingsService {
    private static final Logger logger = LogManager.getLogger(MetadataUpdateSettingsService.class);
    private final ClusterService clusterService;
    private final AllocationService allocationService;
    private final IndexScopedSettings indexScopedSettings;
    private final IndicesService indicesService;
    private final ShardLimitValidator shardLimitValidator;
    private final ThreadPool threadPool;

    @Inject
    public MetadataUpdateSettingsService(ClusterService clusterService, AllocationService allocationService, IndexScopedSettings indexScopedSettings, IndicesService indicesService, ShardLimitValidator shardLimitValidator, ThreadPool threadPool) {
        this.clusterService = clusterService;
        this.threadPool = threadPool;
        this.allocationService = allocationService;
        this.indexScopedSettings = indexScopedSettings;
        this.indicesService = indicesService;
        this.shardLimitValidator = shardLimitValidator;
    }

    public void updateSettings(final UpdateSettingsClusterStateUpdateRequest request, ActionListener<ClusterStateUpdateResponse> listener) {
        final Settings normalizedSettings = Settings.builder().put(request.settings()).normalizePrefix("index.").build();
        Settings.Builder settingsForClosedIndices = Settings.builder();
        Settings.Builder settingsForOpenIndices = Settings.builder();
        final HashSet<String> skippedSettings = new HashSet<String>();
        this.indexScopedSettings.validate(normalizedSettings.filter(s -> !Regex.isSimpleMatchPattern(s)), false, true);
        for (String key : normalizedSettings.keySet()) {
            boolean isWildcard;
            Setting<?> setting = this.indexScopedSettings.get(key);
            boolean bl = isWildcard = setting == null && Regex.isSimpleMatchPattern(key);
            assert (setting != null || isWildcard && !normalizedSettings.hasValue(key)) : "unknown setting: " + key + " isWildcard: " + isWildcard + " hasValue: " + normalizedSettings.hasValue(key);
            settingsForClosedIndices.copy(key, normalizedSettings);
            if (isWildcard || setting.isDynamic()) {
                settingsForOpenIndices.copy(key, normalizedSettings);
                continue;
            }
            skippedSettings.add(key);
        }
        final Settings closedSettings = settingsForClosedIndices.build();
        final Settings openSettings = settingsForOpenIndices.build();
        final boolean preserveExisting = request.isPreserveExisting();
        this.clusterService.submitStateUpdateTask("update-settings " + Arrays.toString(request.indices()), new AckedClusterStateUpdateTask<ClusterStateUpdateResponse>(Priority.URGENT, (AckedRequest)request, ContextPreservingActionListener.wrapPreservingContext(listener, this.threadPool.getThreadContext())){

            @Override
            protected ClusterStateUpdateResponse newResponse(boolean acknowledged) {
                return new ClusterStateUpdateResponse(acknowledged);
            }

            @Override
            public ClusterState execute(ClusterState currentState) {
                Settings finalSettings;
                Settings.Builder indexSettings;
                Settings.Builder updates;
                IndexMetadata indexMetadata;
                RoutingTable.Builder routingTableBuilder = RoutingTable.builder(currentState.routingTable());
                Metadata.Builder metadataBuilder = Metadata.builder(currentState.metadata());
                HashSet<Index> openIndices = new HashSet<Index>();
                HashSet<Index> closeIndices = new HashSet<Index>();
                String[] actualIndices = new String[request.indices().length];
                for (int i2 = 0; i2 < request.indices().length; ++i2) {
                    Index index = request.indices()[i2];
                    actualIndices[i2] = index.getName();
                    IndexMetadata metadata = currentState.metadata().getIndexSafe(index);
                    if (metadata.getState() == IndexMetadata.State.OPEN) {
                        openIndices.add(index);
                        continue;
                    }
                    closeIndices.add(index);
                }
                if (!skippedSettings.isEmpty() && !openIndices.isEmpty()) {
                    throw new IllegalArgumentException(String.format(Locale.ROOT, "Can't update non dynamic settings [%s] for open indices %s", skippedSettings, openIndices));
                }
                if (IndexMetadata.INDEX_NUMBER_OF_REPLICAS_SETTING.exists(openSettings)) {
                    int updatedNumberOfReplicas = IndexMetadata.INDEX_NUMBER_OF_REPLICAS_SETTING.get(openSettings);
                    if (!preserveExisting) {
                        int totalNewShards = Arrays.stream(request.indices()).mapToInt(i -> MetadataUpdateSettingsService.this.getTotalNewShards(i, currentState, updatedNumberOfReplicas)).sum();
                        Optional<String> error = MetadataUpdateSettingsService.this.shardLimitValidator.checkShardLimit(totalNewShards, currentState);
                        if (error.isPresent()) {
                            ValidationException ex = new ValidationException();
                            ex.addValidationError(error.get());
                            throw ex;
                        }
                        routingTableBuilder.updateNumberOfReplicas(updatedNumberOfReplicas, actualIndices);
                        metadataBuilder.updateNumberOfReplicas(updatedNumberOfReplicas, actualIndices);
                        logger.info("updating number_of_replicas to [{}] for indices {}", (Object)updatedNumberOfReplicas, (Object)actualIndices);
                    }
                }
                if (!openIndices.isEmpty()) {
                    for (Index index : openIndices) {
                        indexMetadata = metadataBuilder.getSafe(index);
                        updates = Settings.builder();
                        indexSettings = Settings.builder().put(indexMetadata.getSettings());
                        if (!MetadataUpdateSettingsService.this.indexScopedSettings.updateDynamicSettings(openSettings, indexSettings, updates, index.getName())) continue;
                        if (preserveExisting) {
                            indexSettings.put(indexMetadata.getSettings());
                        }
                        if (!IndexMetadata.INDEX_NUMBER_OF_REPLICAS_SETTING.exists(indexSettings)) {
                            indexSettings.put("index.number_of_replicas", IndexMetadata.INDEX_NUMBER_OF_REPLICAS_SETTING.get(Settings.EMPTY));
                        }
                        finalSettings = indexSettings.build();
                        MetadataUpdateSettingsService.this.indexScopedSettings.validate(finalSettings.filter(k -> !MetadataUpdateSettingsService.this.indexScopedSettings.isPrivateSetting((String)k)), true);
                        metadataBuilder.put(IndexMetadata.builder(indexMetadata).settings(finalSettings));
                    }
                }
                if (!closeIndices.isEmpty()) {
                    for (Index index : closeIndices) {
                        indexMetadata = metadataBuilder.getSafe(index);
                        updates = Settings.builder();
                        indexSettings = Settings.builder().put(indexMetadata.getSettings());
                        if (!MetadataUpdateSettingsService.this.indexScopedSettings.updateSettings(closedSettings, indexSettings, updates, index.getName())) continue;
                        if (preserveExisting) {
                            indexSettings.put(indexMetadata.getSettings());
                        }
                        if (!IndexMetadata.INDEX_NUMBER_OF_REPLICAS_SETTING.exists(indexSettings)) {
                            indexSettings.put("index.number_of_replicas", IndexMetadata.INDEX_NUMBER_OF_REPLICAS_SETTING.get(Settings.EMPTY));
                        }
                        finalSettings = indexSettings.build();
                        MetadataUpdateSettingsService.this.indexScopedSettings.validate(finalSettings.filter(k -> !MetadataUpdateSettingsService.this.indexScopedSettings.isPrivateSetting((String)k)), true);
                        metadataBuilder.put(IndexMetadata.builder(indexMetadata).settings(finalSettings));
                    }
                }
                if (IndexSettings.INDEX_TRANSLOG_RETENTION_AGE_SETTING.exists(normalizedSettings) || IndexSettings.INDEX_TRANSLOG_RETENTION_SIZE_SETTING.exists(normalizedSettings)) {
                    for (String index : actualIndices) {
                        MetadataCreateIndexService.validateTranslogRetentionSettings(metadataBuilder.get(index).getSettings());
                    }
                }
                boolean changed = false;
                for (String index : actualIndices) {
                    if (IndexSettings.same(currentState.metadata().index(index).getSettings(), metadataBuilder.get(index).getSettings())) continue;
                    changed = true;
                    IndexMetadata.Builder builder = IndexMetadata.builder(metadataBuilder.get(index));
                    builder.settingsVersion(1L + builder.settingsVersion());
                    metadataBuilder.put(builder);
                }
                ClusterBlocks.Builder blocks = ClusterBlocks.builder().blocks(currentState.blocks());
                for (IndexMetadata.APIBlock block : IndexMetadata.APIBlock.values()) {
                    changed |= MetadataUpdateSettingsService.maybeUpdateClusterBlock(actualIndices, blocks, block.block, block.setting, openSettings);
                }
                if (!changed) {
                    return currentState;
                }
                ClusterState updatedState = ClusterState.builder(currentState).metadata(metadataBuilder).routingTable(routingTableBuilder.build()).blocks(blocks).build();
                updatedState = MetadataUpdateSettingsService.this.allocationService.reroute(updatedState, "settings update");
                try {
                    IndexMetadata updatedMetadata;
                    IndexMetadata currentMetadata;
                    for (Index index : openIndices) {
                        currentMetadata = currentState.getMetadata().getIndexSafe(index);
                        updatedMetadata = updatedState.metadata().getIndexSafe(index);
                        MetadataUpdateSettingsService.this.indicesService.verifyIndexMetadata(currentMetadata, updatedMetadata);
                    }
                    for (Index index : closeIndices) {
                        currentMetadata = currentState.getMetadata().getIndexSafe(index);
                        updatedMetadata = updatedState.metadata().getIndexSafe(index);
                        MetadataUpdateSettingsService.this.indicesService.verifyIndexMetadata(currentMetadata, updatedMetadata);
                        MetadataUpdateSettingsService.this.indicesService.verifyIndexMetadata(updatedMetadata, updatedMetadata);
                    }
                }
                catch (IOException ex) {
                    throw ExceptionsHelper.convertToElastic(ex);
                }
                return updatedState;
            }
        });
    }

    private int getTotalNewShards(Index index, ClusterState currentState, int updatedNumberOfReplicas) {
        IndexMetadata indexMetadata = currentState.metadata().index(index);
        int shardsInIndex = indexMetadata.getNumberOfShards();
        int oldNumberOfReplicas = indexMetadata.getNumberOfReplicas();
        int replicaIncrease = updatedNumberOfReplicas - oldNumberOfReplicas;
        return replicaIncrease * shardsInIndex;
    }

    private static boolean maybeUpdateClusterBlock(String[] actualIndices, ClusterBlocks.Builder blocks, ClusterBlock block, Setting<Boolean> setting, Settings openSettings) {
        boolean changed = false;
        if (setting.exists(openSettings)) {
            boolean updateBlock = setting.get(openSettings);
            for (String index : actualIndices) {
                if (updateBlock) {
                    if (blocks.hasIndexBlock(index, block)) continue;
                    blocks.addIndexBlock(index, block);
                    changed = true;
                    continue;
                }
                if (!blocks.hasIndexBlock(index, block)) continue;
                blocks.removeIndexBlock(index, block);
                changed = true;
            }
        }
        return changed;
    }

    public void upgradeIndexSettings(final UpgradeSettingsClusterStateUpdateRequest request, ActionListener<ClusterStateUpdateResponse> listener) {
        this.clusterService.submitStateUpdateTask("update-index-compatibility-versions", new AckedClusterStateUpdateTask<ClusterStateUpdateResponse>(Priority.URGENT, (AckedRequest)request, ContextPreservingActionListener.wrapPreservingContext(listener, this.threadPool.getThreadContext())){

            @Override
            protected ClusterStateUpdateResponse newResponse(boolean acknowledged) {
                return new ClusterStateUpdateResponse(acknowledged);
            }

            @Override
            public ClusterState execute(ClusterState currentState) {
                Metadata.Builder metadataBuilder = Metadata.builder(currentState.metadata());
                for (Map.Entry<String, Tuple<Version, String>> entry : request.versions().entrySet()) {
                    String index = entry.getKey();
                    IndexMetadata indexMetadata = metadataBuilder.get(index);
                    if (indexMetadata == null || Version.CURRENT.equals(indexMetadata.getCreationVersion())) continue;
                    metadataBuilder.put(IndexMetadata.builder(indexMetadata).settings(Settings.builder().put(indexMetadata.getSettings()).put("index.version.upgraded", entry.getValue().v1())).settingsVersion(1L + indexMetadata.getSettingsVersion()));
                }
                return ClusterState.builder(currentState).metadata(metadataBuilder).build();
            }
        });
    }
}

