/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.flink.elasticsearch7.shaded.com.carrotsearch.hppc.ObjectObjectHashMap;
import org.apache.flink.elasticsearch7.shaded.com.carrotsearch.hppc.ObjectObjectMap;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.document.Field;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.IndexableField;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.Version;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.IndexSettings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.ContentPath;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.DocumentMapper;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.DocumentMapperParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.Mapper;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.MapperParsingException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.MapperService;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.RootObjectMapper;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.SeqNoFieldMapper;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.SourceToParse;

public abstract class ParseContext
implements Iterable<Document> {
    public abstract Iterable<Document> nonRootDocuments();

    public abstract void addIgnoredField(String var1);

    public abstract Collection<String> getIgnoredFields();

    public abstract DocumentMapperParser docMapperParser();

    public final ParseContext createCopyToContext() {
        return new FilterParseContext(this){

            @Override
            public boolean isWithinCopyTo() {
                return true;
            }
        };
    }

    public boolean isWithinCopyTo() {
        return false;
    }

    public final ParseContext createMultiFieldContext() {
        return new FilterParseContext(this){

            @Override
            public boolean isWithinMultiFields() {
                return true;
            }
        };
    }

    public final ParseContext createNestedContext(String fullPath) {
        Document doc = new Document(fullPath, this.doc());
        this.addDoc(doc);
        return this.switchDoc(doc);
    }

    public final ParseContext switchDoc(final Document document) {
        return new FilterParseContext(this){

            @Override
            public Document doc() {
                return document;
            }
        };
    }

    public final ParseContext overridePath(final ContentPath path) {
        return new FilterParseContext(this){

            @Override
            public ContentPath path() {
                return path;
            }
        };
    }

    public boolean isWithinMultiFields() {
        return false;
    }

    public abstract IndexSettings indexSettings();

    public abstract SourceToParse sourceToParse();

    public abstract ContentPath path();

    public abstract XContentParser parser();

    public abstract Document rootDoc();

    public abstract Document doc();

    protected abstract void addDoc(Document var1);

    public abstract RootObjectMapper root();

    public abstract DocumentMapper docMapper();

    public abstract MapperService mapperService();

    public abstract Field version();

    public abstract void version(Field var1);

    public abstract SeqNoFieldMapper.SequenceIDFields seqID();

    public abstract void seqID(SeqNoFieldMapper.SequenceIDFields var1);

    public final ParseContext createExternalValueContext(final Object externalValue) {
        return new FilterParseContext(this){

            @Override
            public boolean externalValueSet() {
                return true;
            }

            @Override
            public Object externalValue() {
                return externalValue;
            }
        };
    }

    public boolean externalValueSet() {
        return false;
    }

    public Object externalValue() {
        throw new IllegalStateException("External value is not set");
    }

    public final <T> T parseExternalValue(Class<T> clazz) {
        if (!this.externalValueSet() || this.externalValue() == null) {
            return null;
        }
        if (!clazz.isInstance(this.externalValue())) {
            throw new IllegalArgumentException("illegal external value class [" + this.externalValue().getClass().getName() + "]. Should be " + clazz.getName());
        }
        return clazz.cast(this.externalValue());
    }

    public abstract void addDynamicMapper(Mapper var1);

    public abstract List<Mapper> getDynamicMappers();

    public static class Document
    implements Iterable<IndexableField> {
        private final Document parent;
        private final String path;
        private final String prefix;
        private final List<IndexableField> fields = new ArrayList<IndexableField>();
        private ObjectObjectMap<Object, IndexableField> keyedFields;

        private Document(String path, Document parent) {
            this.path = path;
            this.prefix = path.isEmpty() ? "" : path + ".";
            this.parent = parent;
        }

        public Document() {
            this("", null);
        }

        public String getPath() {
            return this.path;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public Document getParent() {
            return this.parent;
        }

        @Override
        public Iterator<IndexableField> iterator() {
            return this.fields.iterator();
        }

        public List<IndexableField> getFields() {
            return this.fields;
        }

        public void addAll(List<? extends IndexableField> fields) {
            this.fields.addAll(fields);
        }

        public void add(IndexableField field) {
            assert (field.name().startsWith("_") || field.name().startsWith(this.prefix)) : field.name() + " " + this.prefix;
            this.fields.add(field);
        }

        public void addWithKey(Object key, IndexableField field) {
            if (this.keyedFields == null) {
                this.keyedFields = new ObjectObjectHashMap<Object, IndexableField>();
            } else if (this.keyedFields.containsKey(key)) {
                throw new IllegalStateException("Only one field can be stored per key");
            }
            this.keyedFields.put(key, field);
            this.add(field);
        }

        public IndexableField getByKey(Object key) {
            return this.keyedFields == null ? null : this.keyedFields.get(key);
        }

        public IndexableField[] getFields(String name) {
            ArrayList<IndexableField> f = new ArrayList<IndexableField>();
            for (IndexableField field : this.fields) {
                if (!field.name().equals(name)) continue;
                f.add(field);
            }
            return f.toArray(new IndexableField[f.size()]);
        }

        public IndexableField getField(String name) {
            for (IndexableField field : this.fields) {
                if (!field.name().equals(name)) continue;
                return field;
            }
            return null;
        }

        public String get(String name) {
            for (IndexableField f : this.fields) {
                if (!f.name().equals(name) || f.stringValue() == null) continue;
                return f.stringValue();
            }
            return null;
        }

        public BytesRef getBinaryValue(String name) {
            for (IndexableField f : this.fields) {
                if (!f.name().equals(name) || f.binaryValue() == null) continue;
                return f.binaryValue();
            }
            return null;
        }
    }

    public static class InternalParseContext
    extends ParseContext {
        private final DocumentMapper docMapper;
        private final DocumentMapperParser docMapperParser;
        private final ContentPath path;
        private final XContentParser parser;
        private Document document;
        private final List<Document> documents;
        private final IndexSettings indexSettings;
        private final SourceToParse sourceToParse;
        private Field version;
        private SeqNoFieldMapper.SequenceIDFields seqID;
        private final long maxAllowedNumNestedDocs;
        private long numNestedDocs;
        private final List<Mapper> dynamicMappers;
        private boolean docsReversed = false;
        private final Set<String> ignoredFields = new HashSet<String>();

        public InternalParseContext(IndexSettings indexSettings, DocumentMapperParser docMapperParser, DocumentMapper docMapper, SourceToParse source, XContentParser parser) {
            this.indexSettings = indexSettings;
            this.docMapper = docMapper;
            this.docMapperParser = docMapperParser;
            this.path = new ContentPath(0);
            this.parser = parser;
            this.document = new Document();
            this.documents = new ArrayList<Document>();
            this.documents.add(this.document);
            this.version = null;
            this.sourceToParse = source;
            this.dynamicMappers = new ArrayList<Mapper>();
            this.maxAllowedNumNestedDocs = indexSettings.getMappingNestedDocsLimit();
            this.numNestedDocs = 0L;
        }

        @Override
        public DocumentMapperParser docMapperParser() {
            return this.docMapperParser;
        }

        @Override
        public IndexSettings indexSettings() {
            return this.indexSettings;
        }

        @Override
        public SourceToParse sourceToParse() {
            return this.sourceToParse;
        }

        @Override
        public ContentPath path() {
            return this.path;
        }

        @Override
        public XContentParser parser() {
            return this.parser;
        }

        @Override
        public Document rootDoc() {
            return this.documents.get(0);
        }

        List<Document> docs() {
            return this.documents;
        }

        @Override
        public Document doc() {
            return this.document;
        }

        @Override
        protected void addDoc(Document doc) {
            ++this.numNestedDocs;
            if (this.numNestedDocs > this.maxAllowedNumNestedDocs) {
                throw new MapperParsingException("The number of nested documents has exceeded the allowed limit of [" + this.maxAllowedNumNestedDocs + "]. This limit can be set by changing the [" + MapperService.INDEX_MAPPING_NESTED_DOCS_LIMIT_SETTING.getKey() + "] index level setting.");
            }
            this.documents.add(doc);
        }

        @Override
        public RootObjectMapper root() {
            return this.docMapper.root();
        }

        @Override
        public DocumentMapper docMapper() {
            return this.docMapper;
        }

        @Override
        public MapperService mapperService() {
            return this.docMapperParser.mapperService;
        }

        @Override
        public Field version() {
            return this.version;
        }

        @Override
        public void version(Field version) {
            this.version = version;
        }

        @Override
        public SeqNoFieldMapper.SequenceIDFields seqID() {
            return this.seqID;
        }

        @Override
        public void seqID(SeqNoFieldMapper.SequenceIDFields seqID) {
            this.seqID = seqID;
        }

        @Override
        public void addDynamicMapper(Mapper mapper) {
            this.dynamicMappers.add(mapper);
        }

        @Override
        public List<Mapper> getDynamicMappers() {
            return this.dynamicMappers;
        }

        @Override
        public Iterable<Document> nonRootDocuments() {
            if (this.docsReversed) {
                throw new IllegalStateException("documents are already reversed");
            }
            return this.documents.subList(1, this.documents.size());
        }

        void postParse() {
            if (this.documents.size() > 1) {
                this.docsReversed = true;
                if (this.indexSettings.getIndexVersionCreated().onOrAfter(Version.V_6_5_0)) {
                    List<Document> newDocs = this.reorderParent(this.documents);
                    this.documents.clear();
                    this.documents.addAll(newDocs);
                } else {
                    Collections.reverse(this.documents);
                }
            }
        }

        private List<Document> reorderParent(List<Document> docs) {
            ArrayList<Document> newDocs = new ArrayList<Document>(docs.size());
            LinkedList<Document> parents = new LinkedList<Document>();
            for (Document doc : docs) {
                while (parents.peek() != doc.getParent()) {
                    newDocs.add((Document)parents.poll());
                }
                parents.add(0, doc);
            }
            newDocs.addAll(parents);
            return newDocs;
        }

        @Override
        public Iterator<Document> iterator() {
            return this.documents.iterator();
        }

        @Override
        public void addIgnoredField(String field) {
            this.ignoredFields.add(field);
        }

        @Override
        public Collection<String> getIgnoredFields() {
            return Collections.unmodifiableCollection(this.ignoredFields);
        }
    }

    private static class FilterParseContext
    extends ParseContext {
        private final ParseContext in;

        private FilterParseContext(ParseContext in) {
            this.in = in;
        }

        @Override
        public Iterable<Document> nonRootDocuments() {
            return this.in.nonRootDocuments();
        }

        @Override
        public DocumentMapperParser docMapperParser() {
            return this.in.docMapperParser();
        }

        @Override
        public boolean isWithinCopyTo() {
            return this.in.isWithinCopyTo();
        }

        @Override
        public boolean isWithinMultiFields() {
            return this.in.isWithinMultiFields();
        }

        @Override
        public IndexSettings indexSettings() {
            return this.in.indexSettings();
        }

        @Override
        public SourceToParse sourceToParse() {
            return this.in.sourceToParse();
        }

        @Override
        public ContentPath path() {
            return this.in.path();
        }

        @Override
        public XContentParser parser() {
            return this.in.parser();
        }

        @Override
        public Document rootDoc() {
            return this.in.rootDoc();
        }

        @Override
        public Document doc() {
            return this.in.doc();
        }

        @Override
        protected void addDoc(Document doc) {
            this.in.addDoc(doc);
        }

        @Override
        public RootObjectMapper root() {
            return this.in.root();
        }

        @Override
        public DocumentMapper docMapper() {
            return this.in.docMapper();
        }

        @Override
        public MapperService mapperService() {
            return this.in.mapperService();
        }

        @Override
        public Field version() {
            return this.in.version();
        }

        @Override
        public void version(Field version) {
            this.in.version(version);
        }

        @Override
        public SeqNoFieldMapper.SequenceIDFields seqID() {
            return this.in.seqID();
        }

        @Override
        public void seqID(SeqNoFieldMapper.SequenceIDFields seqID) {
            this.in.seqID(seqID);
        }

        @Override
        public boolean externalValueSet() {
            return this.in.externalValueSet();
        }

        @Override
        public Object externalValue() {
            return this.in.externalValue();
        }

        @Override
        public void addDynamicMapper(Mapper update) {
            this.in.addDynamicMapper(update);
        }

        @Override
        public List<Mapper> getDynamicMappers() {
            return this.in.getDynamicMappers();
        }

        @Override
        public Iterator<Document> iterator() {
            return this.in.iterator();
        }

        @Override
        public void addIgnoredField(String field) {
            this.in.addIgnoredField(field);
        }

        @Override
        public Collection<String> getIgnoredFields() {
            return this.in.getIgnoredFields();
        }
    }
}

