/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.BoostQuery;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.Query;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.ElasticsearchException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Explicit;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.collect.Tuple;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.geo.ShapeRelation;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.joda.Joda;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.lucene.Lucene;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.network.InetAddresses;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.settings.Setting;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.settings.Settings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.time.DateFormatter;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.time.DateMathParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.util.LocaleUtils;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.IndexFieldData;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.plain.BinaryIndexFieldData;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.CustomDocValuesField;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.DateFieldMapper;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.FieldMapper;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.MappedFieldType;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.Mapper;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.MapperParsingException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.MapperService;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.ParametrizedFieldMapper;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.ParseContext;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.RangeType;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.SourceValueFetcher;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.TextSearchInfo;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.ValueFetcher;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.query.QueryShardContext;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.query.RangeQueryBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.DocValueFormat;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.lookup.SearchLookup;

public class RangeFieldMapper
extends ParametrizedFieldMapper {
    public static final boolean DEFAULT_INCLUDE_UPPER = true;
    public static final boolean DEFAULT_INCLUDE_LOWER = true;
    static final Setting<Boolean> COERCE_SETTING = Setting.boolSetting("index.mapping.coerce", true, Setting.Property.IndexScope);
    private final RangeType type;
    private final boolean index;
    private final boolean hasDocValues;
    private final boolean store;
    private final Explicit<Boolean> coerce;
    private final String format;
    private final Locale locale;
    private final boolean coerceByDefault;

    private static RangeFieldMapper toType(FieldMapper in) {
        return (RangeFieldMapper)in;
    }

    private RangeFieldMapper(String simpleName, MappedFieldType mappedFieldType, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, RangeType type, Builder builder) {
        super(simpleName, mappedFieldType, multiFields, copyTo);
        this.type = type;
        this.index = (Boolean)builder.index.getValue();
        this.hasDocValues = (Boolean)builder.hasDocValues.getValue();
        this.store = (Boolean)builder.store.getValue();
        this.coerce = (Explicit)builder.coerce.getValue();
        this.format = (String)builder.format.getValue();
        this.locale = (Locale)builder.locale.getValue();
        this.coerceByDefault = (Boolean)((Explicit)builder.coerce.getDefaultValue()).value();
    }

    boolean coerce() {
        return this.coerce.value();
    }

    @Override
    public ParametrizedFieldMapper.Builder getMergeBuilder() {
        return new Builder(this.simpleName(), this.type, this.coerceByDefault).init(this);
    }

    @Override
    public RangeFieldType fieldType() {
        return (RangeFieldType)super.fieldType();
    }

    @Override
    protected String contentType() {
        return this.fieldType().typeName();
    }

    @Override
    protected RangeFieldMapper clone() {
        return (RangeFieldMapper)super.clone();
    }

    @Override
    protected void parseCreateField(ParseContext context) throws IOException {
        Range range;
        if (context.externalValueSet()) {
            range = context.parseExternalValue(Range.class);
        } else {
            XContentParser parser = context.parser();
            XContentParser.Token start = parser.currentToken();
            if (start == XContentParser.Token.VALUE_NULL) {
                return;
            }
            if (start == XContentParser.Token.START_OBJECT) {
                XContentParser.Token token;
                RangeFieldType fieldType = this.fieldType();
                RangeType rangeType = fieldType.rangeType;
                String fieldName = null;
                Object from = rangeType.minValue();
                Object to = rangeType.maxValue();
                boolean includeFrom = true;
                boolean includeTo = true;
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        fieldName = parser.currentName();
                        continue;
                    }
                    if (fieldName.equals(RangeQueryBuilder.GT_FIELD.getPreferredName())) {
                        includeFrom = false;
                        if (parser.currentToken() == XContentParser.Token.VALUE_NULL) continue;
                        from = rangeType.parseFrom(fieldType, parser, this.coerce.value(), includeFrom);
                        continue;
                    }
                    if (fieldName.equals(RangeQueryBuilder.GTE_FIELD.getPreferredName())) {
                        includeFrom = true;
                        if (parser.currentToken() == XContentParser.Token.VALUE_NULL) continue;
                        from = rangeType.parseFrom(fieldType, parser, this.coerce.value(), includeFrom);
                        continue;
                    }
                    if (fieldName.equals(RangeQueryBuilder.LT_FIELD.getPreferredName())) {
                        includeTo = false;
                        if (parser.currentToken() == XContentParser.Token.VALUE_NULL) continue;
                        to = rangeType.parseTo(fieldType, parser, this.coerce.value(), includeTo);
                        continue;
                    }
                    if (fieldName.equals(RangeQueryBuilder.LTE_FIELD.getPreferredName())) {
                        includeTo = true;
                        if (parser.currentToken() == XContentParser.Token.VALUE_NULL) continue;
                        to = rangeType.parseTo(fieldType, parser, this.coerce.value(), includeTo);
                        continue;
                    }
                    throw new MapperParsingException("error parsing field [" + this.name() + "], with unknown parameter [" + fieldName + "]");
                }
                range = new Range(rangeType, from, to, includeFrom, includeTo);
            } else if (this.fieldType().rangeType == RangeType.IP && start == XContentParser.Token.VALUE_STRING) {
                range = RangeFieldMapper.parseIpRangeFromCidr(parser);
            } else {
                throw new MapperParsingException("error parsing field [" + this.name() + "], expected an object but got " + parser.currentName());
            }
        }
        context.doc().addAll(this.fieldType().rangeType.createFields(context, this.name(), range, this.index, this.hasDocValues, this.store));
        if (!this.hasDocValues && (this.index || this.store)) {
            this.createFieldNamesField(context);
        }
    }

    private static Range parseIpRangeFromCidr(XContentParser parser) throws IOException {
        Tuple<InetAddress, Integer> cidr = InetAddresses.parseCidr(parser.text());
        byte[] lower = cidr.v1().getAddress();
        byte[] upper = (byte[])lower.clone();
        for (int i = cidr.v2().intValue(); i < 8 * lower.length; ++i) {
            int m = 1 << 7 - (i & 7);
            int n = i >> 3;
            lower[n] = (byte)(lower[n] & ~m);
            int n2 = i >> 3;
            upper[n2] = (byte)(upper[n2] | m);
        }
        try {
            return new Range(RangeType.IP, InetAddress.getByAddress(lower), InetAddress.getByAddress(upper), true, true);
        }
        catch (UnknownHostException bogus) {
            throw new AssertionError((Object)bogus);
        }
    }

    public static class Builder
    extends ParametrizedFieldMapper.Builder {
        private final ParametrizedFieldMapper.Parameter<Boolean> index = ParametrizedFieldMapper.Parameter.indexParam(m -> RangeFieldMapper.access$700(RangeFieldMapper.toType(m)), true);
        private final ParametrizedFieldMapper.Parameter<Boolean> hasDocValues = ParametrizedFieldMapper.Parameter.docValuesParam(m -> RangeFieldMapper.access$600(RangeFieldMapper.toType(m)), true);
        private final ParametrizedFieldMapper.Parameter<Boolean> store = ParametrizedFieldMapper.Parameter.storeParam(m -> RangeFieldMapper.access$500(RangeFieldMapper.toType(m)), false);
        private final ParametrizedFieldMapper.Parameter<Explicit<Boolean>> coerce;
        private final ParametrizedFieldMapper.Parameter<String> format = ParametrizedFieldMapper.Parameter.stringParam("format", false, m -> RangeFieldMapper.access$400(RangeFieldMapper.toType(m)), Defaults.DATE_FORMATTER.pattern());
        private final ParametrizedFieldMapper.Parameter<Locale> locale = new ParametrizedFieldMapper.Parameter<Locale>("locale", false, () -> Locale.ROOT, (n, c, o) -> LocaleUtils.parse(o.toString()), m -> RangeFieldMapper.access$300(RangeFieldMapper.toType(m)));
        private final ParametrizedFieldMapper.Parameter<Float> boost = ParametrizedFieldMapper.Parameter.boostParam();
        private final ParametrizedFieldMapper.Parameter<Map<String, String>> meta = ParametrizedFieldMapper.Parameter.metaParam();
        private final RangeType type;

        public Builder(String name, RangeType type, Settings settings) {
            this(name, type, COERCE_SETTING.get(settings));
        }

        public Builder(String name, RangeType type, boolean coerceByDefault) {
            super(name);
            this.type = type;
            this.coerce = ParametrizedFieldMapper.Parameter.explicitBoolParam("coerce", true, m -> RangeFieldMapper.toType(m).coerce, coerceByDefault);
            if (this.type != RangeType.DATE) {
                this.format.neverSerialize();
                this.locale.neverSerialize();
            }
        }

        public void docValues(boolean hasDocValues) {
            this.hasDocValues.setValue(hasDocValues);
        }

        Builder format(String format) {
            this.format.setValue(format);
            return this;
        }

        @Override
        protected List<ParametrizedFieldMapper.Parameter<?>> getParameters() {
            return Arrays.asList(this.index, this.hasDocValues, this.store, this.coerce, this.format, this.locale, this.boost, this.meta);
        }

        protected RangeFieldType setupFieldType(Mapper.BuilderContext context) {
            if (this.format.isConfigured()) {
                if (this.type != RangeType.DATE) {
                    throw new IllegalArgumentException("field [" + this.name() + "] of type [range] should not define a dateTimeFormatter unless it is a " + (Object)((Object)RangeType.DATE) + " type");
                }
                DateFormatter dateTimeFormatter = Joda.isJodaPattern(context.indexCreatedVersion(), this.format.getValue()) ? Joda.forPattern(this.format.getValue()).withLocale(this.locale.getValue()) : DateFormatter.forPattern(this.format.getValue()).withLocale(this.locale.getValue());
                return new RangeFieldType(this.buildFullName(context), this.index.getValue(), (boolean)this.store.getValue(), (boolean)this.hasDocValues.getValue(), dateTimeFormatter, (boolean)this.coerce.getValue().value(), this.meta.getValue());
            }
            if (this.type == RangeType.DATE) {
                return new RangeFieldType(this.buildFullName(context), this.index.getValue(), (boolean)this.store.getValue(), (boolean)this.hasDocValues.getValue(), Defaults.DATE_FORMATTER, (boolean)this.coerce.getValue().value(), this.meta.getValue());
            }
            return new RangeFieldType(this.buildFullName(context), this.type, (boolean)this.index.getValue(), (boolean)this.store.getValue(), this.hasDocValues.getValue(), (boolean)this.coerce.getValue().value(), this.meta.getValue());
        }

        @Override
        public RangeFieldMapper build(Mapper.BuilderContext context) {
            RangeFieldType ft = this.setupFieldType(context);
            ft.setBoost(this.boost.getValue().floatValue());
            return new RangeFieldMapper(this.name, ft, this.multiFieldsBuilder.build(this, context), this.copyTo.build(), this.type, this);
        }
    }

    public static final class RangeFieldType
    extends MappedFieldType {
        protected final RangeType rangeType;
        protected final DateFormatter dateTimeFormatter;
        protected final DateMathParser dateMathParser;
        protected final boolean coerce;

        public RangeFieldType(String name, RangeType type, boolean indexed, boolean stored, boolean hasDocValues, boolean coerce, Map<String, String> meta) {
            super(name, indexed, stored, hasDocValues, TextSearchInfo.SIMPLE_MATCH_ONLY, meta);
            assert (type != RangeType.DATE);
            this.rangeType = Objects.requireNonNull(type);
            this.dateTimeFormatter = null;
            this.dateMathParser = null;
            this.setIndexAnalyzer(Lucene.KEYWORD_ANALYZER);
            this.coerce = coerce;
        }

        public RangeFieldType(String name, RangeType type) {
            this(name, type, true, false, true, false, Collections.emptyMap());
        }

        public RangeFieldType(String name, boolean indexed, boolean stored, boolean hasDocValues, DateFormatter formatter, boolean coerce, Map<String, String> meta) {
            super(name, indexed, stored, hasDocValues, TextSearchInfo.SIMPLE_MATCH_ONLY, meta);
            this.rangeType = RangeType.DATE;
            this.dateTimeFormatter = Objects.requireNonNull(formatter);
            this.dateMathParser = this.dateTimeFormatter.toDateMathParser();
            this.setIndexAnalyzer(Lucene.KEYWORD_ANALYZER);
            this.coerce = coerce;
        }

        public RangeFieldType(String name, DateFormatter formatter) {
            this(name, true, false, true, formatter, false, Collections.emptyMap());
        }

        public RangeType rangeType() {
            return this.rangeType;
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName, Supplier<SearchLookup> searchLookup) {
            this.failIfNoDocValues();
            return new BinaryIndexFieldData.Builder(this.name(), CoreValuesSourceType.RANGE);
        }

        @Override
        public ValueFetcher valueFetcher(MapperService mapperService, SearchLookup searchLookup, String format) {
            DateFormatter defaultFormatter = this.dateTimeFormatter();
            final DateFormatter formatter = format != null ? DateFormatter.forPattern(format).withLocale(defaultFormatter.locale()) : defaultFormatter;
            return new SourceValueFetcher(this.name(), mapperService){

                @Override
                protected Object parseSourceValue(Object value) {
                    RangeType rangeType = this.rangeType();
                    if (!(value instanceof Map)) {
                        assert (rangeType == RangeType.IP);
                        Tuple<InetAddress, Integer> ipRange = InetAddresses.parseCidr(value.toString());
                        return InetAddresses.toCidrString(ipRange.v1(), ipRange.v2());
                    }
                    Map range = (Map)value;
                    HashMap<String, Object> parsedRange = new HashMap<String, Object>();
                    for (Map.Entry entry : range.entrySet()) {
                        Object parsedValue = rangeType.parseValue(entry.getValue(), coerce, dateMathParser);
                        Object formattedValue = rangeType.formatValue(parsedValue, formatter);
                        parsedRange.put((String)entry.getKey(), formattedValue);
                    }
                    return parsedRange;
                }
            };
        }

        @Override
        public String typeName() {
            return this.rangeType.name;
        }

        public DateFormatter dateTimeFormatter() {
            return this.dateTimeFormatter;
        }

        protected DateMathParser dateMathParser() {
            return this.dateMathParser;
        }

        @Override
        public DocValueFormat docValueFormat(String format, ZoneId timeZone) {
            if (this.rangeType == RangeType.DATE) {
                DateFormatter dateTimeFormatter = this.dateTimeFormatter;
                if (format != null) {
                    dateTimeFormatter = DateFormatter.forPattern(format).withLocale(dateTimeFormatter.locale());
                }
                if (timeZone == null) {
                    timeZone = ZoneOffset.UTC;
                }
                return new DocValueFormat.DateTime(dateTimeFormatter, timeZone, DateFieldMapper.Resolution.MILLISECONDS);
            }
            return super.docValueFormat(format, timeZone);
        }

        @Override
        public Query termQuery(Object value, QueryShardContext context) {
            Query query = this.rangeQuery(value, value, true, true, ShapeRelation.INTERSECTS, null, null, context);
            if (this.boost() != 1.0f) {
                query = new BoostQuery(query, this.boost());
            }
            return query;
        }

        @Override
        public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, ShapeRelation relation, ZoneId timeZone, DateMathParser parser, QueryShardContext context) {
            this.failIfNotIndexed();
            if (parser == null) {
                parser = this.dateMathParser();
            }
            return this.rangeType.rangeQuery(this.name(), this.hasDocValues(), lowerTerm, upperTerm, includeLower, includeUpper, relation, timeZone, parser, context);
        }
    }

    public static class Range {
        RangeType type;
        Object from;
        Object to;
        private final boolean includeFrom;
        private final boolean includeTo;

        public Range(RangeType type, Object from, Object to, boolean includeFrom, boolean includeTo) {
            this.type = type;
            this.from = from;
            this.to = to;
            this.includeFrom = includeFrom;
            this.includeTo = includeTo;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Range range = (Range)o;
            return this.includeFrom == range.includeFrom && this.includeTo == range.includeTo && this.type == range.type && this.from.equals(range.from) && this.to.equals(range.to);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type, this.from, this.to, this.includeFrom, this.includeTo});
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.includeFrom ? (char)'[' : '(');
            Object f = this.includeFrom || this.from.equals(this.type.minValue()) ? this.from : this.type.nextDown(this.from);
            Object t = this.includeTo || this.to.equals(this.type.maxValue()) ? this.to : this.type.nextUp(this.to);
            sb.append(this.type == RangeType.IP ? InetAddresses.toAddrString((InetAddress)f) : f.toString());
            sb.append(" : ");
            sb.append(this.type == RangeType.IP ? InetAddresses.toAddrString((InetAddress)t) : t.toString());
            sb.append(this.includeTo ? (char)']' : ')');
            return sb.toString();
        }

        public Object getFrom() {
            return this.from;
        }

        public Object getTo() {
            return this.to;
        }
    }

    static class BinaryRangesDocValuesField
    extends CustomDocValuesField {
        private final Set<Range> ranges;
        private final RangeType rangeType;

        BinaryRangesDocValuesField(String name, Range range, RangeType rangeType) {
            super(name);
            this.rangeType = rangeType;
            this.ranges = new HashSet<Range>();
            this.add(range);
        }

        void add(Range range) {
            this.ranges.add(range);
        }

        @Override
        public BytesRef binaryValue() {
            try {
                return this.rangeType.encodeRanges(this.ranges);
            }
            catch (IOException e) {
                throw new ElasticsearchException("failed to encode ranges", (Throwable)e, new Object[0]);
            }
        }
    }

    public static class Defaults {
        public static final Explicit<Boolean> COERCE = new Explicit<Boolean>(true, false);
        public static final DateFormatter DATE_FORMATTER = DateFieldMapper.DEFAULT_DATE_TIME_FORMATTER;
    }
}

