/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.shard;

import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.DirectoryReader;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.LeafReader;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Nullable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.lucene.index.ElasticsearchDirectoryReader;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.lucene.index.ElasticsearchLeafReader;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.shard.ShardId;

public final class ShardUtils {
    private ShardUtils() {
    }

    @Nullable
    public static ShardId extractShardId(LeafReader reader) {
        ElasticsearchLeafReader esReader = ElasticsearchLeafReader.getElasticsearchLeafReader(reader);
        if (esReader != null) {
            assert (reader.getRefCount() > 0) : "ElasticsearchLeafReader is already closed";
            return esReader.shardId();
        }
        return null;
    }

    @Nullable
    public static ShardId extractShardId(DirectoryReader reader) {
        ElasticsearchDirectoryReader esReader = ElasticsearchDirectoryReader.getElasticsearchDirectoryReader(reader);
        if (esReader != null) {
            return esReader.shardId();
        }
        throw new IllegalArgumentException("can't extract shard ID, can't unwrap ElasticsearchDirectoryReader");
    }
}

