/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search;

import java.io.IOException;
import java.util.Arrays;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.Writeable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.lucene.Lucene;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.DocValueFormat;

public class SearchSortValuesAndFormats
implements Writeable {
    private final Object[] rawSortValues;
    private final Object[] formattedSortValues;
    private final DocValueFormat[] sortValueFormats;

    public SearchSortValuesAndFormats(Object[] rawSortValues, DocValueFormat[] sortValueFormats) {
        assert (rawSortValues.length == sortValueFormats.length);
        this.rawSortValues = rawSortValues;
        this.sortValueFormats = sortValueFormats;
        this.formattedSortValues = Arrays.copyOf(rawSortValues, rawSortValues.length);
        for (int i = 0; i < rawSortValues.length; ++i) {
            Object sortValue = rawSortValues[i];
            if (sortValue instanceof BytesRef) {
                this.formattedSortValues[i] = sortValueFormats[i].format((BytesRef)sortValue);
                continue;
            }
            if (sortValue instanceof Long) {
                this.formattedSortValues[i] = sortValueFormats[i].format((Long)sortValue);
                continue;
            }
            if (sortValue instanceof Double) {
                this.formattedSortValues[i] = sortValueFormats[i].format((Double)sortValue);
                continue;
            }
            if (sortValue instanceof Float || sortValue instanceof Integer) {
                this.formattedSortValues[i] = sortValue;
                continue;
            }
            assert (sortValue == null) : "Sort values must be a BytesRef, Long, Integer, Double or Float, but got " + sortValue.getClass() + ": " + sortValue;
            this.formattedSortValues[i] = sortValue;
        }
    }

    public SearchSortValuesAndFormats(StreamInput in) throws IOException {
        this.rawSortValues = in.readArray(Lucene::readSortValue, Object[]::new);
        this.formattedSortValues = in.readArray(Lucene::readSortValue, Object[]::new);
        this.sortValueFormats = new DocValueFormat[this.formattedSortValues.length];
        for (int i = 0; i < this.sortValueFormats.length; ++i) {
            this.sortValueFormats[i] = in.readNamedWriteable(DocValueFormat.class);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeArray(Lucene::writeSortValue, this.rawSortValues);
        out.writeArray(Lucene::writeSortValue, this.formattedSortValues);
        for (int i = 0; i < this.sortValueFormats.length; ++i) {
            out.writeNamedWriteable(this.sortValueFormats[i]);
        }
    }

    public Object[] getRawSortValues() {
        return this.rawSortValues;
    }

    public Object[] getFormattedSortValues() {
        return this.formattedSortValues;
    }

    public DocValueFormat[] getSortValueFormats() {
        return this.sortValueFormats;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchSortValuesAndFormats that = (SearchSortValuesAndFormats)o;
        return Arrays.equals(this.rawSortValues, that.rawSortValues) && Arrays.equals(this.formattedSortValues, that.formattedSortValues) && Arrays.equals(this.sortValueFormats, that.sortValueFormats);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.rawSortValues);
        result = 31 * result + Arrays.hashCode(this.formattedSortValues);
        result = 31 * result + Arrays.hashCode(this.sortValueFormats);
        return result;
    }
}

