/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.bucket.terms;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.IndexReader;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.DocValueFormat;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.Aggregator;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.AggregatorFactories;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.BucketOrder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.bucket.terms.SignificantStringTerms;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.bucket.terms.StringTerms;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.bucket.terms.TermsAggregator;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.bucket.terms.heuristic.SignificanceHeuristic;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.internal.ContextIndexSearcher;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.internal.SearchContext;

abstract class AbstractStringTermsAggregator
extends TermsAggregator {
    protected final boolean showTermDocCountError;

    AbstractStringTermsAggregator(String name, AggregatorFactories factories, SearchContext context, Aggregator parent, BucketOrder order, DocValueFormat format, TermsAggregator.BucketCountThresholds bucketCountThresholds, Aggregator.SubAggCollectionMode subAggCollectMode, boolean showTermDocCountError, Map<String, Object> metadata) throws IOException {
        super(name, factories, context, parent, bucketCountThresholds, order, format, subAggCollectMode, metadata);
        this.showTermDocCountError = showTermDocCountError;
    }

    protected StringTerms buildEmptyTermsAggregation() {
        return new StringTerms(this.name, this.order, this.order, this.bucketCountThresholds.getRequiredSize(), this.bucketCountThresholds.getMinDocCount(), this.metadata(), this.format, this.bucketCountThresholds.getShardSize(), this.showTermDocCountError, 0L, Collections.emptyList(), 0L);
    }

    protected SignificantStringTerms buildEmptySignificantTermsAggregation(long subsetSize, SignificanceHeuristic significanceHeuristic) {
        ContextIndexSearcher searcher = this.context.searcher();
        IndexReader topReader = searcher.getIndexReader();
        int supersetSize = topReader.numDocs();
        return new SignificantStringTerms(this.name, this.bucketCountThresholds.getRequiredSize(), this.bucketCountThresholds.getMinDocCount(), this.metadata(), this.format, subsetSize, (long)supersetSize, significanceHeuristic, Collections.emptyList());
    }
}

