/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.support;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Nullable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.query.QueryBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.query.QueryShardContext;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.DocValueFormat;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.AggregationBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.AggregationInitializationException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.AggregatorFactories;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.AggregatorFactory;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.support.MultiValuesSourceAggregatorFactory;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.support.MultiValuesSourceFieldConfig;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.support.ValueType;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.support.ValuesSourceType;

public abstract class MultiValuesSourceAggregationBuilder<AB extends MultiValuesSourceAggregationBuilder<AB>>
extends AbstractAggregationBuilder<AB> {
    private Map<String, MultiValuesSourceFieldConfig> fields = new HashMap<String, MultiValuesSourceFieldConfig>();
    private ValueType userValueTypeHint = null;
    private String format = null;

    protected MultiValuesSourceAggregationBuilder(String name) {
        super(name);
    }

    protected MultiValuesSourceAggregationBuilder(MultiValuesSourceAggregationBuilder<AB> clone, AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
        super(clone, factoriesBuilder, metadata);
        this.fields = new HashMap<String, MultiValuesSourceFieldConfig>(clone.fields);
        this.userValueTypeHint = clone.userValueTypeHint;
        this.format = clone.format;
    }

    protected MultiValuesSourceAggregationBuilder(StreamInput in) throws IOException {
        super(in);
        this.read(in);
    }

    private void read(StreamInput in) throws IOException {
        this.fields = in.readMap(StreamInput::readString, MultiValuesSourceFieldConfig::new);
        this.userValueTypeHint = in.readOptionalWriteable(ValueType::readFromStream);
        this.format = in.readOptionalString();
    }

    @Override
    protected final void doWriteTo(StreamOutput out) throws IOException {
        out.writeMap(this.fields, StreamOutput::writeString, (o, value) -> value.writeTo(o));
        out.writeOptionalWriteable(this.userValueTypeHint);
        out.writeOptionalString(this.format);
        this.innerWriteTo(out);
    }

    protected abstract void innerWriteTo(StreamOutput var1) throws IOException;

    protected AB field(String propertyName, MultiValuesSourceFieldConfig config) {
        if (config == null) {
            throw new IllegalArgumentException("[config] must not be null: [" + this.name + "]");
        }
        this.fields.put(propertyName, config);
        return (AB)this;
    }

    public AB userValueTypeHint(ValueType valueType) {
        if (valueType == null) {
            throw new IllegalArgumentException("[userValueTypeHint] must not be null: [" + this.name + "]");
        }
        this.userValueTypeHint = valueType;
        return (AB)this;
    }

    public AB format(String format) {
        if (format == null) {
            throw new IllegalArgumentException("[format] must not be null: [" + this.name + "]");
        }
        this.format = format;
        return (AB)this;
    }

    protected abstract ValuesSourceType defaultValueSourceType();

    @Override
    protected final MultiValuesSourceAggregatorFactory doBuild(QueryShardContext queryShardContext, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder) throws IOException {
        HashMap<String, ValuesSourceConfig> configs = new HashMap<String, ValuesSourceConfig>(this.fields.size());
        HashMap<String, QueryBuilder> filters = new HashMap<String, QueryBuilder>(this.fields.size());
        this.fields.forEach((key, value) -> {
            ValuesSourceConfig config = ValuesSourceConfig.resolveUnregistered(queryShardContext, this.userValueTypeHint, value.getFieldName(), value.getScript(), value.getMissing(), value.getTimeZone(), this.format, this.defaultValueSourceType());
            configs.put((String)key, config);
            filters.put((String)key, value.getFilter());
        });
        DocValueFormat docValueFormat = MultiValuesSourceAggregationBuilder.resolveFormat(this.format, this.userValueTypeHint, this.defaultValueSourceType());
        return this.innerBuild(queryShardContext, configs, filters, docValueFormat, parent, subFactoriesBuilder);
    }

    private static DocValueFormat resolveFormat(@Nullable String format, @Nullable ValueType valueType, ValuesSourceType defaultValuesSourceType) {
        if (valueType == null) {
            return defaultValuesSourceType.getFormatter(format, null);
        }
        DocValueFormat valueFormat = valueType.defaultFormat;
        if (valueFormat instanceof DocValueFormat.Decimal && format != null) {
            valueFormat = new DocValueFormat.Decimal(format);
        }
        return valueFormat;
    }

    protected abstract MultiValuesSourceAggregatorFactory innerBuild(QueryShardContext var1, Map<String, ValuesSourceConfig> var2, Map<String, QueryBuilder> var3, DocValueFormat var4, AggregatorFactory var5, AggregatorFactories.Builder var6) throws IOException;

    @Override
    public final XContentBuilder internalXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.fields != null) {
            for (Map.Entry<String, MultiValuesSourceFieldConfig> fieldEntry : this.fields.entrySet()) {
                builder.field(fieldEntry.getKey(), fieldEntry.getValue());
            }
        }
        if (this.format != null) {
            builder.field(AggregationBuilder.CommonFields.FORMAT.getPreferredName(), this.format);
        }
        if (this.userValueTypeHint != null) {
            builder.field(AggregationBuilder.CommonFields.VALUE_TYPE.getPreferredName(), this.userValueTypeHint.getPreferredName());
        }
        this.doXContentBody(builder, params);
        builder.endObject();
        return builder;
    }

    protected abstract XContentBuilder doXContentBody(XContentBuilder var1, ToXContent.Params var2) throws IOException;

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.fields, this.format, this.userValueTypeHint);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        MultiValuesSourceAggregationBuilder other = (MultiValuesSourceAggregationBuilder)obj;
        return Objects.equals(this.fields, other.fields) && Objects.equals(this.format, other.format) && Objects.equals(this.userValueTypeHint, other.userValueTypeHint);
    }

    public static abstract class LeafOnly<AB extends MultiValuesSourceAggregationBuilder<AB>>
    extends MultiValuesSourceAggregationBuilder<AB> {
        protected LeafOnly(String name) {
            super(name);
        }

        protected LeafOnly(LeafOnly<AB> clone, AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
            super(clone, factoriesBuilder, metadata);
            if (factoriesBuilder.count() > 0) {
                throw new AggregationInitializationException("Aggregator [" + this.name + "] of type [" + this.getType() + "] cannot accept sub-aggregations");
            }
        }

        protected LeafOnly(StreamInput in) throws IOException {
            super(in);
        }

        @Override
        public AB subAggregations(AggregatorFactories.Builder subFactories) {
            throw new AggregationInitializationException("Aggregator [" + this.name + "] of type [" + this.getType() + "] cannot accept sub-aggregations");
        }
    }
}

