/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.sink.writer.router;

import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.configuration.DescribedEnum;
import org.apache.flink.configuration.description.InlineElement;
import org.apache.flink.configuration.description.LinkElement;
import org.apache.flink.configuration.description.TextElement;
import org.apache.pulsar.client.impl.Hash;
import org.apache.pulsar.client.impl.JavaStringHash;
import org.apache.pulsar.client.impl.Murmur3Hash32;

@PublicEvolving
public enum MessageKeyHash implements DescribedEnum
{
    JAVA_HASH("java-hash", (InlineElement)TextElement.text((String)"This hash would use %s to calculate the message key string's hash code.", (InlineElement[])new InlineElement[]{TextElement.code((String)"String.hashCode()")})){

        @Override
        public Hash getHash() {
            return JavaStringHash.getInstance();
        }
    }
    ,
    MURMUR3_32_HASH("murmur-3-32-hash", (InlineElement)TextElement.text((String)"This hash would calculate message key's hash code by using %s algorithm.", (InlineElement[])new InlineElement[]{LinkElement.link((String)"https://en.wikipedia.org/wiki/MurmurHash", (String)"Murmur3")})){

        @Override
        public Hash getHash() {
            return Murmur3Hash32.getInstance();
        }
    };

    private final String name;
    private final InlineElement desc;

    private MessageKeyHash(String name, InlineElement desc) {
        this.name = name;
        this.desc = desc;
    }

    @Internal
    public abstract Hash getHash();

    public String toString() {
        return this.name;
    }

    @Internal
    public InlineElement getDescription() {
        return this.desc;
    }
}

