/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.sink.writer.serializer;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.connector.pulsar.sink.config.SinkConfiguration;
import org.apache.flink.connector.pulsar.sink.writer.context.PulsarSinkContext;
import org.apache.flink.connector.pulsar.sink.writer.message.PulsarMessage;
import org.apache.flink.connector.pulsar.sink.writer.message.PulsarMessageBuilder;
import org.apache.flink.connector.pulsar.sink.writer.serializer.PulsarSerializationSchema;
import org.apache.pulsar.client.api.Schema;

@Internal
public class PulsarSerializationSchemaWrapper<IN>
implements PulsarSerializationSchema<IN> {
    private static final long serialVersionUID = 4948155843623161119L;
    private final SerializationSchema<IN> serializationSchema;

    public PulsarSerializationSchemaWrapper(SerializationSchema<IN> serializationSchema) {
        this.serializationSchema = serializationSchema;
    }

    @Override
    public void open(SerializationSchema.InitializationContext initializationContext, PulsarSinkContext sinkContext, SinkConfiguration sinkConfiguration) throws Exception {
        this.serializationSchema.open(initializationContext);
    }

    @Override
    public PulsarMessage<?> serialize(IN element, PulsarSinkContext sinkContext) {
        PulsarMessageBuilder<byte[]> builder = new PulsarMessageBuilder<byte[]>();
        byte[] value = this.serializationSchema.serialize(element);
        builder.value(Schema.BYTES, value);
        return builder.build();
    }
}

