/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.source.enumerator.assigner;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.connector.source.SplitEnumeratorContext;
import org.apache.flink.connector.pulsar.source.enumerator.PulsarSourceEnumState;
import org.apache.flink.connector.pulsar.source.enumerator.assigner.SplitAssignerBase;
import org.apache.flink.connector.pulsar.source.enumerator.cursor.StopCursor;
import org.apache.flink.connector.pulsar.source.enumerator.topic.TopicPartition;
import org.apache.flink.connector.pulsar.source.split.PulsarPartitionSplit;

@Internal
class NonSharedSplitAssigner
extends SplitAssignerBase {
    public NonSharedSplitAssigner(StopCursor stopCursor, boolean enablePartitionDiscovery, SplitEnumeratorContext<PulsarPartitionSplit> context, PulsarSourceEnumState enumState) {
        super(stopCursor, enablePartitionDiscovery, context, enumState);
    }

    @Override
    public List<TopicPartition> registerTopicPartitions(Set<TopicPartition> fetchedPartitions) {
        ArrayList<TopicPartition> newPartitions = new ArrayList<TopicPartition>();
        for (TopicPartition partition : fetchedPartitions) {
            if (this.appendedPartitions.contains(partition)) continue;
            this.appendedPartitions.add(partition);
            newPartitions.add(partition);
            int readerId = this.partitionOwner(partition);
            PulsarPartitionSplit split = new PulsarPartitionSplit(partition, this.stopCursor);
            this.addSplitToPendingList(readerId, split);
        }
        if (!this.initialized) {
            this.initialized = true;
        }
        return newPartitions;
    }

    @Override
    public void addSplitsBack(List<PulsarPartitionSplit> splits, int subtaskId) {
        for (PulsarPartitionSplit split : splits) {
            int readerId = this.partitionOwner(split.getPartition());
            this.addSplitToPendingList(readerId, split);
        }
    }
}

