/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.source.enumerator.assigner;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.connector.source.SplitEnumeratorContext;
import org.apache.flink.connector.pulsar.source.config.SourceConfiguration;
import org.apache.flink.connector.pulsar.source.enumerator.PulsarSourceEnumState;
import org.apache.flink.connector.pulsar.source.enumerator.assigner.KeySharedSplitAssigner;
import org.apache.flink.connector.pulsar.source.enumerator.assigner.NonSharedSplitAssigner;
import org.apache.flink.connector.pulsar.source.enumerator.assigner.SharedSplitAssigner;
import org.apache.flink.connector.pulsar.source.enumerator.assigner.SplitAssigner;
import org.apache.flink.connector.pulsar.source.enumerator.cursor.StopCursor;
import org.apache.flink.connector.pulsar.source.split.PulsarPartitionSplit;
import org.apache.pulsar.client.api.SubscriptionType;

@Internal
public final class SplitAssignerFactory {
    private SplitAssignerFactory() {
    }

    public static SplitAssigner createAssigner(StopCursor stopCursor, SourceConfiguration sourceConfiguration, SplitEnumeratorContext<PulsarPartitionSplit> context, PulsarSourceEnumState enumState) {
        SubscriptionType subscriptionType = sourceConfiguration.getSubscriptionType();
        boolean enablePartitionDiscovery = sourceConfiguration.isEnablePartitionDiscovery();
        switch (subscriptionType) {
            case Failover: 
            case Exclusive: {
                return new NonSharedSplitAssigner(stopCursor, enablePartitionDiscovery, context, enumState);
            }
            case Shared: {
                return new SharedSplitAssigner(stopCursor, enablePartitionDiscovery, context, enumState);
            }
            case Key_Shared: {
                return new KeySharedSplitAssigner(stopCursor, enablePartitionDiscovery, context, enumState);
            }
        }
        throw new IllegalArgumentException("We don't support this subscription type: " + (Object)((Object)subscriptionType));
    }
}

