/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.source.enumerator.subscriber.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.flink.connector.pulsar.source.enumerator.subscriber.impl.BasePulsarSubscriber;
import org.apache.flink.connector.pulsar.source.enumerator.topic.TopicMetadata;
import org.apache.flink.connector.pulsar.source.enumerator.topic.TopicNameUtils;
import org.apache.flink.connector.pulsar.source.enumerator.topic.TopicPartition;
import org.apache.flink.connector.pulsar.source.enumerator.topic.TopicRange;
import org.apache.flink.connector.pulsar.source.enumerator.topic.range.RangeGenerator;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.common.naming.TopicName;

public class TopicListSubscriber
extends BasePulsarSubscriber {
    private static final long serialVersionUID = 6473918213832993116L;
    private final List<String> partitions = new ArrayList<String>();
    private final List<String> fullTopicNames = new ArrayList<String>();

    public TopicListSubscriber(List<String> fullTopicNameOrPartitions) {
        for (String fullTopicNameOrPartition : fullTopicNameOrPartitions) {
            if (TopicNameUtils.isPartition(fullTopicNameOrPartition)) {
                this.partitions.add(fullTopicNameOrPartition);
                continue;
            }
            this.fullTopicNames.add(fullTopicNameOrPartition);
        }
    }

    @Override
    public Set<TopicPartition> getSubscribedTopicPartitions(PulsarAdmin pulsarAdmin, RangeGenerator rangeGenerator, int parallelism) {
        HashSet<TopicPartition> results = new HashSet<TopicPartition>();
        for (String topic : this.fullTopicNames) {
            TopicMetadata metadata = this.queryTopicMetadata(pulsarAdmin, topic);
            List<TopicRange> ranges = rangeGenerator.range(metadata, parallelism);
            RangeGenerator.KeySharedMode mode = rangeGenerator.keyShareMode(metadata, parallelism);
            results.addAll(this.toTopicPartitions(metadata, ranges, mode));
        }
        for (String partition : this.partitions) {
            TopicName topicName = TopicName.get(partition);
            String name = topicName.getPartitionedTopicName();
            int index = topicName.getPartitionIndex();
            TopicMetadata metadata = this.queryTopicMetadata(pulsarAdmin, name);
            List<TopicRange> ranges = rangeGenerator.range(metadata, parallelism);
            RangeGenerator.KeySharedMode mode = rangeGenerator.keyShareMode(metadata, parallelism);
            results.addAll(this.toTopicPartitions(name, index, ranges, mode));
        }
        return results;
    }
}

