/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.source.enumerator.topic;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.connector.pulsar.source.enumerator.topic.TopicNameUtils;
import org.apache.flink.connector.pulsar.source.enumerator.topic.TopicRange;
import org.apache.flink.connector.pulsar.source.enumerator.topic.range.RangeGenerator;
import org.apache.flink.shaded.guava30.com.google.common.collect.ImmutableList;
import org.apache.flink.util.Preconditions;
import org.apache.pulsar.client.api.Range;

@PublicEvolving
public class TopicPartition
implements Serializable {
    private static final long serialVersionUID = -1474354741550810953L;
    private static final List<TopicRange> FULL_RANGES = ImmutableList.of((Object)TopicRange.createFullRange());
    private final String topic;
    private final int partitionId;
    private final List<TopicRange> ranges;
    private final RangeGenerator.KeySharedMode mode;

    public TopicPartition(String topic, int partitionId) {
        this(topic, partitionId, FULL_RANGES, RangeGenerator.KeySharedMode.SPLIT);
    }

    public TopicPartition(String topic, int partitionId, List<TopicRange> ranges) {
        this(topic, partitionId, ranges, RangeGenerator.KeySharedMode.SPLIT);
    }

    public TopicPartition(String topic, int partitionId, List<TopicRange> ranges, RangeGenerator.KeySharedMode mode) {
        this.topic = TopicNameUtils.topicName((String)Preconditions.checkNotNull((Object)topic));
        this.partitionId = partitionId;
        this.ranges = (List)Preconditions.checkNotNull(ranges);
        this.mode = mode;
    }

    public String getTopic() {
        return this.topic;
    }

    public int getPartitionId() {
        return this.partitionId;
    }

    public String getFullTopicName() {
        if (this.partitionId >= 0) {
            return TopicNameUtils.topicNameWithPartition(this.topic, this.partitionId);
        }
        return this.topic;
    }

    @Internal
    public List<TopicRange> getRanges() {
        return this.ranges;
    }

    @Internal
    public List<Range> getPulsarRanges() {
        return this.ranges.stream().map(TopicRange::toPulsarRange).collect(Collectors.toList());
    }

    @Internal
    public RangeGenerator.KeySharedMode getMode() {
        return this.mode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TopicPartition partition = (TopicPartition)o;
        return this.partitionId == partition.partitionId && this.topic.equals(partition.topic) && this.ranges.equals(partition.ranges) && this.mode == partition.mode;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.topic, this.partitionId, this.ranges, this.mode});
    }

    public String toString() {
        return this.getFullTopicName() + "|" + this.ranges;
    }
}

