/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.source.enumerator.topic.range;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.connector.pulsar.source.enumerator.topic.TopicMetadata;
import org.apache.flink.connector.pulsar.source.enumerator.topic.TopicRange;
import org.apache.flink.connector.pulsar.source.enumerator.topic.range.RangeGenerator;
import org.apache.flink.connector.pulsar.source.enumerator.topic.range.TopicRangeUtils;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public class FixedKeysRangeGenerator
implements RangeGenerator {
    private static final long serialVersionUID = 2372969466289052100L;
    private final List<TopicRange> ranges;
    private final RangeGenerator.KeySharedMode sharedMode;

    private FixedKeysRangeGenerator(List<TopicRange> ranges, RangeGenerator.KeySharedMode sharedMode) {
        this.ranges = ranges;
        this.sharedMode = sharedMode;
    }

    @Override
    public List<TopicRange> range(TopicMetadata metadata, int parallelism) {
        return this.ranges;
    }

    @Override
    public RangeGenerator.KeySharedMode keyShareMode(TopicMetadata metadata, int parallelism) {
        return this.sharedMode;
    }

    public static FixedKeysRangeGeneratorBuilder builder() {
        return new FixedKeysRangeGeneratorBuilder();
    }

    @PublicEvolving
    public static class FixedKeysRangeGeneratorBuilder {
        private final SortedSet<Integer> keyHashes = new TreeSet<Integer>();
        private RangeGenerator.KeySharedMode sharedMode = RangeGenerator.KeySharedMode.JOIN;

        private FixedKeysRangeGeneratorBuilder() {
        }

        public FixedKeysRangeGeneratorBuilder supportNullKey() {
            this.keyHashes.add(TopicRangeUtils.keyHash("NONE_KEY"));
            return this;
        }

        public FixedKeysRangeGeneratorBuilder key(String key) {
            this.keyHashes.add(TopicRangeUtils.keyHash(key));
            return this;
        }

        public FixedKeysRangeGeneratorBuilder keys(Collection<String> someKeys) {
            Preconditions.checkNotNull(someKeys);
            for (String someKey : someKeys) {
                this.keyHashes.add(TopicRangeUtils.keyHash(someKey));
            }
            return this;
        }

        public FixedKeysRangeGeneratorBuilder keyBytes(byte[] keyBytes) {
            this.keyHashes.add(TopicRangeUtils.keyBytesHash(keyBytes));
            return this;
        }

        public FixedKeysRangeGeneratorBuilder orderingKey(byte[] keyBytes) {
            this.keyHashes.add(TopicRangeUtils.keyHash(keyBytes));
            return this;
        }

        public FixedKeysRangeGeneratorBuilder keySharedMode(RangeGenerator.KeySharedMode sharedMode) {
            this.sharedMode = sharedMode;
            return this;
        }

        public FixedKeysRangeGenerator build() {
            ArrayList<TopicRange> ranges = new ArrayList<TopicRange>();
            Integer start = null;
            Integer next = null;
            for (Integer hash : this.keyHashes) {
                if (start == null) {
                    start = hash;
                    next = hash;
                    continue;
                }
                if (hash - next == 1) {
                    next = hash;
                    continue;
                }
                TopicRange range = new TopicRange(start, next);
                ranges.add(range);
                start = hash;
                next = hash;
            }
            if (start != null) {
                TopicRange range = new TopicRange(start, next);
                ranges.add(range);
            }
            TopicRangeUtils.validateTopicRanges(ranges, this.sharedMode);
            return new FixedKeysRangeGenerator(ranges, this.sharedMode);
        }
    }
}

