/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.source.enumerator.topic.range;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.connector.pulsar.source.enumerator.topic.TopicRange;
import org.apache.flink.connector.pulsar.source.enumerator.topic.range.RangeGenerator;
import org.apache.flink.util.Preconditions;
import org.apache.pulsar.client.api.KeySharedPolicy;
import org.apache.pulsar.client.api.Range;
import org.apache.pulsar.common.util.Murmur3_32Hash;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PublicEvolving
public final class TopicRangeUtils {
    private static final Logger LOG = LoggerFactory.getLogger(TopicRangeUtils.class);
    public static final String NONE_KEY = "NONE_KEY";

    private TopicRangeUtils() {
    }

    public static void validateTopicRanges(List<TopicRange> ranges, RangeGenerator.KeySharedMode sharedMode) {
        List<Range> pulsarRanges = ranges.stream().map(TopicRange::toPulsarRange).collect(Collectors.toList());
        KeySharedPolicy.stickyHashRange().ranges(pulsarRanges).validate();
        if (!TopicRangeUtils.isFullTopicRanges(ranges) && RangeGenerator.KeySharedMode.SPLIT == sharedMode) {
            LOG.warn("You have provided a partial key hash range with KeySharedMode.SPLIT. You can't consume any message if there are any messages with keys that are out of the given ranges.");
        }
    }

    public static boolean isFullTopicRanges(List<TopicRange> ranges) {
        List sorted = ranges.stream().sorted(Comparator.comparingLong(TopicRange::getStart)).collect(Collectors.toList());
        int start = 0;
        for (TopicRange range : sorted) {
            if (start == 0) {
                if (range.getStart() == 0) {
                    start = range.getEnd();
                    continue;
                }
                return false;
            }
            if (range.getStart() - start != 1) {
                return false;
            }
            start = range.getEnd();
        }
        return start == 65535;
    }

    public static int keyHash(String key) {
        Preconditions.checkNotNull((Object)key);
        return TopicRangeUtils.keyHash(key.getBytes(StandardCharsets.UTF_8));
    }

    public static int keyBytesHash(byte[] keyBytes) {
        String encodedKey = Base64.getEncoder().encodeToString((byte[])Preconditions.checkNotNull((Object)keyBytes));
        byte[] encodedKeyBytes = encodedKey.getBytes(StandardCharsets.UTF_8);
        return TopicRangeUtils.keyHash(encodedKeyBytes);
    }

    public static int keyHash(byte[] keyBytes) {
        int stickyKeyHash = Murmur3_32Hash.getInstance().makeHash((byte[])Preconditions.checkNotNull((Object)keyBytes));
        return stickyKeyHash % 65536;
    }
}

