/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.gateway;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.gateway.api.SqlGatewayService;
import org.apache.flink.table.gateway.service.utils.SqlGatewayServiceExtension;
import org.apache.flink.table.gateway.utils.SqlScriptReader;
import org.apache.flink.table.gateway.utils.TestSqlStatement;
import org.apache.flink.table.planner.utils.TableTestUtil;
import org.apache.flink.table.utils.print.PrintStyle;
import org.apache.flink.table.utils.print.RowDataToStringConverter;
import org.apache.flink.table.utils.print.TableauStyle;
import org.apache.flink.test.junit5.MiniClusterExtension;
import org.apache.flink.test.util.AbstractTestBase;
import org.apache.flink.util.Preconditions;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Order;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.junit.jupiter.api.io.TempDir;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSqlGatewayStatementITCase
extends AbstractTestBase {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractSqlGatewayStatementITCase.class);
    @RegisterExtension
    @Order(value=1)
    public static final MiniClusterExtension MINI_CLUSTER = new MiniClusterExtension();
    @RegisterExtension
    @Order(value=2)
    public static final SqlGatewayServiceExtension SQL_GATEWAY_SERVICE_EXTENSION = new SqlGatewayServiceExtension(() -> ((MiniClusterExtension)MINI_CLUSTER).getClientConfiguration());
    private static final String RESOURCE_DIR = "sql/";
    private static final Pattern PATTERN = Pattern.compile(".*\\.q$");
    protected static SqlGatewayService service;
    private final Map<String, String> replaceVars = new HashMap<String, String>();

    @BeforeAll
    public static void setUp() {
        service = SQL_GATEWAY_SERVICE_EXTENSION.getService();
    }

    @BeforeEach
    public void before(@TempDir Path temporaryFolder) throws Exception {
        this.replaceVars.put("$VAR_STREAMING_PATH", Files.createDirectory(temporaryFolder.resolve("streaming"), new FileAttribute[0]).toFile().getPath());
        this.replaceVars.put("$VAR_BATCH_PATH", Files.createDirectory(temporaryFolder.resolve("batch"), new FileAttribute[0]).toFile().getPath());
        this.replaceVars.put("$VAR_BATCH_CTAS_PATH", Files.createDirectory(temporaryFolder.resolve("batch_ctas"), new FileAttribute[0]).toFile().getPath());
    }

    @ParameterizedTest
    @MethodSource(value={"listFlinkSqlTests"})
    public void testFlinkSqlStatements(String sqlPath) throws Exception {
        this.resetSessionForFlinkSqlStatements();
        this.runTest(sqlPath);
    }

    protected List<String> runStatements(List<TestSqlStatement> statements) {
        ArrayList<String> output = new ArrayList<String>();
        for (TestSqlStatement statement : statements) {
            StringBuilder builder = new StringBuilder();
            builder.append(statement.getComment());
            builder.append(statement.getSql());
            String trimmedSql = statement.getSql().trim();
            if (trimmedSql.endsWith(";")) {
                trimmedSql = trimmedSql.substring(0, trimmedSql.length() - 1);
            }
            try {
                builder.append(this.runSingleStatement(trimmedSql));
            }
            catch (Throwable t) {
                LOG.error("Failed to execute statements.", t);
                builder.append(Tag.ERROR.addTag(this.stringifyException(t).trim() + "\n"));
            }
            output.add(builder.toString());
        }
        return output;
    }

    protected String getInputFromPath(String sqlPath) throws IOException {
        String[] keys = this.replaceVars.keySet().toArray(new String[0]);
        String[] values = (String[])Arrays.stream(keys).map(this.replaceVars::get).toArray(String[]::new);
        return StringUtils.replaceEach((String)IOUtils.toString((InputStream)((InputStream)Preconditions.checkNotNull((Object)AbstractSqlGatewayStatementITCase.class.getResourceAsStream("/" + sqlPath))), (Charset)StandardCharsets.UTF_8), (String[])keys, (String[])values);
    }

    private static Stream<String> listFlinkSqlTests() throws Exception {
        File jarFile = new File(AbstractSqlGatewayStatementITCase.class.getProtectionDomain().getCodeSource().getLocation().getPath());
        if (jarFile.isFile()) {
            ArrayList<String> files = new ArrayList<String>();
            try (JarFile jar = new JarFile(jarFile);){
                Enumeration<JarEntry> entries = jar.entries();
                while (entries.hasMoreElements()) {
                    String name = entries.nextElement().getName();
                    if (!name.startsWith(RESOURCE_DIR) || !PATTERN.matcher(name).matches()) continue;
                    files.add(name);
                }
            }
            return files.stream();
        }
        return AbstractSqlGatewayStatementITCase.listTestSpecInTheSameModule(RESOURCE_DIR);
    }

    protected static Stream<String> listTestSpecInTheSameModule(String resourceDir) throws Exception {
        return IOUtils.readLines((InputStream)((InputStream)Preconditions.checkNotNull((Object)AbstractSqlGatewayStatementITCase.class.getClassLoader().getResourceAsStream(resourceDir))), (Charset)StandardCharsets.UTF_8).stream().map(name -> Paths.get(resourceDir, name).toString());
    }

    protected void runTest(String sqlPath) throws Exception {
        String in = this.getInputFromPath(sqlPath);
        List<TestSqlStatement> testSqlStatements = SqlScriptReader.parseSqlScript(in);
        Assertions.assertThat((String)String.join((CharSequence)"", this.runStatements(testSqlStatements))).isEqualTo(in);
    }

    protected void resetSessionForFlinkSqlStatements() throws Exception {
    }

    protected abstract String runSingleStatement(String var1) throws Exception;

    protected abstract String stringifyException(Throwable var1);

    protected abstract boolean isStreaming() throws Exception;

    protected String toString(StatementType type, ResolvedSchema schema, RowDataToStringConverter converter, Iterator<RowData> iterator) throws Exception {
        if (type.equals((Object)StatementType.EXPLAIN) || type.equals((Object)StatementType.SHOW_CREATE)) {
            return Tag.OK.addTag(TableTestUtil.replaceStreamNodeId((String)TableTestUtil.replaceNodeIdInOperator((String)iterator.next().getString(0).toString())) + "\n");
        }
        ByteArrayOutputStream outContent = new ByteArrayOutputStream();
        TableauStyle style = PrintStyle.tableauWithDataInferredColumnWidths((ResolvedSchema)schema, (RowDataToStringConverter)converter, (int)Integer.MAX_VALUE, (boolean)true, (type.equals((Object)StatementType.QUERY) && this.isStreaming() ? 1 : 0) != 0);
        PrintWriter writer = new PrintWriter(outContent);
        style.print(iterator, writer);
        return Tag.OK.addTag(outContent.toString());
    }

    public static enum StatementType {
        SHOW_CREATE("SHOW CREATE"),
        EXPLAIN("EXPLAIN"),
        QUERY("SELECT"),
        OTHERS;

        private final String beginWith;

        private StatementType(String beginWith) {
            this.beginWith = beginWith;
        }

        private StatementType() {
            this("");
        }

        public static StatementType match(String sql) {
            String processed = sql.trim().toUpperCase();
            if (processed.startsWith(StatementType.SHOW_CREATE.beginWith)) {
                return SHOW_CREATE;
            }
            if (processed.startsWith(StatementType.EXPLAIN.beginWith)) {
                return EXPLAIN;
            }
            if (processed.startsWith(StatementType.QUERY.beginWith)) {
                return QUERY;
            }
            return OTHERS;
        }
    }

    public static enum Tag {
        INFO("!info"),
        OK("!ok"),
        ERROR("!error");

        private final String tag;

        private Tag(String tag) {
            this.tag = tag;
        }

        public String addTag(String content) {
            return "!output\n" + content + this.tag + "\n";
        }
    }
}

