/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.gateway.rest.compatibility;

import java.io.IOException;
import java.util.Arrays;
import java.util.stream.Stream;
import org.apache.flink.runtime.rest.compatibility.RestAPIStabilityTestUtils;
import org.apache.flink.runtime.rest.util.DocumentingRestEndpoint;
import org.apache.flink.runtime.rest.versioning.RestAPIVersion;
import org.apache.flink.table.gateway.rest.util.DocumentingSqlGatewayRestEndpoint;
import org.apache.flink.table.gateway.rest.util.SqlGatewayRestAPIVersion;
import org.apache.flink.util.ConfigurationException;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.provider.ArgumentsSource;

final class SqlGatewayRestAPIStabilityTest {
    private static final String REGENERATE_SNAPSHOT_PROPERTY = "generate-sql-gateway-rest-snapshot";
    private static final String SNAPSHOT_RESOURCE_PATTERN = "sql_gateway_rest_api_%s.snapshot";

    SqlGatewayRestAPIStabilityTest() {
    }

    @ParameterizedTest
    @ArgumentsSource(value=StableSqlGatewayRestApiVersionProvider.class)
    void testSqlGatewayRestAPIStability(SqlGatewayRestAPIVersion apiVersion) throws IOException, ConfigurationException {
        RestAPIStabilityTestUtils.testStability((String)SNAPSHOT_RESOURCE_PATTERN, (String)REGENERATE_SNAPSHOT_PROPERTY, (RestAPIVersion)apiVersion, (DocumentingRestEndpoint)new DocumentingSqlGatewayRestEndpoint());
    }

    private static class StableSqlGatewayRestApiVersionProvider
    implements ArgumentsProvider {
        private StableSqlGatewayRestApiVersionProvider() {
        }

        public Stream<? extends Arguments> provideArguments(ExtensionContext context) {
            return Arrays.stream(SqlGatewayRestAPIVersion.values()).filter(SqlGatewayRestAPIVersion::isStableVersion).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
        }
    }
}

