/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.gateway.rest.util;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.function.Supplier;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.gateway.api.SqlGatewayService;
import org.apache.flink.table.gateway.api.utils.SqlGatewayException;
import org.apache.flink.table.gateway.rest.SqlGatewayRestEndpoint;
import org.apache.flink.table.gateway.rest.util.RestConfigUtils;
import org.apache.flink.util.Preconditions;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class SqlGatewayRestEndpointExtension
implements BeforeAllCallback,
AfterAllCallback {
    private final Supplier<SqlGatewayService> serviceSupplier;
    private SqlGatewayRestEndpoint sqlGatewayRestEndpoint;
    private String targetAddress;
    private int targetPort;

    public String getTargetAddress() {
        return this.targetAddress;
    }

    public int getTargetPort() {
        return this.targetPort;
    }

    public SqlGatewayRestEndpointExtension(Supplier<SqlGatewayService> serviceSupplier) {
        this.serviceSupplier = serviceSupplier;
    }

    public void beforeAll(ExtensionContext context) {
        String address = InetAddress.getLoopbackAddress().getHostAddress();
        Configuration config = RestConfigUtils.getBaseConfig(RestConfigUtils.getFlinkConfig(address, address, "0"));
        try {
            this.sqlGatewayRestEndpoint = new SqlGatewayRestEndpoint(config, this.serviceSupplier.get());
            this.sqlGatewayRestEndpoint.start();
        }
        catch (Exception e) {
            throw new SqlGatewayException("Unexpected error occurred when trying to start the rest endpoint of sql gateway.", (Throwable)e);
        }
        InetSocketAddress serverAddress = (InetSocketAddress)Preconditions.checkNotNull((Object)this.sqlGatewayRestEndpoint.getServerAddress());
        this.targetAddress = serverAddress.getHostName();
        this.targetPort = serverAddress.getPort();
    }

    public void afterAll(ExtensionContext context) {
        try {
            this.sqlGatewayRestEndpoint.stop();
        }
        catch (Exception e) {
            throw new SqlGatewayException("Unexpected error occurred when trying to stop the rest endpoint of sql gateway.", (Throwable)e);
        }
    }
}

