/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.gateway.service;

import java.nio.file.Path;
import java.time.Duration;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.apache.flink.api.common.RuntimeExecutionMode;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ExecutionOptions;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.gateway.AbstractSqlGatewayStatementITCase;
import org.apache.flink.table.gateway.api.endpoint.EndpointVersion;
import org.apache.flink.table.gateway.api.operation.OperationHandle;
import org.apache.flink.table.gateway.api.results.ResultSet;
import org.apache.flink.table.gateway.api.session.SessionEnvironment;
import org.apache.flink.table.gateway.api.session.SessionHandle;
import org.apache.flink.table.gateway.api.utils.MockedEndpointVersion;
import org.apache.flink.table.planner.functions.casting.RowDataToStringConverterImpl;
import org.apache.flink.table.utils.DateTimeUtils;
import org.apache.flink.table.utils.print.RowDataToStringConverter;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.io.TempDir;

public class SqlGatewayServiceStatementITCase
extends AbstractSqlGatewayStatementITCase {
    private final SessionEnvironment defaultSessionEnvironment = SessionEnvironment.newBuilder().setSessionEndpointVersion((EndpointVersion)MockedEndpointVersion.V1).build();
    private SessionHandle sessionHandle;

    @Override
    @BeforeEach
    public void before(@TempDir Path temporaryFolder) throws Exception {
        super.before(temporaryFolder);
        this.sessionHandle = service.openSession(this.defaultSessionEnvironment);
    }

    @Override
    protected String runSingleStatement(String statement) throws Exception {
        OperationHandle operationHandle = service.executeStatement(this.sessionHandle, statement, -1L, new Configuration());
        CommonTestUtils.waitUtil(() -> service.getOperationInfo(this.sessionHandle, operationHandle).getStatus().isTerminalStatus(), (Duration)Duration.ofSeconds(100L), (String)"Failed to wait operation finish.");
        ResultSet resultSet = service.fetchResults(this.sessionHandle, operationHandle, 0L, Integer.MAX_VALUE);
        return this.toString(AbstractSqlGatewayStatementITCase.StatementType.match(statement), resultSet.getResultSchema(), (RowDataToStringConverter)new RowDataToStringConverterImpl(resultSet.getResultSchema().toPhysicalRowDataType(), DateTimeUtils.UTC_ZONE.toZoneId(), SqlGatewayServiceStatementITCase.class.getClassLoader(), false), new RowDataIterator(this.sessionHandle, operationHandle));
    }

    @Override
    protected String stringifyException(Throwable t) {
        Throwable root = t;
        while (root.getCause() != null && root.getCause().getMessage() != null && !root.getCause().getMessage().isEmpty()) {
            root = root.getCause();
        }
        return root.getClass().getName() + ": " + root.getMessage();
    }

    @Override
    protected boolean isStreaming() {
        return ((RuntimeExecutionMode)Configuration.fromMap((Map)service.getSessionConfig(this.sessionHandle)).get(ExecutionOptions.RUNTIME_MODE)).equals((Object)RuntimeExecutionMode.STREAMING);
    }

    private static class RowDataIterator
    implements Iterator<RowData> {
        private final SessionHandle sessionHandle;
        private final OperationHandle operationHandle;
        private Long token = 0L;
        private Iterator<RowData> fetchedRows = Collections.emptyIterator();

        public RowDataIterator(SessionHandle sessionHandle, OperationHandle operationHandle) {
            this.sessionHandle = sessionHandle;
            this.operationHandle = operationHandle;
            this.fetch();
        }

        @Override
        public boolean hasNext() {
            while (this.token != null && !this.fetchedRows.hasNext()) {
                this.fetch();
            }
            return this.token != null;
        }

        @Override
        public RowData next() {
            return this.fetchedRows.next();
        }

        private void fetch() {
            ResultSet resultSet = service.fetchResults(this.sessionHandle, this.operationHandle, this.token.longValue(), Integer.MAX_VALUE);
            this.token = resultSet.getNextToken();
            this.fetchedRows = resultSet.getData().iterator();
        }
    }
}

