/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.gateway.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.flink.table.gateway.utils.TestSqlStatement;

public final class SqlScriptReader
implements AutoCloseable {
    public static final String HINT_START_OF_OUTPUT = "!output";
    private final BufferedReader reader;
    private String currentLine;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<TestSqlStatement> parseSqlScript(String in) {
        try (SqlScriptReader sqlReader = new SqlScriptReader(in);){
            List<TestSqlStatement> list = sqlReader.parseSqlScript();
            return list;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private SqlScriptReader(String input) {
        this.reader = new BufferedReader(new StringReader(input));
    }

    private List<TestSqlStatement> parseSqlScript() throws IOException {
        TestSqlStatement spec;
        ArrayList<TestSqlStatement> specs = new ArrayList<TestSqlStatement>();
        while ((spec = this.readNext()) != null) {
            specs.add(spec);
        }
        return specs;
    }

    private void readLine() throws IOException {
        this.currentLine = this.reader.readLine();
    }

    @Nullable
    private TestSqlStatement readNext() throws IOException {
        StringBuilder commentLines = new StringBuilder();
        StringBuilder sqlLines = new StringBuilder();
        ReadingStatus status = ReadingStatus.BEGINNING;
        this.readLine();
        while (this.currentLine != null) {
            switch (status) {
                case BEGINNING: {
                    if (this.currentLine.startsWith("#") || this.currentLine.trim().length() == 0) {
                        commentLines.append(this.currentLine).append("\n");
                        this.readLine();
                        break;
                    }
                    status = ReadingStatus.SQL_STATEMENT;
                    break;
                }
                case SQL_STATEMENT: {
                    if (this.currentLine.trim().equals(HINT_START_OF_OUTPUT)) {
                        status = ReadingStatus.RESULT_CONTENT;
                    } else {
                        sqlLines.append(this.currentLine).append("\n");
                    }
                    this.readLine();
                    break;
                }
                case RESULT_CONTENT: {
                    if (!this.currentLine.startsWith("!")) {
                        this.readLine();
                        break;
                    }
                    status = ReadingStatus.FINISH;
                    break;
                }
                case FINISH: {
                    return new TestSqlStatement(commentLines.toString(), sqlLines.toString());
                }
            }
        }
        return null;
    }

    @Override
    public void close() throws Exception {
        this.reader.close();
    }

    private static enum ReadingStatus {
        BEGINNING,
        SQL_STATEMENT,
        RESULT_CONTENT,
        FINISH;

    }
}

