/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.gateway.rest.serde;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.formats.common.TimestampFormat;
import org.apache.flink.formats.json.JsonToRowDataConverters;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonParser;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.TreeNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.DeserializationContext;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.binary.BinaryStringData;
import org.apache.flink.table.gateway.api.results.ResultSet;
import org.apache.flink.table.gateway.rest.serde.ColumnInfo;
import org.apache.flink.table.gateway.rest.serde.RowDataInfo;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.utils.DataTypeUtils;
import org.apache.flink.types.RowKind;

@Internal
public class JsonResultSetDeserializer
extends StdDeserializer<ResultSet> {
    private static final long serialVersionUID = 1L;
    private static final JsonToRowDataConverters TO_ROWDATA_CONVERTERS = new JsonToRowDataConverters(false, false, TimestampFormat.ISO_8601);

    public JsonResultSetDeserializer() {
        super(ResultSet.class);
    }

    public ResultSet deserialize(JsonParser jsonParser, DeserializationContext ctx) throws IOException {
        RowDataInfo[] rowDataInfos;
        JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        ArrayList<RowData> data = new ArrayList<RowData>();
        ColumnInfo[] columnInfos = (ColumnInfo[])jsonParser.getCodec().treeToValue((TreeNode)node.get("columns"), ColumnInfo[].class);
        ArrayList<Column.PhysicalColumn> columns = new ArrayList<Column.PhysicalColumn>();
        for (ColumnInfo columnInfo : columnInfos) {
            RowDataInfo[] logicalType = columnInfo.getLogicalType();
            columns.add(Column.physical((String)columnInfo.getName(), (DataType)DataTypeUtils.toInternalDataType((LogicalType)logicalType)));
        }
        ResolvedSchema resolvedSchema = ResolvedSchema.of(columns);
        List fieldTypes = resolvedSchema.getColumnDataTypes().stream().map(DataType::getLogicalType).collect(Collectors.toList());
        List converters = fieldTypes.stream().map(arg_0 -> ((JsonToRowDataConverters)TO_ROWDATA_CONVERTERS).createConverter(arg_0)).collect(Collectors.toList());
        JsonParser dataParser = node.get("data").traverse();
        dataParser.nextToken();
        for (RowDataInfo rowDataInfo : rowDataInfos = (RowDataInfo[])ctx.readValue(dataParser, RowDataInfo[].class)) {
            RowKind rowKind = RowKind.valueOf((String)rowDataInfo.getKind());
            GenericRowData rowData = new GenericRowData(rowKind, rowDataInfo.getFields().size());
            List<JsonNode> fields = rowDataInfo.getFields();
            for (int i = 0; i < rowData.getArity(); ++i) {
                JsonNode jsonNode = fields.get(i);
                JsonToRowDataConverters.JsonToRowDataConverter converter = (JsonToRowDataConverters.JsonToRowDataConverter)converters.get(i);
                Object object = JsonResultSetDeserializer.buildObjectValueConverter(converter).apply(jsonNode);
                if (object != null && object.toString().equals("null")) {
                    rowData.setField(i, (Object)new BinaryStringData(""));
                    continue;
                }
                rowData.setField(i, object);
            }
            data.add((RowData)rowData);
        }
        ResultSet.ResultType resultTypePlaceHolder = ResultSet.ResultType.PAYLOAD;
        Long nextTokenPlaceHolder = 0L;
        return new ResultSet(resultTypePlaceHolder, nextTokenPlaceHolder, resolvedSchema, data);
    }

    private static Function<JsonNode, Object> buildObjectValueConverter(JsonToRowDataConverters.JsonToRowDataConverter converter) {
        return arg_0 -> ((JsonToRowDataConverters.JsonToRowDataConverter)converter).convert(arg_0);
    }
}

