/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.gateway.service.operation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.execution.JobClient;
import org.apache.flink.table.api.CatalogNotExistException;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.internal.TableEnvironmentInternal;
import org.apache.flink.table.api.internal.TableResultInternal;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.ContextResolvedFunction;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ResolvedCatalogBaseTable;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.catalog.UnresolvedIdentifier;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.functions.FunctionIdentifier;
import org.apache.flink.table.gateway.api.operation.OperationHandle;
import org.apache.flink.table.gateway.api.results.FunctionInfo;
import org.apache.flink.table.gateway.api.results.TableInfo;
import org.apache.flink.table.gateway.service.context.SessionContext;
import org.apache.flink.table.gateway.service.result.ResultFetcher;
import org.apache.flink.table.gateway.service.utils.SqlExecutionException;
import org.apache.flink.table.operations.BeginStatementSetOperation;
import org.apache.flink.table.operations.EndStatementSetOperation;
import org.apache.flink.table.operations.ModifyOperation;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.operations.StatementSetOperation;
import org.apache.flink.table.operations.command.ResetOperation;
import org.apache.flink.table.operations.command.SetOperation;
import org.apache.flink.table.types.DataType;
import org.apache.flink.util.CloseableIterator;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(OperationExecutor.class);
    private final SessionContext sessionContext;
    private final Configuration executionConfig;

    @VisibleForTesting
    public OperationExecutor(SessionContext context, Configuration executionConfig) {
        this.sessionContext = context;
        this.executionConfig = executionConfig;
    }

    public ResultFetcher executeStatement(OperationHandle handle, String statement) {
        TableEnvironmentInternal tableEnv = this.getTableEnvironment();
        List parsedOperations = tableEnv.getParser().parse(statement);
        if (parsedOperations.size() > 1) {
            throw new UnsupportedOperationException("Unsupported SQL statement! Execute statement only accepts a single SQL statement or multiple 'INSERT INTO' statements wrapped in a 'STATEMENT SET' block.");
        }
        Operation op = (Operation)parsedOperations.get(0);
        if (op instanceof SetOperation) {
            return this.callSetOperation(tableEnv, handle, (SetOperation)op);
        }
        if (op instanceof ResetOperation) {
            return this.callResetOperation(handle, (ResetOperation)op);
        }
        if (op instanceof BeginStatementSetOperation) {
            throw new UnsupportedOperationException();
        }
        if (op instanceof EndStatementSetOperation) {
            throw new UnsupportedOperationException();
        }
        if (op instanceof ModifyOperation) {
            return this.callModifyOperations(tableEnv, handle, Collections.singletonList((ModifyOperation)op));
        }
        if (op instanceof StatementSetOperation) {
            return this.callModifyOperations(tableEnv, handle, ((StatementSetOperation)op).getOperations());
        }
        if (op instanceof QueryOperation) {
            TableResultInternal result = tableEnv.executeInternal(op);
            return new ResultFetcher(handle, result.getResolvedSchema(), (CloseableIterator<RowData>)result.collectInternal());
        }
        TableResultInternal result = tableEnv.executeInternal(op);
        return new ResultFetcher(handle, result.getResolvedSchema(), this.collect((Iterator<RowData>)result.collectInternal()));
    }

    public String getCurrentCatalog() {
        return this.sessionContext.getSessionState().catalogManager.getCurrentCatalog();
    }

    public Set<String> listCatalogs() {
        return this.sessionContext.getSessionState().catalogManager.listCatalogs();
    }

    public Set<String> listDatabases(String catalogName) {
        return new HashSet<String>(((Catalog)this.sessionContext.getSessionState().catalogManager.getCatalog(catalogName).orElseThrow(() -> new CatalogNotExistException(String.format("Catalog '%s' does not exist.", catalogName)))).listDatabases());
    }

    public Set<TableInfo> listTables(String catalogName, String databaseName, Set<CatalogBaseTable.TableKind> tableKinds) {
        Preconditions.checkArgument((boolean)Arrays.asList(CatalogBaseTable.TableKind.TABLE, CatalogBaseTable.TableKind.VIEW).containsAll(tableKinds), (Object)"Currently only support to list TABLE, VIEW or TABLE AND VIEW.");
        if (tableKinds.contains(CatalogBaseTable.TableKind.TABLE) && tableKinds.contains(CatalogBaseTable.TableKind.VIEW)) {
            return this.listTables(catalogName, databaseName, true);
        }
        if (tableKinds.contains(CatalogBaseTable.TableKind.TABLE)) {
            return this.listTables(catalogName, databaseName, false);
        }
        return this.listViews(catalogName, databaseName);
    }

    public ResolvedCatalogBaseTable<?> getTable(ObjectIdentifier tableIdentifier) {
        return this.getTableEnvironment().getCatalogManager().getTableOrError(tableIdentifier).getResolvedTable();
    }

    public Set<FunctionInfo> listUserDefinedFunctions(String catalogName, String databaseName) {
        return this.sessionContext.getSessionState().functionCatalog.getUserDefinedFunctions(catalogName, databaseName).stream().map(FunctionInfo::new).collect(Collectors.toSet());
    }

    public Set<FunctionInfo> listSystemFunctions() {
        HashSet<FunctionInfo> info = new HashSet<FunctionInfo>();
        for (String functionName : this.sessionContext.getSessionState().moduleManager.listFunctions()) {
            try {
                info.add(this.sessionContext.getSessionState().moduleManager.getFunctionDefinition(functionName).map(definition -> new FunctionInfo(FunctionIdentifier.of((String)functionName), definition.getKind())).orElse(new FunctionInfo(FunctionIdentifier.of((String)functionName))));
            }
            catch (Throwable t) {
                LOG.error(String.format("Failed to load the system function `%s`.", functionName), t);
            }
        }
        return info;
    }

    public FunctionDefinition getFunctionDefinition(UnresolvedIdentifier identifier) {
        return ((ContextResolvedFunction)this.sessionContext.getSessionState().functionCatalog.lookupFunction(identifier).orElseThrow(() -> new IllegalArgumentException(String.format("Can not find the definition: %s.", identifier.asSummaryString())))).getDefinition();
    }

    @VisibleForTesting
    public TableEnvironmentInternal getTableEnvironment() {
        TableEnvironmentInternal tableEnv = this.sessionContext.createTableEnvironment();
        tableEnv.getConfig().getConfiguration().addAll(this.executionConfig);
        return tableEnv;
    }

    private ResultFetcher callSetOperation(TableEnvironmentInternal tableEnv, OperationHandle handle, SetOperation setOp) {
        if (setOp.getKey().isPresent() && setOp.getValue().isPresent()) {
            this.sessionContext.set(((String)setOp.getKey().get()).trim(), ((String)setOp.getValue().get()).trim());
            return new ResultFetcher(handle, TableResultInternal.TABLE_RESULT_OK.getResolvedSchema(), this.collect((Iterator<RowData>)TableResultInternal.TABLE_RESULT_OK.collectInternal()));
        }
        if (!setOp.getKey().isPresent() && !setOp.getValue().isPresent()) {
            Map configMap = tableEnv.getConfig().getConfiguration().toMap();
            return new ResultFetcher(handle, ResolvedSchema.of((Column[])new Column[]{Column.physical((String)"key", (DataType)DataTypes.STRING()), Column.physical((String)"value", (DataType)DataTypes.STRING())}), this.collect(configMap.entrySet().stream().map(entry -> GenericRowData.of((Object[])new Object[]{StringData.fromString((String)((String)entry.getKey())), StringData.fromString((String)((String)entry.getValue()))})).map(RowData.class::cast).iterator()));
        }
        throw new SqlExecutionException("Illegal SetOperation: " + setOp.asSummaryString());
    }

    private ResultFetcher callResetOperation(OperationHandle handle, ResetOperation resetOp) {
        if (resetOp.getKey().isPresent()) {
            this.sessionContext.reset(((String)resetOp.getKey().get()).trim());
        } else {
            this.sessionContext.reset();
        }
        return new ResultFetcher(handle, TableResultInternal.TABLE_RESULT_OK.getResolvedSchema(), this.collect((Iterator<RowData>)TableResultInternal.TABLE_RESULT_OK.collectInternal()));
    }

    private ResultFetcher callModifyOperations(TableEnvironmentInternal tableEnv, OperationHandle handle, List<ModifyOperation> modifyOperations) {
        TableResultInternal result = tableEnv.executeInternal(modifyOperations);
        return new ResultFetcher(handle, ResolvedSchema.of((Column[])new Column[]{Column.physical((String)"job id", (DataType)DataTypes.STRING())}), Collections.singletonList(GenericRowData.of((Object[])new Object[]{StringData.fromString((String)((JobClient)result.getJobClient().orElseThrow(() -> new SqlExecutionException(String.format("Can't get job client for the operation %s.", handle)))).getJobID().toString())})));
    }

    private Set<TableInfo> listTables(String catalogName, String databaseName, boolean includeViews) {
        CatalogManager catalogManager = this.sessionContext.getSessionState().catalogManager;
        HashMap views = new HashMap();
        catalogManager.listViews(catalogName, databaseName).forEach(name -> views.put(name, new TableInfo(ObjectIdentifier.of((String)catalogName, (String)databaseName, (String)name), CatalogBaseTable.TableKind.VIEW)));
        HashMap ans = new HashMap();
        if (includeViews) {
            ans.putAll(views);
        }
        catalogManager.listTables(catalogName, databaseName).stream().filter(name -> !views.containsKey(name)).forEach(name -> ans.put(name, new TableInfo(ObjectIdentifier.of((String)catalogName, (String)databaseName, (String)name), CatalogBaseTable.TableKind.TABLE)));
        return Collections.unmodifiableSet(new HashSet(ans.values()));
    }

    private Set<TableInfo> listViews(String catalogName, String databaseName) {
        return Collections.unmodifiableSet(this.sessionContext.getSessionState().catalogManager.listViews(catalogName, databaseName).stream().map(name -> new TableInfo(ObjectIdentifier.of((String)catalogName, (String)databaseName, (String)name), CatalogBaseTable.TableKind.VIEW)).collect(Collectors.toSet()));
    }

    private List<RowData> collect(Iterator<RowData> tableResult) {
        ArrayList<RowData> rows = new ArrayList<RowData>();
        tableResult.forEachRemaining(rows::add);
        return rows;
    }
}

