/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.gateway.service.session;

import java.io.Closeable;
import java.util.Map;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.gateway.api.endpoint.EndpointVersion;
import org.apache.flink.table.gateway.api.session.SessionHandle;
import org.apache.flink.table.gateway.service.context.SessionContext;
import org.apache.flink.table.gateway.service.operation.OperationExecutor;
import org.apache.flink.table.gateway.service.operation.OperationManager;

public class Session
implements Closeable {
    private final SessionContext sessionContext;
    private volatile long lastAccessTime;

    public Session(SessionContext sessionContext) {
        this.sessionContext = sessionContext;
        this.lastAccessTime = System.currentTimeMillis();
    }

    public void touch() {
        this.lastAccessTime = System.currentTimeMillis();
    }

    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    public SessionHandle getSessionHandle() {
        return this.sessionContext.getSessionId();
    }

    public Map<String, String> getSessionConfig() {
        return this.sessionContext.getConfigMap();
    }

    public EndpointVersion getEndpointVersion() {
        return this.sessionContext.getEndpointVersion();
    }

    public OperationManager getOperationManager() {
        return this.sessionContext.getOperationManager();
    }

    public OperationExecutor createExecutor() {
        return this.sessionContext.createOperationExecutor(new Configuration());
    }

    public OperationExecutor createExecutor(Configuration executionConfig) {
        return this.sessionContext.createOperationExecutor(executionConfig);
    }

    @Override
    public void close() {
        this.sessionContext.close();
    }
}

