/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.changelog;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.util.Preconditions;

@Internal
public enum StateChangeOperation {
    CLEAR(0),
    SET(1),
    SET_INTERNAL(2),
    ADD(3),
    MERGE_NS(4),
    ADD_ELEMENT(5),
    ADD_OR_UPDATE_ELEMENT(6),
    REMOVE_ELEMENT(7),
    METADATA(8);

    private final byte code;
    private static final Map<Byte, StateChangeOperation> BY_CODES;

    private StateChangeOperation(byte code) {
        this.code = code;
    }

    public static StateChangeOperation byCode(byte opCode) {
        return (StateChangeOperation)((Object)Preconditions.checkNotNull((Object)((Object)BY_CODES.get(opCode)), (String)Byte.toString(opCode)));
    }

    public byte getCode() {
        return this.code;
    }

    static {
        BY_CODES = Arrays.stream(StateChangeOperation.values()).collect(Collectors.toMap(o -> o.code, Function.identity()));
    }
}

