/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.common;

import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.metrics.ThreadSafeSimpleCounter;
import org.apache.flink.runtime.metrics.groups.ProxyMetricGroup;

@Internal
public class ChangelogMaterializationMetricGroup
extends ProxyMetricGroup<MetricGroup> {
    private static final String PREFIX = "ChangelogMaterialization";
    @VisibleForTesting
    public static final String STARTED_MATERIALIZATION = "ChangelogMaterialization.startedMaterialization";
    @VisibleForTesting
    public static final String COMPLETED_MATERIALIZATION = "ChangelogMaterialization.completedMaterialization";
    @VisibleForTesting
    public static final String FAILED_MATERIALIZATION = "ChangelogMaterialization.failedMaterialization";
    @VisibleForTesting
    public static final String LAST_DURATION_OF_MATERIALIZATION = "ChangelogMaterialization.lastDurationOfMaterialization";
    private final Counter startedMaterializationCounter = this.counter("ChangelogMaterialization.startedMaterialization", (Counter)new ThreadSafeSimpleCounter());
    private final Counter completedMaterializationCounter = this.counter("ChangelogMaterialization.completedMaterialization", (Counter)new ThreadSafeSimpleCounter());
    private final Counter failedMaterializationCounter = this.counter("ChangelogMaterialization.failedMaterialization", (Counter)new ThreadSafeSimpleCounter());
    private volatile long lastDuration = -1L;

    public ChangelogMaterializationMetricGroup(MetricGroup parentMetricGroup) {
        super(parentMetricGroup);
        this.gauge(LAST_DURATION_OF_MATERIALIZATION, () -> this.lastDuration);
    }

    void reportStartedMaterialization() {
        this.startedMaterializationCounter.inc();
    }

    void reportCompletedMaterialization(long duration) {
        this.completedMaterializationCounter.inc();
        this.lastDuration = duration;
    }

    void reportFailedMaterialization() {
        this.failedMaterializationCounter.inc();
    }
}

