/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.common;

import java.io.Closeable;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.operators.MailboxExecutor;
import org.apache.flink.core.fs.FileSystemSafetyNet;
import org.apache.flink.runtime.state.KeyedStateHandle;
import org.apache.flink.runtime.state.SnapshotResult;
import org.apache.flink.runtime.state.StateObject;
import org.apache.flink.runtime.state.changelog.SequenceNumber;
import org.apache.flink.runtime.taskmanager.AsyncExceptionHandler;
import org.apache.flink.state.common.ChangelogMaterializationMetricGroup;
import org.apache.flink.util.MathUtils;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.concurrent.ExecutorThreadFactory;
import org.apache.flink.util.concurrent.FutureUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class PeriodicMaterializationManager
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(PeriodicMaterializationManager.class);
    private final MailboxExecutor mailboxExecutor;
    private final ExecutorService asyncOperationsThreadPool;
    private final ScheduledExecutorService periodicExecutor;
    private final AsyncExceptionHandler asyncExceptionHandler;
    private final String subtaskName;
    private final boolean isPeriodicMaterializeEnabled;
    private final long periodicMaterializeDelay;
    private final int allowedNumberOfFailures;
    private final AtomicInteger numberOfConsecutiveFailures;
    private final MaterializationTarget target;
    private final ChangelogMaterializationMetricGroup metrics;
    private boolean started = false;
    private final long initialDelay;

    public PeriodicMaterializationManager(MailboxExecutor mailboxExecutor, ExecutorService asyncOperationsThreadPool, String subtaskName, AsyncExceptionHandler asyncExceptionHandler, MaterializationTarget target, ChangelogMaterializationMetricGroup metricGroup, boolean isPeriodicMaterializeEnabled, long periodicMaterializeDelay, int allowedNumberOfFailures, String operatorSubtaskId) {
        this(mailboxExecutor, asyncOperationsThreadPool, subtaskName, asyncExceptionHandler, target, metricGroup, isPeriodicMaterializeEnabled, periodicMaterializeDelay, allowedNumberOfFailures, operatorSubtaskId, Executors.newSingleThreadScheduledExecutor((ThreadFactory)new ExecutorThreadFactory("periodic-materialization-scheduler-" + subtaskName)));
    }

    PeriodicMaterializationManager(MailboxExecutor mailboxExecutor, ExecutorService asyncOperationsThreadPool, String subtaskName, AsyncExceptionHandler asyncExceptionHandler, MaterializationTarget target, ChangelogMaterializationMetricGroup metricGroup, boolean isPeriodicMaterializeEnabled, long periodicMaterializeDelay, int allowedNumberOfFailures, String operatorSubtaskId, ScheduledExecutorService periodicExecutor) {
        this.mailboxExecutor = (MailboxExecutor)Preconditions.checkNotNull((Object)mailboxExecutor);
        this.asyncOperationsThreadPool = (ExecutorService)Preconditions.checkNotNull((Object)asyncOperationsThreadPool);
        this.subtaskName = (String)Preconditions.checkNotNull((Object)subtaskName);
        this.asyncExceptionHandler = (AsyncExceptionHandler)Preconditions.checkNotNull((Object)asyncExceptionHandler);
        this.metrics = metricGroup;
        this.target = (MaterializationTarget)Preconditions.checkNotNull((Object)target);
        this.isPeriodicMaterializeEnabled = isPeriodicMaterializeEnabled;
        this.periodicMaterializeDelay = periodicMaterializeDelay;
        this.allowedNumberOfFailures = allowedNumberOfFailures;
        this.numberOfConsecutiveFailures = new AtomicInteger(0);
        this.periodicExecutor = periodicExecutor;
        this.initialDelay = (long)MathUtils.murmurHash((int)operatorSubtaskId.hashCode()) % periodicMaterializeDelay;
    }

    public void start() {
        if (this.isPeriodicMaterializeEnabled) {
            if (!this.started) {
                this.started = true;
                LOG.info("Task {} starts periodic materialization", (Object)this.subtaskName);
                this.scheduleNextMaterialization(this.initialDelay);
            }
        } else {
            LOG.info("Task {} disable periodic materialization", (Object)this.subtaskName);
        }
    }

    @Override
    public synchronized void close() {
        LOG.info("Shutting down PeriodicMaterializationManager.");
        if (!this.periodicExecutor.isShutdown()) {
            this.periodicExecutor.shutdownNow();
        }
    }

    @VisibleForTesting
    public void triggerMaterialization() {
        this.mailboxExecutor.execute(() -> {
            Optional<MaterializationRunnable> materializationRunnableOptional;
            long triggerTime = System.currentTimeMillis();
            this.metrics.reportStartedMaterialization();
            try {
                materializationRunnableOptional = this.target.initMaterialization();
            }
            catch (Exception ex) {
                this.metrics.reportFailedMaterialization();
                throw ex;
            }
            if (materializationRunnableOptional.isPresent()) {
                MaterializationRunnable runnable = materializationRunnableOptional.get();
                this.asyncOperationsThreadPool.execute(() -> this.asyncMaterializationPhase(triggerTime, runnable.getMaterializationRunnable(), runnable.getMaterializationID(), runnable.getMaterializedTo()));
            } else {
                this.metrics.reportCompletedMaterialization(System.currentTimeMillis() - triggerTime);
                this.scheduleNextMaterialization();
                LOG.info("Task {} has no state updates since last materialization, skip this one and schedule the next one in {} seconds", (Object)this.subtaskName, (Object)(this.periodicMaterializeDelay / 1000L));
            }
        }, "materialization");
    }

    private void asyncMaterializationPhase(long triggerTime, RunnableFuture<SnapshotResult<KeyedStateHandle>> materializedRunnableFuture, long materializationID, SequenceNumber upTo) {
        this.uploadSnapshot(materializedRunnableFuture).whenComplete((snapshotResult, throwable) -> {
            if (throwable == null) {
                this.numberOfConsecutiveFailures.set(0);
                this.mailboxExecutor.execute(() -> {
                    try {
                        this.target.handleMaterializationResult((SnapshotResult<KeyedStateHandle>)snapshotResult, materializationID, upTo);
                        this.metrics.reportCompletedMaterialization(System.currentTimeMillis() - triggerTime);
                    }
                    catch (Exception ex) {
                        this.metrics.reportFailedMaterialization();
                    }
                }, "Task %s update materializedSnapshot up to changelog sequence number: %s.", new Object[]{this.subtaskName, upTo});
                this.scheduleNextMaterialization();
            } else if (throwable instanceof CancellationException) {
                LOG.info("materialization cancelled", throwable);
                this.notifyFailureOrCancellation(materializationID, upTo, (Throwable)throwable);
                this.scheduleNextMaterialization();
            } else {
                this.notifyFailureOrCancellation(materializationID, upTo, (Throwable)throwable);
                this.metrics.reportFailedMaterialization();
                int retryTime = this.numberOfConsecutiveFailures.incrementAndGet();
                if (retryTime <= this.allowedNumberOfFailures) {
                    LOG.info("Task {} asynchronous part of materialization is not completed for the {} time.", new Object[]{this.subtaskName, retryTime, throwable});
                    this.scheduleNextMaterialization();
                } else {
                    this.asyncExceptionHandler.handleAsyncException("Task " + this.subtaskName + " fails to complete the asynchronous part of materialization", throwable);
                }
            }
        });
    }

    private void notifyFailureOrCancellation(long materializationId, SequenceNumber upTo, Throwable cause) {
        this.mailboxExecutor.execute(() -> this.target.handleMaterializationFailureOrCancellation(materializationId, upTo, cause), "Task %s materialization: %d, upTo: %s, failed or canceled.", new Object[]{this.subtaskName, materializationId, upTo});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<SnapshotResult<KeyedStateHandle>> uploadSnapshot(RunnableFuture<SnapshotResult<KeyedStateHandle>> materializedRunnableFuture) {
        FileSystemSafetyNet.initializeSafetyNetForThread();
        CompletableFuture<SnapshotResult<KeyedStateHandle>> result = new CompletableFuture<SnapshotResult<KeyedStateHandle>>();
        try {
            FutureUtils.runIfNotDoneAndGet(materializedRunnableFuture);
            LOG.debug("Task {} finishes asynchronous part of materialization.", (Object)this.subtaskName);
            result.complete((SnapshotResult<KeyedStateHandle>)materializedRunnableFuture.get());
        }
        catch (Exception e) {
            result.completeExceptionally(e);
            this.discardFailedUploads(materializedRunnableFuture);
        }
        finally {
            FileSystemSafetyNet.closeSafetyNetAndGuardedResourcesForThread();
        }
        return result;
    }

    private void discardFailedUploads(RunnableFuture<SnapshotResult<KeyedStateHandle>> materializedRunnableFuture) {
        LOG.info("Task {} cleanup asynchronous runnable for materialization.", (Object)this.subtaskName);
        if (materializedRunnableFuture != null && !materializedRunnableFuture.cancel(true)) {
            try {
                StateObject stateObject = (StateObject)materializedRunnableFuture.get();
                if (stateObject != null) {
                    stateObject.discardState();
                }
            }
            catch (Exception ex) {
                LOG.debug("Task " + this.subtaskName + " cancelled execution of snapshot future runnable. Cancellation produced the following exception, which is expected and can be ignored.", (Throwable)ex);
            }
        }
    }

    private void scheduleNextMaterialization() {
        this.scheduleNextMaterialization(this.periodicMaterializeDelay);
    }

    private synchronized void scheduleNextMaterialization(long delay) {
        if (this.started && !this.periodicExecutor.isShutdown()) {
            LOG.info("Task {} schedules the next materialization in {} seconds", (Object)this.subtaskName, (Object)(delay / 1000L));
            this.periodicExecutor.schedule(this::triggerMaterialization, delay, TimeUnit.MILLISECONDS);
        }
    }

    public static class MaterializationRunnable {
        private final RunnableFuture<SnapshotResult<KeyedStateHandle>> materializationRunnable;
        private final long materializationID;
        private final SequenceNumber materializedTo;

        public MaterializationRunnable(RunnableFuture<SnapshotResult<KeyedStateHandle>> materializationRunnable, long materializationID, SequenceNumber materializedTo) {
            this.materializationRunnable = materializationRunnable;
            this.materializedTo = materializedTo;
            this.materializationID = materializationID;
        }

        RunnableFuture<SnapshotResult<KeyedStateHandle>> getMaterializationRunnable() {
            return this.materializationRunnable;
        }

        public SequenceNumber getMaterializedTo() {
            return this.materializedTo;
        }

        public long getMaterializationID() {
            return this.materializationID;
        }
    }

    @NotThreadSafe
    public static interface MaterializationTarget {
        public static final MaterializationTarget NO_OP = new MaterializationTarget(){

            @Override
            public Optional<MaterializationRunnable> initMaterialization() {
                return Optional.empty();
            }

            @Override
            public void handleMaterializationResult(SnapshotResult<KeyedStateHandle> materializedSnapshot, long materializationID, SequenceNumber upTo) {
            }

            @Override
            public void handleMaterializationFailureOrCancellation(long materializationID, SequenceNumber upTo, Throwable cause) {
            }
        };

        public Optional<MaterializationRunnable> initMaterialization() throws Exception;

        public void handleMaterializationResult(SnapshotResult<KeyedStateHandle> var1, long var2, SequenceNumber var4) throws Exception;

        public void handleMaterializationFailureOrCancellation(long var1, SequenceNumber var3, Throwable var4);
    }
}

