/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.contrib.streaming.state;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.state.StateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.ListSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.contrib.streaming.state.AbstractRocksDBState;
import org.apache.flink.contrib.streaming.state.RocksDBKeyedStateBackend;
import org.apache.flink.core.memory.DataInputDeserializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputSerializer;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.state.RegisteredKeyValueStateBackendMetaInfo;
import org.apache.flink.runtime.state.StateSnapshotTransformer;
import org.apache.flink.runtime.state.internal.InternalListState;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.StateMigrationException;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.RocksDBException;

class RocksDBListState<K, N, V>
extends AbstractRocksDBState<K, N, List<V>>
implements InternalListState<K, N, V> {
    private final TypeSerializer<V> elementSerializer;
    private static final byte DELIMITER = 44;

    private RocksDBListState(ColumnFamilyHandle columnFamily, TypeSerializer<N> namespaceSerializer, TypeSerializer<List<V>> valueSerializer, List<V> defaultValue, RocksDBKeyedStateBackend<K> backend) {
        super(columnFamily, namespaceSerializer, valueSerializer, defaultValue, backend);
        ListSerializer castedListSerializer = (ListSerializer)valueSerializer;
        this.elementSerializer = castedListSerializer.getElementSerializer();
    }

    public TypeSerializer<K> getKeySerializer() {
        return this.backend.getKeySerializer();
    }

    public TypeSerializer<N> getNamespaceSerializer() {
        return this.namespaceSerializer;
    }

    public TypeSerializer<List<V>> getValueSerializer() {
        return this.valueSerializer;
    }

    public Iterable<V> get() {
        return this.getInternal();
    }

    public List<V> getInternal() {
        try {
            byte[] key = this.serializeCurrentKeyWithGroupAndNamespace();
            byte[] valueBytes = this.backend.db.get(this.columnFamily, key);
            return this.deserializeList(valueBytes);
        }
        catch (RocksDBException e) {
            throw new FlinkRuntimeException("Error while retrieving data from RocksDB", (Throwable)e);
        }
    }

    private List<V> deserializeList(byte[] valueBytes) {
        V next;
        if (valueBytes == null) {
            return null;
        }
        this.dataInputView.setBuffer(valueBytes);
        ArrayList<V> result = new ArrayList<V>();
        while ((next = RocksDBListState.deserializeNextElement(this.dataInputView, this.elementSerializer)) != null) {
            result.add(next);
        }
        return result;
    }

    private static <V> V deserializeNextElement(DataInputDeserializer in, TypeSerializer<V> elementSerializer) {
        try {
            if (in.available() > 0) {
                Object element = elementSerializer.deserialize((DataInputView)in);
                if (in.available() > 0) {
                    in.readByte();
                }
                return (V)element;
            }
        }
        catch (IOException e) {
            throw new FlinkRuntimeException("Unexpected list element deserialization failure", (Throwable)e);
        }
        return null;
    }

    public void add(V value) {
        Preconditions.checkNotNull(value, (String)"You cannot add null to a ListState.");
        try {
            this.backend.db.merge(this.columnFamily, this.writeOptions, this.serializeCurrentKeyWithGroupAndNamespace(), this.serializeValue(value, this.elementSerializer));
        }
        catch (Exception e) {
            throw new FlinkRuntimeException("Error while adding data to RocksDB", (Throwable)e);
        }
    }

    public void mergeNamespaces(N target, Collection<N> sources) {
        if (sources == null || sources.isEmpty()) {
            return;
        }
        try {
            this.setCurrentNamespace(target);
            byte[] targetKey = this.serializeCurrentKeyWithGroupAndNamespace();
            for (N source : sources) {
                if (source == null) continue;
                this.setCurrentNamespace(source);
                byte[] sourceKey = this.serializeCurrentKeyWithGroupAndNamespace();
                byte[] valueBytes = this.backend.db.get(this.columnFamily, sourceKey);
                if (valueBytes == null) continue;
                this.backend.db.delete(this.columnFamily, this.writeOptions, sourceKey);
                this.backend.db.merge(this.columnFamily, this.writeOptions, targetKey, valueBytes);
            }
        }
        catch (Exception e) {
            throw new FlinkRuntimeException("Error while merging state in RocksDB", (Throwable)e);
        }
    }

    public void update(List<V> valueToStore) {
        this.updateInternal(valueToStore);
    }

    public void updateInternal(List<V> values) {
        Preconditions.checkNotNull(values, (String)"List of values to add cannot be null.");
        if (!values.isEmpty()) {
            try {
                this.backend.db.put(this.columnFamily, this.writeOptions, this.serializeCurrentKeyWithGroupAndNamespace(), this.serializeValueList(values, this.elementSerializer, (byte)44));
            }
            catch (IOException | RocksDBException e) {
                throw new FlinkRuntimeException("Error while updating data to RocksDB", e);
            }
        } else {
            this.clear();
        }
    }

    public void addAll(List<V> values) {
        Preconditions.checkNotNull(values, (String)"List of values to add cannot be null.");
        if (!values.isEmpty()) {
            try {
                this.backend.db.merge(this.columnFamily, this.writeOptions, this.serializeCurrentKeyWithGroupAndNamespace(), this.serializeValueList(values, this.elementSerializer, (byte)44));
            }
            catch (IOException | RocksDBException e) {
                throw new FlinkRuntimeException("Error while updating data to RocksDB", e);
            }
        }
    }

    @Override
    public void migrateSerializedValue(DataInputDeserializer serializedOldValueInput, DataOutputSerializer serializedMigratedValueOutput, TypeSerializer<List<V>> priorSerializer, TypeSerializer<List<V>> newSerializer) throws StateMigrationException {
        Preconditions.checkArgument((boolean)(priorSerializer instanceof ListSerializer));
        Preconditions.checkArgument((boolean)(newSerializer instanceof ListSerializer));
        TypeSerializer priorElementSerializer = ((ListSerializer)priorSerializer).getElementSerializer();
        TypeSerializer newElementSerializer = ((ListSerializer)newSerializer).getElementSerializer();
        try {
            while (serializedOldValueInput.available() > 0) {
                V element = RocksDBListState.deserializeNextElement(serializedOldValueInput, priorElementSerializer);
                newElementSerializer.serialize(element, (DataOutputView)serializedMigratedValueOutput);
                if (serializedOldValueInput.available() <= 0) continue;
                serializedMigratedValueOutput.write(44);
            }
        }
        catch (Exception e) {
            throw new StateMigrationException("Error while trying to migrate RocksDB list state.", (Throwable)e);
        }
    }

    static <E, K, N, SV, S extends State, IS extends S> IS create(StateDescriptor<S, SV> stateDesc, Tuple2<ColumnFamilyHandle, RegisteredKeyValueStateBackendMetaInfo<N, SV>> registerResult, RocksDBKeyedStateBackend<K> backend) {
        return (IS)new RocksDBListState((ColumnFamilyHandle)registerResult.f0, ((RegisteredKeyValueStateBackendMetaInfo)registerResult.f1).getNamespaceSerializer(), ((RegisteredKeyValueStateBackendMetaInfo)registerResult.f1).getStateSerializer(), (List)stateDesc.getDefaultValue(), backend);
    }

    static class StateSnapshotTransformerWrapper<T>
    implements StateSnapshotTransformer<byte[]> {
        private final StateSnapshotTransformer<T> elementTransformer;
        private final TypeSerializer<T> elementSerializer;
        private final DataOutputSerializer out = new DataOutputSerializer(128);
        private final StateSnapshotTransformer.CollectionStateSnapshotTransformer.TransformStrategy transformStrategy;

        StateSnapshotTransformerWrapper(StateSnapshotTransformer<T> elementTransformer, TypeSerializer<T> elementSerializer) {
            this.elementTransformer = elementTransformer;
            this.elementSerializer = elementSerializer;
            this.transformStrategy = elementTransformer instanceof StateSnapshotTransformer.CollectionStateSnapshotTransformer ? ((StateSnapshotTransformer.CollectionStateSnapshotTransformer)elementTransformer).getFilterStrategy() : StateSnapshotTransformer.CollectionStateSnapshotTransformer.TransformStrategy.TRANSFORM_ALL;
        }

        @Nullable
        public byte[] filterOrTransform(@Nullable byte[] value) {
            Object next;
            if (value == null) {
                return null;
            }
            ArrayList<Object> result = new ArrayList<Object>();
            DataInputDeserializer in = new DataInputDeserializer(value);
            int prevPosition = 0;
            while ((next = RocksDBListState.deserializeNextElement(in, this.elementSerializer)) != null) {
                Object transformedElement = this.elementTransformer.filterOrTransform(next);
                if (transformedElement != null) {
                    if (this.transformStrategy == StateSnapshotTransformer.CollectionStateSnapshotTransformer.TransformStrategy.STOP_ON_FIRST_INCLUDED) {
                        return Arrays.copyOfRange(value, prevPosition, value.length);
                    }
                    result.add(transformedElement);
                }
                prevPosition = in.getPosition();
            }
            try {
                return result.isEmpty() ? null : this.serializeValueList(result, this.elementSerializer, (byte)44);
            }
            catch (IOException e) {
                throw new FlinkRuntimeException("Failed to serialize transformed list", (Throwable)e);
            }
        }

        byte[] serializeValueList(List<T> valueList, TypeSerializer<T> elementSerializer, byte delimiter) throws IOException {
            this.out.clear();
            boolean first = true;
            for (T value : valueList) {
                Preconditions.checkNotNull(value, (String)"You cannot add null to a value list.");
                if (first) {
                    first = false;
                } else {
                    this.out.write((int)delimiter);
                }
                elementSerializer.serialize(value, (DataOutputView)this.out);
            }
            return this.out.getCopyOfBuffer();
        }
    }
}

